<?php

namespace App\DataTables;

use App\Facades\UtilityFacades;
use App\Models\CardDetails;
use App\Models\Test;
use App\Models\User;
use App\Models\WithdrawRequests;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\EloquentDataTable;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class WithdrawDataTable extends DataTable
{
    /**
     * Build the DataTable class.
     *
     * @param QueryBuilder $query Results from query() method.
     */
    public function dataTable(QueryBuilder $query): EloquentDataTable
    {
       

        return (new EloquentDataTable($query))
            ->editColumn('created_at', function ($request) {
                return UtilityFacades::date_time_format($request->created_at);
            })
            ->editColumn('amount', function ($request) {
                return UtilityFacades::getValByName('currency_symbol').$request->amount;
            })
            ->addColumn('user_id', function (WithdrawRequests $card) {
               return $card->Userdetails->first_name.' '. $card->Userdetails->last_name.'<br>+'. $card->Userdetails->country_code.$card->Userdetails->phone;
            })
            ->editColumn('status', function (WithdrawRequests $card) {
                if ($card->status == 1) {
                    $output = '<label class="badge badge-success">Approved</label>';
                } else if ($card->status == 1) {
                $output = '<label class="badge badge-danger">Rejected</label>';
            }else {
                $output = '<label class="badge badge-warning">Pending</label>';
                }
                return $output;
            })
            ->addColumn('action', function (WithdrawRequests $card) {
                return view('users.withdraw_action', compact('card'));
            })

            ->rawColumns(['action', 'status', 'user_id']);
    }

    /**
     * Get the query source of dataTable.
     */
    public function query(WithdrawRequests $model): QueryBuilder
    {
        return $model->newQuery()->where('status', 0);
    }

    /**
     * Optional method if you want to use the html builder.
     */
    public function html(): HtmlBuilder
    {
        return $this->builder()
            ->setTableId('users-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->language([
                "paginate" => [
                    "next" => '<i class="fas fa-angle-right"></i>',
                    "previous" => '<i class="fas fa-angle-left"></i>'
                ]
            ])
            ->parameters([
                "dom" =>  "
                                <'row'<'col-sm-12'><'col-sm-9 text-left'B><'col-sm-3'f>>
                                <'row'<'col-sm-12'tr>>
                                <'row mt-3'<'col-sm-5'i><'col-sm-7'p>>
                                ",
                'buttons'   => [
                    ['extend' => 'export', 'className' => 'btn btn-primary btn-sm no-corner',],
                    ['extend' => 'print', 'className' => 'btn btn-primary btn-sm no-corner',],
                    ['extend' => 'reset', 'className' => 'btn btn-primary btn-sm no-corner',],
                    ['extend' => 'reload', 'className' => 'btn btn-primary btn-sm no-corner',],
                    ['extend' => 'pageLength', 'className' => 'btn btn-danger btn-sm no-corner',],
                ],
                "scrollX" => true
            ]);
    }

    /**
     * Get the dataTable columns definition.
     */
    public function getColumns(): array
    {
        return [

            Column::make('id'),
            Column::make('user_id')->title('User')->addClass('text-center'),
            Column::make('amount'),
            Column::make('payment_type'),
            Column::make('currency'),
            Column::make('created_at')->title('Date Created'),
            Column::make('status')->title('Status'),
            Column::computed('action')
            ->exportable(false)
                ->printable(false)
                ->width(200)
                ->addClass('text-center'),
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'Test_' . date('YmdHis');
    }
}
