<?php

namespace App\Facades;

use App\Models\Content;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;

class Utility
{
    public function settings()
    {
        $data = DB::table('settings');
        $data = $data->get();
        $settings = [
            'date_format' => 'M j, Y',
            'time_format' => 'g:i A',
        ];
        foreach ($data as $row) {
            $settings[$row->key] = $row->value;
        }
        return $settings;
    }
    public function date_format($date)
    {
        return Carbon::parse($date)->format($this->getsettings('date_format'));
    }
    public function time_format($date)
    {
        return Carbon::parse($date)->format($this->getsettings('time_format'));
    }
    public function date_time_format($date)
    {
        return Carbon::parse($date)->format($this->getsettings('date_format') . ' ' . $this->getsettings('time_format'));
    }
    public function setEnvironmentValue(array $values)
    {
        $envFile = app()->environmentFilePath();
        $str = file_get_contents($envFile);
        if (count($values) > 0) {
            foreach ($values as $envKey => $envValue) {
                $keyPosition = strpos($str, "{$envKey}=");
                $endOfLinePosition = strpos($str, "\n", $keyPosition);
                $oldLine = substr($str, $keyPosition, $endOfLinePosition - $keyPosition);
                // If key does not exist, add it
                if (!$keyPosition || !$endOfLinePosition || !$oldLine) {
                    $str .= "{$envKey}='{$envValue}'\n";
                } else {
                    $str = str_replace($oldLine, "{$envKey}='{$envValue}'", $str);
                }
            }
        }
        $str = substr($str, 0, -1);
        $str .= "\n";
        if (!file_put_contents($envFile, $str)) {
            return false;
        }
        return true;
    }
    public function getValByName($key)
    {
        $setting = $this->settings();
        if (!isset($setting[$key]) || empty($setting[$key])) {
            $setting[$key] = '';
        }
        return $setting[$key];
    }
    public function languages()
    {
        $dir = base_path() . '/resources/lang/';
        $glob = glob($dir . '*', GLOB_ONLYDIR);
        $arrLang = array_map(
            function ($value) use ($dir) {
                return str_replace($dir, '', $value);
            },
            $glob
        );
        $arrLang = array_map(
            function ($value) use ($dir) {
                return preg_replace('/[0-9]+/', '', $value);
            },
            $arrLang
        );
        $arrLang = array_filter($arrLang);
        return $arrLang;
    }
    public function delete_directory($dir)
    {
        if (!file_exists($dir)) {
            return true;
        }
        if (!is_dir($dir)) {
            return unlink($dir);
        }
        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') {
                continue;
            }
            if (!self::delete_directory($dir . DIRECTORY_SEPARATOR . $item)) {
                return false;
            }
        }
        return rmdir($dir);
    }
    public function getsettings($value = '')
    {
        $setting = Setting::select('value');
      
        $set =  $setting->where('key', $value)->first();
        $val = '';
        if (!empty($set->value)) {
            $val = $set->value;
        }
        return $val;
    }

    public function uploadMedia($path = '',$media){
        $originalNameWithoutExtension = pathinfo($media->getClientOriginalName(), PATHINFO_FILENAME);

        $app_logo_name = $originalNameWithoutExtension . time() . '.' . $media->getClientOriginalExtension();
        $media->storeAs($path, $app_logo_name);
        return $app_logo_name;
    }
    public function getcontents($value = '',$page = '')
    {
        $setting = Content::select('value');

        $set =  $setting->where('page',$page)->where('key', $value)->first();
        $val = '';
        if (!empty($set->value)) {
            $val = $set->value;
        }
        return $val;
    }
    public function storeContent($formatted_array,$page)
    {
        $row = Content::where('page',$page)->where('key', $formatted_array['key'])->first();
        if (empty($row)) {
            Content::create($formatted_array);
        } else {
            $row->update($formatted_array);
        }
        $affected_row = Content::find($formatted_array['key']);
        return $affected_row;
    }
    public function storesettings($formatted_array)
    {
            $row = Setting::where('key', $formatted_array['key'])->first();
        if (empty($row)) {
            Setting::create($formatted_array);
        } else {
            $row->update($formatted_array);
        }
        $affected_row = Setting::find($formatted_array['key']);
        return $affected_row;
    }

    public function callPostApi($url, $data = array())
    {

        $token =  env('BRIDGECARD_TOKEN');

        $headers = [
            'token' => 'Bearer ' . $token,
            'Content-Type' => 'application/json'
        ];
        // dd($token);

        $client = new Client();




        try {
            $response = $client->post($url, [
                'body' => json_encode($data),
                'headers' => $headers
            ]);

            // dd($response);
            $responseData = json_decode($response->getBody(), true);
            return $responseData;
        } catch (\Exception $e) {

            // dd('Error: ' . $e->getMessage());
            return ['status' => false, 'message' => __($e->getMessage())];
            // die;
        }
    }

    public function callGetApi($url, $method = 'get', $data = array())
    {

        $token =  env('BRIDGECARD_TOKEN');

        $headers = [
            'token' => 'Bearer ' . $token,
        ];
        // dd($token);

        $client = new Client();

        try {
            if (!empty($data)) {
                $response = $client->$method($url, [
                    'body' => json_encode($data),
                    'headers' => $headers
                ]);
            } else {
                $response = $client->$method($url, [
                    'headers' => $headers
                ]);
            }

            // dd($response);
            $responseData = json_decode($response->getBody(), true);
            return $responseData;
        } catch (\Exception $e) {

            // dd('Error: ' . $e->getMessage());
            return ['status' => false, 'message' => 'Spmethimg went wrong in api response'];
            // die;
        }
    }
}
