<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Cities;
use App\Models\Plan;
use App\Models\User;
use Illuminate\Http\Request;
use CinetPay\CinetPay;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Storage;

class ApiController extends Controller
{

    public function mobileCheck(Request $request)
    {
        dd('jkjkhere');
        $validator = \Validator::make($request->all(), [
            'country_code' => 'required',
            'mobile' => 'required',
        ]);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'data' => ['message' => $messages->first()],
            ], 200);
        }

        $exist_mobile = User::where('mobile', $request->mobile)->first();

        if ($exist_mobile) {
            $exist_mobile->otp = 123456;
            $exist_mobile->save();


            if (Auth::login($exist_mobile)) {
                return response()->json(['is_success' => true, 'message' => 'Otp send sucessfully', 'data' => $exist_mobile], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
            }
        }
    }

    public function register(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
            'company_name' => 'required',
            'email' => 'required',
            'phone_no' => 'required'
        ]);
        if ($validate->fails()) {
            return response()->json(['ResponseCode' => '0', 'ResponseText' => 'Validation fail', 'ResponseData' => ['errors' => $validate->errors()->all()]], 499);
        }
        $user = new User();
        $user->first_name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->email = $request->email;
        $user->company_name = $request->company_name;
        $user->phone_no = $request->phone_no;
        $user->save();

        if ($user) {
            return response()->json(['is_success' => true, 'message' => 'user created sucessfully', 'data' => $user], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
        }
    }

    public function getProfile($id)
    {
        $user_details = User::where('id', $id)->get()->first();

        if ($user_details) {
            return response()->json(['is_success' => true, 'message' => 'user created sucessfully', 'data' => $user], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
        }
    }

    public function documentVerification(Request $request, $id)
    {
        $user = User::find($id);
        //---------------------For document 1-------------------------
        if ($request->hasFile('document_1')) {
            $filenameWithExt = $request->file('document_1')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('document_1')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $dir             = storage_path('documents/');

            if (!file_exists($dir)) {

                mkdir($dir, 0777, true);
            }
            $path = $request->file('document_1')->storeAs('documents/', $fileNameToStore);
        }

        if (!empty($request->document_1)) {
            $user->document_1 = $fileNameToStore;
        }

        //---------------------For document 2-------------------------
        if ($request->hasFile('document_2')) {
            $filenameWithExt = $request->file('document_2')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('document_2')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $dir             = storage_path('documents/');

            if (!file_exists($dir)) {

                mkdir($dir, 0777, true);
            }
            $path = $request->file('document_2')->storeAs('documents/', $fileNameToStore);
        }

        if (!empty($request->document_2)) {
            $user->document_2 = $fileNameToStore;
        }

        $user->status = 0;
        $user->save();

        if ($user) {
            return response()->json(['is_success' => true, 'message' => 'document verification uploaded sucessfully', 'data' => $user], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('user not Found')], 200);
        }
    }

    public function changePlan(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $validator = \Validator::make($request->all(), ['plan_id' => 'required']);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }
            $plans = Plan::find($request->plan_id);
            if ($plans) {
                $user =  User::find($user->id);
                $user->assignPlan($plans->id);
                $data = [
                    'user_details' => $user->apiFormat(),
                    'plan_details' => $plans
                ];
                return response()->json(['is_success' => true, 'message' => 'Plan change sucessfully', 'data' => $data], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('Plan Not found')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function planList()
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $plans = Plan::with('Features')->select('id', 'name')->get();

            if ($plans) {
                $data = [];

                foreach ($plans as $key => $value) {
                    $data[$key] = $value;
                    foreach ($value->Features as $k => $v) {

                        // dd($data[$key]['features'][$k]['created_at']);
                        $data[$key]['features'][$k]['title'] = $v->feature;
                        unset($data[$key]['features'][$k]['feature']);
                        unset($data[$key]['features'][$k]['id']);
                        unset($data[$key]['features'][$k]['plan_id']);
                        unset($data[$key]['features'][$k]['created_at']);
                        unset($data[$key]['features'][$k]['updated_at']);
                    }
                }


                return response()->json(['is_success' => true, 'message' => 'Plans List sucessfully', 'data' => $data], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('Plan not Found')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function cities()
    {
        $cities = Cities::select('id', 'name')->get();

        if ($cities) {
            return response()->json(['is_success' => true, 'message' => 'Cities get sucessfully', 'data' => $cities], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('City not Found')], 200);
        }
    }



    public function changePassword(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'current_password' => 'required',
            'new_password' => 'required|min:6',
            'confirm_password' => 'required|same:new_password',
        ]);

        $objUser          = Auth::user();
        $request_data     = $request->All();
        $current_password = $objUser->password;
        if (Hash::check($request_data['current_password'], $current_password)) {
            $user_id            = Auth::User()->id;
            $obj_user           = User::find($user_id);
            $obj_user->password = Hash::make($request_data['new_password']);;
            $obj_user->save();

            return redirect()->route('profile', $objUser->id)->with('success', __('Password successfully updated.'));
        } else {
            return redirect()->route('profile', $objUser->id)->with('error', __('old Password does not match.'));
        }
    }


    public function languageList()
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $lang = array(
                array(
                    'name' => 'English',
                    'code' => 'en',
                    'flag' => Storage::url('flag/en.png'),
                ),
                array(
                    'name' => 'French',
                    'code' => 'fr',
                    'flag' => Storage::url('flag/fr.png'),
                ),

            );
            if ($lang) {
                return response()->json([
                    'is_success' => true,
                    'message' => 'language list',
                    'data' => $lang
                ], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }


    public function selectLanguage(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $validation = [];
            $validation['lang_code'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }
            $lang = $request->lang_code;
            $user->lang = $request->lang_code;
            $user->save();
            App::setLocale($lang);
            session()->put('locale', $lang);  
            

            return response()->json([
                'is_success' => true,
                'message' =>  __('Language Changed'),
                'data' => $user->apiFormat()
            ], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => trans('This User do not match our records.')], 200);
        }
    }


    public function transactionList(Request $request)
    {
        $get_transaction_list = Transaction::get(['type', 'amount', 'date']);
        if ($get_transaction_list) {
            return response()->json([
                'is_success' => true,
                'message' => 'Transaction list',
                'data' => $get_transaction_list
            ], 200);
        } else {
            return response()->json([
                "success" => false,
                "message" => "Transaction not found",
            ], 200);
        }
    }


    public function TncList(Request $request)
    {
        $data = [
            'terms_and_conditions' => "<div><h2>Terms and Conditions</h2><p>Welcome to our website! Please read these terms and conditions carefully before using our services.</p><ul><li><strong>Usage:</strong> Use of our services constitutes acceptance of these terms.</li><li><strong>Privacy:</strong> Your privacy is important to us. Read our <a href='/privacy-policy'>Privacy Policy</a>.</li><li><strong>Prohibited Activities:</strong> Do not engage in prohibited activities as outlined in these terms.</li></ul><p>By using our services, you agree to comply with these terms and conditions. If you do not agree, please do not use our services.</p></div>"
        ];
            return response()->json([
                'is_success' => true,
                'message' => 'Terms and Conditions',
                 "data"=> $data
            ], 200);
       
    }
}
