<?php

namespace App\Http\Controllers\API;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\WelcomeMail;
use App\Models\CardDetails;
use App\Models\Mainservice;
use App\Models\User;
use App\Models\UserDocuments;
use App\Models\WithdrawRequests;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Storage;
use HTTP_Request2;
use HTTP_Request2_Exception;

class StripeController extends Controller
{
    public $android_app_version = 1;
    public $ios_app_version = 1;
    public $is_live = false;


    public function callPostApi($url, $data = array())
    {

        $token =  env('BRIDGECARD_TOKEN');

        $headers = [
            'token' => 'Bearer ' . $token,
            'Content-Type' => 'application/json'
        ];
        // dd($token);

        $client = new Client();




        try {
            $response = $client->post($url, [
                'body' => json_encode($data),
                'headers' => $headers
            ]);

            // dd($response);
            $responseData = json_decode($response->getBody(), true);
            return $responseData;
        } catch (\Exception $e) {

            // dd('Error: ' . $e->getMessage());
            return ['status' => false, 'message' => __($e->getMessage())];
            // die;
        }
    }

    public function callGetApi($url, $method = 'get', $data = array())
    {

        $token =  env('BRIDGECARD_TOKEN');

        $headers = [
            'token' => 'Bearer ' . $token,
        ];
        // dd($token);

        $client = new Client();

        try {
            if (!empty($data)) {
                $response = $client->$method($url, [
                    'body' => json_encode($data),
                    'headers' => $headers
                ]);
            } else {
                $response = $client->$method($url, [
                    'headers' => $headers
                ]);
            }

            // dd($response);
            $responseData = json_decode($response->getBody(), true);
            return $responseData;
        } catch (\Exception $e) {

            // dd('Error: ' . $e->getMessage());
            return ['status' => false, 'message' => __($e->getMessage())];
            // die;
        }
    }

    public function cardIssuing(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            // dd($request->all());



            $card_exist = CardDetails::where('user_id', $user->id)->first();

            if (!$card_exist) {

                $validation = [];
                $validation['address'] = 'required';
                $validation['postal_code'] = 'required';
                $validation['house_no'] = 'required';
                $validation['id_type'] = 'required';
                $validation['dob'] = 'required';
                $validation['id_no'] = 'required';
                $validation['id_image'] = 'required|mimes:jpeg,jpg,png';
                $validation['selfie_image'] = 'required|mimes:jpeg,jpg,png';
                $validation['back_id_image'] = 'required|mimes:jpeg,jpg,png';
                $validator = \Validator::make($request->all(), $validation);
                if ($validator->fails()) {
                    $messages = $validator->getMessageBag();
                    return response()->json([
                        'is_success' => false,
                        'message' => $messages->first(),
                    ], 200);
                }

                $user->address = $request->address;
                $user->postal_code = $request->postal_code;
                $user->house_no = $request->house_no;
                $user->dob = $request->dob;
                $user->country = "Senegal";
                $user->save();

                $userDocument = new UserDocuments();
                $userDocument->user_id = $user->id;
                $userDocument->id_no = $request->id_no;
                $userDocument->id_type = $request->id_type;

                if ($request->id_image) {
                    $id_image = 'front_id_' . $user->id . '_image' . time() . '.' . $request->id_image->getClientOriginalExtension();
                    $request->id_image->storeAs($user->id . '/documents/id/front', $id_image);
                    $userDocument->id_image = '/documents/id/front/' . $id_image;
                }

                if ($request->back_id_image) {
                    $back_id_image = 'back_id_' . $user->id . '_image' . time() . '.' . $request->back_id_image->getClientOriginalExtension();
                    $request->back_id_image->storeAs($user->id . '/documents/id/back', $back_id_image);
                    $userDocument->back_id_image = '/documents/id/back/' . $back_id_image;
                }

                if ($request->selfie_image) {
                    $avatarName = 'selfie' . $user->id . '_image' . time() . '.' . $request->selfie_image->getClientOriginalExtension();
                    $request->selfie_image->storeAs($user->id . '/selfie', $avatarName);
                    $user->avatar = '/selfie/' . $avatarName;
                    $user->save();
                }




                $url = env('BASE_API_URL') . 'cardholder/register_cardholder_synchronously';
                $data = [
                    'first_name' => $user->first_name,
                    'last_name' => $user->last_name,
                    'address' => [
                        'address' => $user->address,
                        'city' => $user->Citydetails->name,
                        'state' => $user->Citydetails->name,
                        'country' => "Senegal",
                        'postal_code' => $user->postal_code,
                        'house_no' => $user->house_no,
                    ],
                    'phone' => $user->country_code . $user->phone,
                    'email_address' => $user->email,
                    "identity" => [
                        "id_type" => $request->id_type,
                        "id_no" => $request->id_no,
                        "id_image" => Storage::url('/documents/id/front/' . $id_image),
                        "selfie_image" => Storage::url($user->avatar),
                        "back_id_image" => Storage::url('/documents/id/back/' . $back_id_image)
                    ],


                    // Add other key-value pairs as needed
                ];



                try {
                    $response = $this->callPostApi($url, $data);
                    // dd($response['status']);
                    if (isset($response['status']) && $response['status'] == 'success') {
                        $cardholder_id = $response['data']['cardholder_id'];


                        $userDocument->save();

                        $api = env('BASE_API_URL') . 'cards/create_card';
                        // dd($api);
                        $cdata = [
                            'cardholder_id' => $cardholder_id,
                            'card_type' => 'virtual',
                            'card_brand' => 'Visa',
                            'card_currency' => 'USD',
                        ];

                        try {
                            $response1 = $this->callPostApi($api, $cdata);
                            if (isset($response1['status']) && $response1['status'] == 'success') {
                                $card_id = $response1['data']['card_id'];
                                $currency = $response1['data']['currency'];

                                if ($card_id) {

                                    $inactive_card = env('BASE_API_URL').'cards/freeze_card?card_id=' . $card_id;

                                    $card_inactivate = $this->callGetApi($inactive_card, 'patch');
                                    //dd($card_inactivate);



                                    $card_api = 'https://issuecards-api-bridgecard-co.relay.evervault.com/v1/issuing/sandbox/cards/get_card_details?card_id=' . $card_id;

                                    $card_details = $this->callGetApi($card_api);

                                    if (isset($card_details['status']) && $card_details['status'] == 'success') {
                                        $details = $card_details['data'];
                                        $card = new CardDetails();
                                        $card->user_id = $user->id;
                                        $card->card_holder_id = $cardholder_id;
                                        $card->card_id = $card_id;
                                        $card->exp_month = $details['expiry_month'];
                                        $card->card_number = $details['card_number'];
                                        $card->last4 = $details['last_4'];
                                        $card->cvc = $details['cvv'];
                                        $card->exp_year = $details['expiry_year'];
                                        $card->currency = $currency;
                                        $card->brand = $details['brand'];
                                        $card->balance = $details['balance'];
                                        $card->type = $details['card_type'];
                                        $card->save();

                                        $data =
                                            [
                                                'user_details' => $user->apiFormat(),
                                                'card_details' => $card_details['data'],
                                            ];

                                        return response()->json([
                                            'is_success' => true,
                                            'message' => __('Card Created Successfully'),
                                            'data' => $data
                                        ], 200);
                                    } else {
                                        return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
                                    }
                                }
                            } else {
                                return response()->json(['is_success' => false, 'message' => $response1['message']], 200);
                            }
                        } catch (\Exception $e) {
                            return response()->json(['error' => $e->getMessage()], 500);
                        }
                    } else {
                        return response()->json(['is_success' => false, 'message' => $response['message']], 200);
                    }
                } catch (\Exception $e) {
                    return response()->json(['is_success' => false, 'error' => $e->getMessage()], 500);
                }
            } else {



                $data =
                    [
                        'user_details' => $user->apiFormat(),

                    ];
                return response()->json([
                    'is_success' => false,
                    'message' => __('Card Already Exist'),
                    'data' => $data
                ], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function updateStatus(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validation = [];
            $validation['status'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }

            $stripe = new \Stripe\StripeClient(env('STRIPE_KEY'));

            $card_exist = CardDetails::where('user_id', $user->id)->first();
            if ($card_exist) {

                try {

                    $card = $stripe->issuing->cards->update(
                        $card_exist->card_id,
                        ['status' => $request->status]
                    );

                    if ($card) {
                        $card_exist->status = ($request->status == 'active') ? 1 : 0;
                        $card_exist->save();

                        $data =
                            [
                                'card_details' => $card_exist,
                            ];
                        return response()->json([
                            'is_success' => true,
                            'message' => __('Card ' . $request->status . ' Successfully'),
                            'view_card_url' => route('view.card', Crypt::encrypt($card->id)),
                            'data' => $data
                        ], 200);
                    }
                } catch (\UnexpectedValueException  $e) {
                    return response()->json([
                        'is_success' => false,
                        'message' => $e->getMessage(),
                    ], 200);
                } catch (\Stripe\Exception\SignatureVerificationException $e) {

                    return response()->json([
                        'is_success' => false,
                        'message' => $e->getMessage(),
                    ], 200);
                }
            } else {
                return response()->json([
                    'is_success' => false,
                    'message' => __('Card not Exist'),
                ], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function updateLimit(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validation = [];
            $validation['limit'] = 'required';
            $validation['type'] = 'required';
            $validation['interval'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }

            $stripe = new \Stripe\StripeClient(env('STRIPE_KEY'));

            $card_exist = CardDetails::where('user_id', $user->id)->first();
            if ($card_exist) {

                try {
                    if ($request->type == 'credit') {
                        $limit = $card_exist->spending_limit_amount + $request->limit;
                    } else {
                        $limit = $card_exist->spending_limit_amount - $request->limit;
                    }

                    $card = $stripe->issuing->cards->update(
                        $card_exist->card_id,
                        ['spending_controls' => ['spending_limits' => ['amount' => $limit, 'interval' => $request->interval]]]
                    );

                    if ($card) {
                        $card_exist->spending_limit_amount = $limit;
                        $card_exist->save();

                        $data =
                            [
                                'card_details' => $card_exist,
                            ];
                        return response()->json([
                            'is_success' => true,
                            'message' => __('Card Limit update Successfully'),
                            'view_card_url' => route('view.card', Crypt::encrypt($card->id)),
                            'data' => $data
                        ], 200);
                    }
                } catch (\Stripe\Exception\CardException $e) {


                    return response()->json([
                        'is_success' => false,
                        'message' => $e->getMessage(),
                    ], 200);
                }
            } else {
                return response()->json([
                    'is_success' => false,
                    'message' => __('Card not Exist'),
                ], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    function stripeCredentials()
    {
        $data['STRIPE_KEY'] = env('STRIPE_SECRET_KEY');
        $data['STRIPE_PUBLISHABLE_KEY'] = env('STRIPE_PUBLISHABLE_KEY');
        return response()->json([
            'is_success' => true,
            'message' => __('Stripe credentials is here'),
            'data' => $data
        ], 200);
    }

    function fundCard(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validation = [];
            $validation['amount'] = 'required|numeric';
            $validation['transaction_id'] = 'required';
            $validation['currency'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }

            $card_exist = CardDetails::where('user_id', $user->id)->first();

            if ($card_exist) {
                try {
                    $wallet_data = [
                        'amount' => $request->amount,
                    ];

                    $data = [
                        'card_id' => $card_exist->card_id,
                        'amount' => $request->amount,
                        'transaction_reference' => $request->transaction_id,
                        'currency' => $request->currency,
                    ];

                    $get_wallet_fund = env('BASE_API_URL').'cards/get_issuing_wallet_balance';
                    $wallet_balance = $this->callGetApi($get_wallet_fund, 'get');

                    $add_wallet_fund = env('BASE_API_URL').'cards/fund_issuing_wallet';
                    $fund_wallet = $this->callGetApi($add_wallet_fund, 'patch', $wallet_data);
                    // dd($wallet_balance);


                    $fun_card_api = env('BASE_API_URL').'cards/fund_card_asynchronously';

                    $fund_card = $this->callGetApi($fun_card_api, 'patch', $data);
                    // dd($fund_card);


                    if (isset($fund_card['status']) && $fund_card['status'] == 'success') {




                        $data =
                            [
                                'user_details' => $user->apiFormat(),
                            ];

                        return response()->json([
                            'is_success' => true,
                            'message' => __('Card Fund Successfully'),
                            'data' => $data
                        ], 200);
                    } else {
                        return response()->json(['is_success' => false, 'message' => $fund_card['message']], 200);
                    }
                } catch (\Exception $e) {
                    return response()->json(['is_success' => false, 'error' => $e->getMessage()], 500);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    function cardBalance()
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {


            $card_exist = CardDetails::where('user_id', $user->id)->first();

            if ($card_exist) {
                try {

                    $card_balance_api = env('BASE_API_URL').'cards/get_card_balance?card_id=' . $card_exist->card_id;
                    $card_balance = $this->callGetApi($card_balance_api, 'get');
                    // dd($card_balance);
                    if (isset($card_balance['status']) && $card_balance['status'] == 'success') {

                        $data =
                            [
                                'balance' => $card_balance['data']['balance'],
                                'user_details' => $user->apiFormat(),
                            ];

                        return response()->json([
                            'is_success' => true,
                            'message' => __('Card Balance Successfully'),
                            'data' => $data
                        ], 200);
                    } else {
                        return response()->json(['is_success' => false, 'message' => $card_balance['message']], 200);
                    }
                } catch (\Exception $e) {
                    return response()->json(['is_success' => false, 'error' => $e->getMessage()], 500);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }
    function cardTransactions(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validation = [];
            $validation['filter_type'] = 'required';
            $validation['page'] = 'required|numeric';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }

            if ($request->filter_type == 'custom') {
                $validation = [];
                $validation['start_date'] = 'required';
                $validation['end_date'] = 'required';
                $validator = \Validator::make($request->all(), $validation);
                if ($validator->fails()) {
                    $messages = $validator->getMessageBag();
                    return response()->json([
                        'is_success' => false,
                        'message' => $messages->first(),
                    ], 200);
                }
            }

            $card_exist = CardDetails::where('user_id', $user->id)->first();

            if ($card_exist) {
                try {
                    $timeZone = 'Africa/Dakar';
                    if ($request->filter_type == 'today') {

                        $start_date = Carbon::now($timeZone)->format('Y-m-d 01:00:00');
                        $end_date = Carbon::now($timeZone)->format('Y-m-d 23:59:00');
                    }
                    if ($request->filter_type == 'yesterday') {
                        $start_date = Carbon::now($timeZone)->subDay()->format('Y-m-d 01:00:00');
                        $end_date = Carbon::now($timeZone)->subDay()->format('Y-m-d 23:59:00');
                    }
                    if ($request->filter_type == 'this_month') {
                        $timeZone = 'Africa/Dakar';
                        $now = Carbon::now($timeZone);


                        $start_date = $now->startOfMonth()->format('Y-m-d 01:00:00');
                        $end_date = $now->endOfMonth()->format('Y-m-d 01:00:00');
                    }
                    if ($request->filter_type == 'custom') {
                        $start_date = $request->start_date;
                        $end_date = $request->end_date;
                    }
                    // dd($start_date);
                    if ($request->filter_type == 'all') {
                        $card_trx_api = env('BASE_API_URL').'cards/get_card_transactions?card_id=' . $card_exist->card_id . '&page=' . $request->page;
                    } else {
                        $card_trx_api = env('BASE_API_URL').'cards/get_card_transactions?card_id=' . $card_exist->card_id . '&page=' . $request->page . '&start_date=' . $start_date . '&end_date=' . $end_date;
                    }
                    $card_transactions = $this->callGetApi($card_trx_api, 'get');
                    // dd($card_balance);
                    if (isset($card_transactions['status']) && $card_transactions['status'] == 'success') {

                        $data  = $card_transactions['data'];

                        return response()->json([
                            'is_success' => true,
                            'message' => __('Card Transaction Successfully'),
                            'data' => $data
                        ], 200);
                    } else {
                        return response()->json(['is_success' => false, 'message' => $card_transactions['message']], 200);
                    }
                } catch (\Exception $e) {
                    return response()->json(['is_success' => false, 'error' => $e->getMessage()], 500);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    function transactionDetails(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validation = [];
            $validation['client_transaction_reference'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }


            $card_exist = CardDetails::where('user_id', $user->id)->first();

            if ($card_exist) {
                try {

                    $card_trx_api = env('BASE_API_URL').'cards/get_card_transaction_by_id?card_id=' . $card_exist->card_id . '&client_transaction_reference=' . $request->client_transaction_reference;

                    $card_transactions = $this->callGetApi($card_trx_api, 'get');
                    // dd($card_balance);
                    if (isset($card_transactions['status']) && $card_transactions['status'] == 'success') {

                        $data  = $card_transactions['data'];

                        return response()->json([
                            'is_success' => true,
                            'message' => __('Card Transaction Details Successfully'),
                            'data' => $data
                        ], 200);
                    } else {
                        return response()->json(['is_success' => false, 'message' => $card_transactions['message']], 200);
                    }
                } catch (\Exception $e) {
                    return response()->json(['is_success' => false, 'error' => $e->getMessage()], 500);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    function withdrawRequest(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validation = [];
            $validation['amount'] = 'required|numeric';
            $validation['payment_type'] = 'required';
            $validation['currency'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }


            $card_exist = CardDetails::where('user_id', $user->id)->first();

            if ($card_exist) {
                try {

                    $card_balance_api = env('BASE_API_URL').'cards/get_card_balance?card_id=' . $card_exist->card_id;
                    $card_balance = $this->callGetApi($card_balance_api, 'get');
                    // dd($card_balance);
                    if (isset($card_balance['status']) && $card_balance['status'] == 'success') {
                        $balance = $card_balance['data']['balance'];
                        if ($request->amount <= $balance) {

                            $withdraw_request = new WithdrawRequests();
                            $withdraw_request->user_id = $user->id;
                            $withdraw_request->payment_type = $request->payment_type;
                            $withdraw_request->amount = $request->amount;
                            $withdraw_request->currency = $request->currency;
                            $withdraw_request->status = 0;
                            $withdraw_request->save();
                            $data =
                                [
                                    'balance' => $card_balance['data']['balance'],
                                    'withdraw_request' => $withdraw_request,
                                ];

                            return response()->json([
                                'is_success' => true,
                                'message' => __('Send Withdraw Request Successfully'),
                                'data' => $data
                            ], 200);
                        } else {
                            return response()->json(['is_success' => false, 'message' => "Your card doesn\'t have enough funds to sufficient balance to withdraw"], 200);
                        }
                    } else {
                        return response()->json(['is_success' => false, 'message' => $card_transactions['message']], 200);
                    }
                } catch (\Exception $e) {
                    return response()->json(['is_success' => false, 'error' => $e->getMessage()], 500);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function deleteUser(Request $request)
    {
        // dd('here');
        // $this->validateToken();
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {


            $card_detials = CardDetails::where('user_id', $user->id)->first();
            // dd($card_detials);

            $delete_card_holder = env('BASE_API_URL').'cardholder/delete_cardholder/' . $card_detials->card_holder_id;
            $delete_cardholder_response = $this->callGetApi($delete_card_holder, 'delete');
            // dd($delete_cardholder_response);
            if (isset($delete_cardholder_response['status']) && $delete_cardholder_response['status'] == 'success') {
                $card_detials->delete();
                // $user->delete();
                return response()->json(['is_success' => true, 'message' => 'Account Deleted'], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => $delete_cardholder_response['message']], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }
}
