<?php

namespace App\Http\Controllers\API;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\WelcomeMail;
use App\Models\CardDetails;
use App\Models\Mainservice;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Storage;

class UserController extends Controller
{
    public $android_app_version = 1;
    public $ios_app_version = 1;
    public $is_live = false;




    public function login(Request $request)
    {
        $rules = [
            'phone' => 'required|numeric',
        ];
        $validator = \Validator::make($request->all(),  $rules);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json(
                [
                    'is_success' => false,
                    'message' => $messages->first(),
                ],
                200
            );
        }


        $user = User::where('phone', '=', $request->phone)->first();

        if ($user) {
            if ($request->otp == $user->otp) {
                if ($user->type == 'User') {
                    if ($user->phone_verify == 1) {
                        if ($user->is_active == 1) {

                            $user->generateToken();
                            // $user->city_details = $user->Citydetails;
                            return response()->json(['is_success' => true, 'user_type' => 'old',  'message' => __('Otp Verify succefully.'), 'data' => $user->apiFormat()], 200);
                        } else {
                            return response()->json(['is_success' => true, 'user_type' => 'old',  'message' => __('Your account Is inactive by admin'), 'data' => $user->apiFormat()], 200);
                        }
                    } else {
                        // $user->city_details = $user->Citydetails;
                        return response()->json(['is_success' => true, 'user_type' => 'new',  'message' => __('Otp Verify succefully.'), 'data' => $user->apiFormat()], 200);
                    }
                } else {
                    return response()->json(['is_success' => false, 'message' => __('These credentials do not match our records.')], 200);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('Otp is invalid.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('These credentials do not match our records.')], 200);
        }
    }

    public function mobileCheck(Request $request)
    {
        $validator = \Validator::make($request->all(), ['phone' => 'required|numeric', 'country_code' => 'required']);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'message' => $messages->first(),
            ], 200);
        }
        $user = User::where('phone', '=', $request->phone)->first();
        if ($user) {

            $otp = $this->generateNumericOTP(6);
            $msg = 'Your Paysen account OTP(One Time Password) is ' . $otp;

            $result = $this->sendSms($request->country_code, $request->phone, $msg);

            if ($result->results[0]->smscount == 1) {

                $user->otp = $otp;
                $user->save();
                // $user->city_details = $user->Citydetails;
                return response()->json(['is_success' => true, 'user_type' => ($user->phone_verify == 1) ? 'old' : 'new', 'message' => __('Otp send on your registerd mobile'), 'data' => $user->apiFormat()], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('SMS Error: ' . $result->results[0]->reason)], 200);
            }
        } else {
            $otp = $this->generateNumericOTP(6);
            $msg = 'Your Paysen account OTP(One Time Password) is ' . $otp;
            $result = $this->sendSms($request->country_code, $request->phone, $msg);

            if ($result->results[0]->smscount == 1) {

                $user = User::create([

                    'phone' => $request->phone,
                    'country_code' => $request->country_code,
                    'otp' => $otp,
                    'type' => 'User',
                    'lang' => 'en',

                ]);
                $user = User::find($user->id);
                // $user->city_details = $user->city;

                return response()->json(['is_success' => true, 'user_type' => 'new',  'message' => __('Otp send on your mobile'), 'data' => $user->apiFormat()], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('SMS Error: ' . $result->results[0]->reason)], 200);
            }
        }
    }

    function generateNumericOTP($n)
    {


        $generator = "1357902468";


        $result = "";

        for ($i = 1; $i <= $n; $i++) {
            $result .= substr($generator, (rand() % (strlen($generator))), 1);
        }

        // Return result
        return $result;
    }

    public function sendSms($country_code, $mobile, $msg)
    {


        $url = 'https://api-public-2.mtarget.fr/messages';


        // dd($data);
        $data = array(
            'username' => 'paysen',
            'password' => '6NBb02rj5Oym',
            'msisdn' => '+221781949324',
            'msg' => 'Hello, Samba this is Dhimmar. If you received this SMS then send reply on whatsapp.'
        );
        // $msg = 'Your Paysen account OTP(One Time Password) is 123456.';

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api-public-2.mtarget.fr/messages',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'username=paysen&password=6NBb02rj5Oym&msisdn=%2B' . $country_code . $mobile . '&msg=' . $msg,
            CURLOPT_HTTPHEADER => array(
                'content-type: application/x-www-form-urlencoded',
                'Cookie: SERVERID=B'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $result  = json_decode($response);
        // dd($result);

        return $result;
    }

    public function register(Request $request)
    {

        $rules = [
            'phone' => 'required|numeric',
        ];
        $validator = \Validator::make($request->all(),  $rules);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json(
                [
                    'is_success' => false,
                    'message' => $messages->first(),
                ],
                200
            );
        }

        $user = User::where('phone', '=', $request->phone)->first();
        if ($user) {
            if ($user->phone_verify == 0) {

                $rules = [
                    'first_name' => 'required|max:255',
                    'last_name' => 'required|max:255',
                    'email' => 'required|string|email|max:255|unique:users',
                    'country_code' => 'required|numeric',
                    'phone' => 'required|numeric',
                    'city' => 'required',
                    'activity' => 'required',
                    'gender' => 'required',



                ];
                if ($request->avatar) {
                    $rules['avatar'] = 'required|mimes:jpeg,jpg,png';
                }
                $validator = \Validator::make($request->all(),  $rules);
                if ($validator->fails()) {
                    $messages = $validator->getMessageBag();
                    return response()->json(
                        [
                            'is_success' => false,
                            'message' => $messages->first(),
                        ],
                        200
                    );
                }
                $user->first_name = $request->first_name;
                $user->last_name = $request->last_name;
                $user->email = $request->email;
                $user->country_code = $request->country_code;
                $user->city = $request->city;
                $user->activity = $request->activity;
                $user->gender = $request->gender;
                $user->phone_verify = 1;
                $user->save();
                if ($request->avatar) {
                    $avatarName = $user->id . '_avatar' . time() . '.' . $request->avatar->getClientOriginalExtension();
                    $request->avatar->storeAs('avatar', $avatarName);
                    $user->avatar = '/avatar/' . $avatarName;
                    $user->save();
                }
                $user->assignRole('User');
                $user->generateToken();
                $user = User::find($user->id);

                try {
                    Mail::to($user->email)->send(new WelcomeMail($user));
                    return response()->json(['is_success' => true, 'message' => __('Registered Successfully.'), 'data' => $user->apiFormat()], 200);
                } catch (\Exception $e) {
                    // dd($e->getMessage());
                    $smtp_error = __($e->getMessage());
                    // return redirect()->back()->with('error', $smtp_error);
                    return response()->json(['is_success' => false, 'message' => $smtp_error, 'data' => $user->apiFormat()], 200);
                }
            } else {
                $user->generateToken();
                $user = User::find($user->id);
                return response()->json(['is_success' => false, 'message' => __('Already Registered'), 'data' => $user->apiFormat()], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('Phone Not found')], 200);
        }
    }

    public function forgot_password(Request $request)
    {

        $validator = \Validator::make($request->all(), ['email' => 'required|email']);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'message' => $messages->first(),
            ], 200);
        }
        $response = Password::broker()->sendResetLink($request->only('email'));
        if ($response == Password::RESET_LINK_SENT) {
            return response()->json(['is_success' => true, 'message' => trans($response)], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => trans($response)], 200);
        }
    }

    public function update_profile(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $validation = [
                'first_name' => 'required|max:255',
                'last_name' => 'required|max:255',
                'email' => 'required|email',
                'company_name' => 'required',


            ];
            if ($request->avatar) {
                $validation['avatar'] = 'required|mimes:jpeg,jpg,png';
            }
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }
            $post = $request->all();
            if ($request->avatar) {
                if ($user->avatar) {
                    Storage::delete($user->avatar);
                }
                $avatarName = $user->id . '_avatar' . time() . '.' . $request->avatar->getClientOriginalExtension();
                $request->avatar->storeAs('avatar', $avatarName);
                $post['avatar'] = 'avatar/' . $avatarName;
            }
            $user->update($post);
            $data = $user->apiFormat();
            return response()->json(['is_success' => true, 'message' => __('User Updated Successfully'), 'data' => $data], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    function sendVerificationCode()
    {
        // dd('here');
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $otp = $this->generateNumericOTP(6);
            // dd($otp);
            $user->otp = $otp;
            $user->save();
            // $data = $user->apiFormat();
            // dd($data);
            return response()->json(['is_success' => true, 'message' => __('Otp Send On email'), 'data' => $user], 200);

            // try {
            //    // Mail::to($user->email)->send(new WelcomeMail($user));
            // } catch (\Exception $e) {
            //     dd($e->getMessage());
            //     $smtp_error = __('E-Mail has been not sent due to SMTP configuration');
            // }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    function emailVerify(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {

            $validator = \Validator::make($request->all(), ['email_otp' => 'required|numeric']);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }
            // dd($user->email_otp);
            if ($user->email_otp == $request->email_otp) {

                $otp = $this->generateNumericOTP(6);
                $user->email_verify = 1;
                $user->save();
                $data = $user->apiFormat();
                return response()->json(['is_success' => true, 'message' => __('Email verify Successfully'), 'data' => $data], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => __('Otp Is invalid..')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function changePasscode(Request $request)
    {
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $validation = [];
            $validation['current_passcode'] = 'required';
            $validation['new_passcode'] = 'required';
            $validator = \Validator::make($request->all(), $validation);
            if ($validator->fails()) {
                $messages = $validator->getMessageBag();
                return response()->json([
                    'is_success' => false,
                    'message' => $messages->first(),
                ], 200);
            }
            $current_password = $user->password;
            if ($current_password) {

                if (Hash::check($request->current_passcode, $current_password)) {
                    $user->password = Hash::make($request->new_passcode);
                    $user->save();
                    return response()->json(['is_success' => true, 'message' => __('Passcode Updated Successfully')], 200);
                } else {
                    return response()->json(['is_success' => false, 'message' => __('Please Enter Correct Current Passcode!')], 200);
                }
            } else {
                $user->password = Hash::make($request->new_passcode);
                $user->save();
                return response()->json(['is_success' => true, 'message' => __('Passcode Updated Successfully')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function getProfile(Request $request)
    {
        // dd('here');
        // $this->validateToken();
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            $data = [
                'user_details' => $user->apiFormat(),
            ];
            return response()->json(['is_success' => true, 'message' => '', 'data' => $data], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }



    public function refreshToken(Request $request)
    {
        $validator = \Validator::make($request->all(), ['email' => 'required|email']);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'message' => $messages->first(),
            ], 200);
        }
        $user = User::where('email', '=', $request->email)->first();
        if ($user) {

            // Assuming you have a User model with a `createToken` method
            $token = $user->generateToken();
            $data = [
                'user_details' => $user->apiFormat(),
            ];
            return response()->json(['is_success' => true, 'message' => 'Access Token refreshed', 'data' => $data], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }

    public function home(Request $request)
    {
        // dd('here');
        // $this->validateToken();
        $user = auth('api')->user();
        if ($user && $user->type == 'User') {
            if ($request->fcm_token) {
                $user->fcm_token = $request->fcm_token;
                $user->platform = $request->platform;
                if ($request->device) {
                    $user->device = $request->device;
                }
                $user->save();
            }
            // $mainservice = Mainservice::where('status', 1)->get();
            $card_exist = CardDetails::where('user_id', $user->id)->first();
            $data = [
                'user_details' => $user->apiFormat(),
                'card_details' => $card_exist,
            ];
            return response()->json(['is_success' => true, 'message' => '', 'data' => $data], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => __('This User do not match our records.')], 200);
        }
    }
}
