<?php

namespace App\Http\Controllers;

use App\Facades\UtilityFacades;
use App\Models\CardDetails;
use App\Models\Faq;
use App\Models\Faq_categories;
use App\Models\Fund_request;
use App\Models\Plan;
use App\Models\Tournament;
use App\Models\Tournament_participants;
use App\Models\User;
use App\Models\Withdraw_request;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use PaytmWallet;

class FrontController extends Controller
{
    public function viewCard($code)
    {
        $card_id               = Crypt::decrypt($code);
        $card                  = CardDetails::find($card_id);
        $user = User::find($card->user_id);

        return view('front.view_card',compact('card', 'user'));
    }

    function createNonce(Request $request){

        $stripe = new \Stripe\StripeClient(env('STRIPE_KEY'));
        // dd($stripe);

        try {
            $ephemeralKey = $stripe->ephemeralKeys->create([
                'nonce' => $request['nonce'],
                'issuing_card' => $request['card_id'],
            ], [
                'stripe_version' => '2022-08-01'
            ]);
        } catch (\UnexpectedValueException $e) {
            dd($e->getMessage());
            http_response_code(400);
            exit();
        } catch (\Stripe\Exception\SignatureVerificationException $e) {
            // Invalid signature
            http_response_code(400);
            exit();
        }

        http_response_code(200);
        echo json_encode(['ephemeralKeySecret' => $ephemeralKey->secret]);
        die;

    }

    function home(){
        $faqs = Faq::get();
        return view('front.home',compact('faqs')); 
    }

    function virtualProduct(){
        return view('front.virtual_product'); 

    }

    function pricing(){
        $plan_country = Plan::select('plans.country')->groupBy('country')->get();
        // dd($plan_country);
        $plans = Plan::with('Features')->get();
        // dd($plans);
        return view('front.pricing',compact('plans', 'plan_country')); 
    }

    function support(){
        $faq_categories = Faq_categories::with('Faqs')->get();
        $faqs = Faq::get();

        return view('front.support',compact('faq_categories','faqs')); 
    }

    function blogs(){
        return view('front.blogs'); 
    }

    function blogDetails($id){
        return view('front.blog_details'); 
    }

    function privacyPolicy(){
        return view('front.privacy-policy'); 
    }

    public function changeLanquage($lang)
    {
        // dd($lang);
        App::setLocale($lang);
        session()->put('locale', $lang);

        return redirect()->route('front')->with('success', __('Language change successfully.'));
    }
}