<?php

namespace App\Http\Controllers;

use App\DataTables\CardDataTable;
use App\Facades\UtilityFacades;
use App\Models\ChartDetails;
use App\Models\Fund_request;
use App\Models\Offerdetails;
use App\Models\Tournament;
use App\Models\Tournament_participants;
use App\Models\User;
use App\Models\Withdraw_request;
use Illuminate\Http\Request;
use PaytmWallet;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $usercount = User::where('type', 'User')->count();
        $admincount = User::where('type', 'Admin')->count();
        return view('dashboard.home', compact('usercount', 'admincount'));
    }

    function basicDetails($id = '')
    {

        if ($id != '') {
            $user = User::find($id);
            return view('users.basic_details', compact('user', 'id'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.basic_details', compact('users', 'id'));
        }
    }

    function offerDetails($id = '')
    {

        if ($id != '') {
            
            //user with offer details
            $user = User::find($id);
            $offerDetails = offerDetails::where('user_id', $id)->first();
            return view('users.offer_details', compact('user', 'id', 'offerDetails'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.offer_details', compact('users', 'id'));
        }
    }

    function socialLinks($id = '')
    {

        if ($id != '') {

            //user with offer details
            $user = User::find($id);
            $offerDetails = offerDetails::where('user_id', $id)->first();
            return view('users.social_links', compact('user', 'id', 'offerDetails'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.social_links', compact('users', 'id'));
        }
    }

    function workScopes($id = '')
    {

        if ($id != '') {

            //user with offer details
            $user = User::find($id);
            $offerDetails = offerDetails::where('user_id', $id)->first();
            return view('users.work_scopes', compact('user', 'id', 'offerDetails'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.work_scopes', compact('users', 'id'));
        }
    }

    function executionPlans($id = '')
    {

        if ($id != '') {

            //user with offer details
            $user = User::find($id);
            $offerDetails = offerDetails::where('user_id', $id)->first();
            return view('users.execution_plans', compact('user', 'id', 'offerDetails'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.execution_plans', compact('users', 'id'));
        }
    }

    function chartDetails($id = '')
    {

        if ($id != '') {

            //user with offer details
            $user = User::find($id);
            $chartDetails = ChartDetails::where('user_id', $id)->get();
            // dd($chartDetails);
            $chartData = ChartDetails::select('year', 'net_return')->where('user_id', $id)->orderBy('year')->get();
            return view('users.chart_details', compact('user', 'id', 'chartDetails', 'chartData'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.chart_details', compact('users', 'id'));
        }
    }


    function regenerateChart($id = '')
    {

        if ($id != '') {

            //user with offer details
            $user = User::find($id);
            $chartDetails = ChartDetails::where('user_id', $id)->get();
            // dd($chartDetails);
            $chartData = ChartDetails::select('year', 'net_return')->where('user_id', $id)->orderBy('year')->get();
            return view('users.regenerate_chart_details', compact('user', 'id', 'chartDetails', 'chartData'));
        } else {
            $users = User::where('type', 'User')->pluck('name', 'id');
            return view('users.regenerate_chart_details', compact('users', 'id'));
        }
    }

    function productList($id = '')
    {

        if ($id != '') {

            $user = User::find($id);
            $offerDetails = offerDetails::where('user_id', $id)->first();
            return view('products.index', compact('user', 'id', 'offerDetails'));
        } else {
            $users = User::where('type','User')->pluck('name', 'id');
            return view('products.index', compact('users', 'id'));
        }
    }



    public function updateofferDetails(Request $request, $id)
    {
        // dd($request->all());
        // Step 3: Validate the form data
        if (\Auth::user()->can('edit-user')) {
            $validatedData = $request->validate([
                'kw' => 'required|string',
                'per_kw' => 'required|numeric|min:0',
                'dc_capacity' => 'required|numeric|min:0',
                'ac_capacity' => 'required|numeric|min:0',
                'roof_type' => 'required|string',
                'note' => 'required|string',
                'evacuation' => 'required|string',
                'geda_charge' => 'required|numeric|min:0',
                'meter_charge' => 'required|numeric|min:0',
                'structure_charge' => 'required|numeric|min:0',
                'safety_charge' => 'required|numeric|min:0',
                'manual_cleaning_charge' => 'required|numeric|min:0',
                'gst' => 'required|numeric|min:0',
                'total_amount' => 'required|numeric|min:0',
                'gross_total' => 'required|numeric|min:0',
                'grand_total' => 'required|numeric|min:0',
                'included_charges' => 'nullable|array',
                
                
                'percentage.*' => 'required',
                'clause.*' => 'required|string',

               
                
            ]);

            // dd($request->percentage);
            $payment_terms = [];
            foreach ($request->percentage as $key => $value) {
                $payment_terms[] = [
                    'percentage' => $value,
                    'clause' => $request->clause[$key],
                ];
                
            }

            //for social links
           

            // Step 4: Save the data to the offer_details table
            $offerDetails = Offerdetails::where('user_id', $id)->first();
            $offerDetails->per_kw = $validatedData['per_kw'];
            $offerDetails->gross_total = $validatedData['gross_total'];
            $offerDetails->dc_capacity = $validatedData['dc_capacity'];
            $offerDetails->ac_capacity = $validatedData['ac_capacity'];
            $offerDetails->roof_type = $validatedData['roof_type'];
            $offerDetails->evacuation = $validatedData['evacuation'];
            $offerDetails->geda_charge = $validatedData['geda_charge'];
            $offerDetails->meter_charge = $validatedData['meter_charge'];
            $offerDetails->structure_charge = $validatedData['structure_charge'];
            $offerDetails->safety_charge = $validatedData['safety_charge'];
            $offerDetails->manual_cleaning_charge = $validatedData['manual_cleaning_charge'];
            $offerDetails->gst = $validatedData['gst'];
            $offerDetails->grand_total = $validatedData['grand_total'];
            $offerDetails->total_amount = $validatedData['total_amount'];
            $offerDetails->included_charges = json_encode($validatedData['included_charges'] ?? []);
            $offerDetails->note = $validatedData['note'];            
            $offerDetails->payment_terms = json_encode($payment_terms);
            // dd($offerDetails);
            $offerDetails->save();

            return redirect()->back()->with('success', 'Offer details saved successfully.');
        }
    }


    public function updatechartDetails(Request $request, $id)
    {
        // dd($request->all());
        // Step 3: Validate the form data
        if (\Auth::user()->can('edit-user')) {
            $validatedData = $request->validate([
                'kw' => 'required|string',
                'yearly_kw' => 'required|numeric|min:0',
                'percentage' => 'required|numeric|min:0',
                'unit' => 'required|numeric|min:0',
                'net_unit' => 'required|numeric|min:0',
                'unit_cost' => 'required|numeric|min:0',
                'gross_return' => 'required|numeric|min:0',
                'bank_ch' => 'required|numeric|min:0',
                'bank_charge' => 'required|numeric|min:0',
                'maintenance_cost' => 'required|numeric|min:0',
                'net_return' => 'required|numeric|min:0',

            ]);

            $user = User::find($id);

            $kw = $user->kw; // Initial value for kw
            $percentage = $validatedData['percentage']; // Example value, replace with actual logic to get percentage
            $cost_unit = $validatedData['unit_cost'];
            $bank_ch = $validatedData['bank_ch'];
            $maintenance_cost = $validatedData['maintenance_cost'];
            $yearly_kw = ($kw * 4) * 365;
            //delete all old data
            ChartDetails::where('user_id', $id)->delete();
            for ($year = 1; $year <= 27; $year++) {
                $unit = $yearly_kw * ($percentage / 100);
                $net_unit = $yearly_kw - $unit;
                $gross_return = $net_unit * $cost_unit;
                $bank_charge = round($net_unit * $bank_ch);
                $net_return = $gross_return - $bank_charge - $maintenance_cost;

                $chartDetails = new ChartDetails();
                $chartDetails->user_id = $id;
                $chartDetails->kw = $kw;
                $chartDetails->year = $year;
                $chartDetails->yearly_kw = $yearly_kw;
                $chartDetails->percentage = $percentage;
                $chartDetails->unit = $unit;
                $chartDetails->net_unit = $net_unit;
                $chartDetails->unit_cost = $cost_unit;
                $chartDetails->gross_return = $gross_return;
                $chartDetails->bank_ch = $bank_ch;
                $chartDetails->bank_charge = $bank_charge;
                $chartDetails->maintenance_cost = $maintenance_cost;
                $chartDetails->net_return = round($net_return);
                $chartDetails->save();

                // Update kw for the next year
                $yearly_kw = round($net_unit);
            }


         

            // Step 4: Save the data to the offer_details table
            

            return redirect()->route('chart-details', $id)->with('success', 'Chart details saved successfully.');
        }
    }

    public function updatesocialLinks(Request $request, $id)
    {
        // dd($request->all());
        // Step 3: Validate the form data
        if (\Auth::user()->can('edit-user')) {
            $validatedData = $request->validate([
                
                'name.*' => 'required',
                'kw.*' => 'required',
                'location.*' => 'required',
                'link.*' => 'required|url',

            ]);

            // dd($request->percentage);
           

            //for social links
            $social_links = [];
            foreach ($request->name as $key => $value) {
                $social_links[] = [
                    'name' => $value,
                    'kw' => $request->kw[$key],
                    'location' => $request->location[$key],
                    'link' => $request->link[$key],
                ];
            }

            // Step 4: Save the data to the offer_details table
            $offerDetails = Offerdetails::where('user_id', $id)->first();
            $offerDetails->social_links = json_encode($social_links);
            $offerDetails->save();

            return redirect()->back()->with('success', 'Social links saved successfully.');
        }
    }

    public function updateworkScopes(Request $request, $id)
    {
        // dd($request->all());
        // Step 3: Validate the form data
        if (\Auth::user()->can('edit-user')) {
            $validatedData = $request->validate([

                'work.*' => 'required',
                'fourcell.*' => 'required',
                'customer.*' => 'required',
                

            ]);

            // dd($request->percentage);


            //for social links
            $workscopes = [];
            foreach ($request->work as $key => $value) {
                $workscopes[] = [
                    'work' => $value,
                    'fourcell' => $request->fourcell[$key],
                    'customer' => $request->customer[$key],
                ];
            }

            // Step 4: Save the data to the offer_details table
            $offerDetails = Offerdetails::where('user_id', $id)->first();
            $offerDetails->work_scopes = json_encode($workscopes);
            $offerDetails->save();

            return redirect()->back()->with('success', 'Work Of Scope saved successfully.');
        }
    }

    public function updateexecutionPlans(Request $request, $id)
    {
        // dd($request->all());
        // Step 3: Validate the form data
        if (\Auth::user()->can('edit-user')) {
            $validatedData = $request->validate([

                'po_issuance' => 'required|string',
                'geda_registration' => 'required|string',
                'detailed_engineering' => 'required|string',
                'procurement' => 'required|string',
                'installation_testing' => 'required|string',
                'pre_commissioning' => 'required|string',
                'general_terms' => 'required|string',
                

            ]);

            // dd($request->percentage);


            //for social links
           

            // Step 4: Save the data to the offer_details table
            $offerDetails = Offerdetails::where('user_id', $id)->first();
            $offerDetails->po_issuance = $validatedData['po_issuance'];
            $offerDetails->geda_registration = $validatedData['geda_registration'];
            $offerDetails->detailed_engineering = $validatedData['detailed_engineering'];
            $offerDetails->procurement = $validatedData['procurement'];
            $offerDetails->installation_testing = $validatedData['installation_testing'];
            $offerDetails->pre_commissioning = $validatedData['pre_commissioning'];
            $offerDetails->general_terms = $validatedData['general_terms'];
            $offerDetails->save();

            return redirect()->back()->with('success', 'Execution Plans saved successfully.');
        }
    }

    



    public function front()
    {

        return view('front.home');
    }

    public function manageWallet()
    {

        return view('front.wallet');
    }

    function order(Request $request)
    {

        $input = $request->all();
        $user = auth()->user();

        $payment = PaytmWallet::with('receive');
        $payment->prepare([
            'order' => $input['order_id'],
            'user' => $input['CUST_ID'],
            'mobile_number' => $user->mobile,
            'email' => $user->email,
            'amount' => $input['amount'],
            'callback_url' => url('api/paytm-payment-status')
        ]);
        return $payment->receive();
    }

    public function join($id)
    {
        $tournament = Tournament::find($id);
        if ($tournament) {
            $user = auth()->user();
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            } else {
                $join_details = Tournament_participants::where('match_id', $id)
                    ->where('user_id', $user->id)
                    ->first();
                $participants = Tournament_participants::where('match_id', $id)->get();
                return view('front.tournament-details', compact('tournament', 'join_details', 'participants'));
            }
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }

    function joinTournament(Request $request)
    {
        request()->validate([
            'ign' => 'required',
        ]);

        $user = auth()->user();
        $tournament = Tournament::find($request->match_id);
        if ($tournament) {
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            }
            $participant = Tournament_participants::create(['ign' => $request->ign, 'match_id' => $request->match_id, 'user_id' => $user->id]);


            return redirect('/games/bgmi#upcoming-matches')
                ->with('success', __('Join successfully.'));
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }
}
