<?php

namespace App\Http\Controllers;

use App\Facades\UtilityFacades;
use App\Models\User;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class LanguageController extends Controller
{
    // function __construct()
    // {
    //     $this->middleware('permission:manage-langauge|create-langauge|edit-langauge|delete-langauge', ['only' => ['index','show']]);
    //     $this->middleware('permission:create-langauge', ['only' => ['createLanguage','storeLanguage']]);
    //     $this->middleware('permission:edit-langauge', ['only' => ['edit','update']]);
    //     $this->middleware('permission:delete-langauge', ['only' => ['destroyLang']]);

    // }

    public function changeLanquage($lang)
    {
        $user  = Auth::user();
        $user->lang = $lang;
        $user->save();
        App::setLocale($lang);
        session()->put('locale', $lang);  

        return redirect()->back()->with('success', __('Language change successfully.'));
    }

    public function manageLanguage($currantLang)
    {


        $languages = UtilityFacades::languages();

        $dir = base_path() . '/resources/lang/' . $currantLang;
        if (!is_dir($dir)) {
            $dir = base_path() . '/resources/lang/en';
        }
        $arrLabel   = json_decode(file_get_contents($dir . '.json'));
        $arrFiles   = array_diff(
            scandir($dir),
            array(
                '..',
                '.',
            )
        );
        $arrMessage = [];

        foreach ($arrFiles as $file) {
            $fileName = basename($file, ".php");
            $fileData = $myArray = include $dir . "/" . $file;
            if (is_array($fileData)) {
                $arrMessage[$fileName] = $fileData;
            }
        }


        return view('lang.index', compact('languages', 'currantLang', 'arrLabel', 'arrMessage'));
    }

    public function storeLanguageData(Request $request, $currantLang)
    {
        if (\Auth::user()->can('manage-langauge')) {
            $Filesystem = new Filesystem();
            $dir        = base_path() . '/resources/lang/';
            if (!is_dir($dir)) {
                mkdir($dir);
                chmod($dir, 0777);
            }
            $jsonFile = $dir . "/" . $currantLang . ".json";

            if (isset($request->label) && !empty($request->label)) {
                file_put_contents($jsonFile, json_encode($request->label));
            }

            $langFolder = $dir . "/" . $currantLang;

            if (!is_dir($langFolder)) {
                mkdir($langFolder);
                chmod($langFolder, 0777);
            }
            if (isset($request->message) && !empty($request->message)) {
                foreach ($request->message as $fileName => $fileData) {
                    $content = "<?php return [";
                    $content .= $this->buildArray($fileData);
                    $content .= "];";
                    file_put_contents($langFolder . "/" . $fileName . '.php', $content);
                }
            }

            return redirect()->route('manage.language', [$currantLang])->with('success', __('Language save successfully.'));
        } else {
            return redirect()->back();
        }
    }

    public function buildArray($fileData)
    {
        $content = "";
        foreach ($fileData as $lable => $data) {
            if (is_array($data)) {
                $content .= "'$lable'=>[" . $this->buildArray($data) . "],";
            } else {
                $content .= "'$lable'=>'" . addslashes($data) . "',";
            }
        }

        return $content;
    }

    public function createLanguage()
    {
        return view('lang.create');
    }

    public function storeLanguage(Request $request)
    {
        if (\Auth::user()->can('manage-langauge')) {
            $Filesystem = new Filesystem();
            $langCode   = strtolower($request->code);
            $langDir    = base_path() . '/resources/lang/';
            $dir        = $langDir;
            if (!is_dir($dir)) {
                mkdir($dir);
                chmod($dir, 0777);
            }
            $dir      = $dir . '/' . $langCode;
            $jsonFile = $dir . ".json";
            \File::copy($langDir . 'en.json', $jsonFile);

            if (!is_dir($dir)) {
                mkdir($dir);
                chmod($dir, 0777);
            }
            $Filesystem->copyDirectory($langDir . "en", $dir . "/");

            return redirect()->route('manage.language', [$langCode])->with('success', __('Language successfully created.'));
        } else {
            return redirect()->back();
        }
    }

    public function destroyLang($lang)
    {

        $default_lang = env('default_language') ?? 'en';
        $langDir      = base_path() . '/resources/lang/';
        if (is_dir($langDir)) {
            // remove directory and file
            UtilityFacades::delete_directory($langDir . $lang);
            unlink($langDir . $lang . '.json');
            // update user that has assign deleted language.
            User::where('lang', 'LIKE', $lang)->update(['lang' => $default_lang]);
        }

        return redirect()->route('manage.language', $default_lang)->with('success', __('Language Deleted Successfully.'));
    }
}
