<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use TCPDF;

class PDFController extends Controller
{
    public function index()
    {

        
        return view('dashboard.index');
    }


    public function saveScreenshot(Request $request)
    {

        $request->validate([
            'image' => 'required',
            'id' => 'required',
        ]);

        $id = $request->input('id');
        $user = User::findOrFail($id);

        $image = $request->input('image'); // Base64 encoded image

        // Decode the image
        $image = str_replace('data:image/png;base64,', '', $image);
        $image = str_replace(' ', '+', $image);
        $imageData = base64_decode($image);

        // Save the image to the storage
        if (!file_exists(storage_path('app/'.$user->id))) {
            mkdir(storage_path('app/'.$user->id), 0777, true);
        }
        $imagePath = storage_path('app/'.$user->id.'/screenshot.png');
        file_put_contents($imagePath, $imageData);

        // Get image size in pixels
        
        return response()->json(['message' => 'PDF generated successfully']);
    }

    public function generatePDF($id)
    {

        $user = User::findOrFail($id);

        $imagePath = storage_path('app/'.$user->id.'/screenshot.png');

        list($originalWidth, $originalHeight) = getimagesize($imagePath);

        // Set DPI for the image (e.g., 96 for web screenshots)
        $dpi = 96; // Adjust based on your screenshot resolution

        // Convert pixel dimensions to mm
        $widthMm = ($originalWidth / $dpi) * 25.4;
        $heightMm = ($originalHeight / $dpi) * 25.4;

        // Set page size to match the image size
        $pdfWidth = $widthMm;
        $pdfHeight = $heightMm;

        // Generate PDF with TCPDF
        $pdf = new TCPDF();
        $pdf->AddPage('P', array($pdfWidth, $pdfHeight)); // Set custom page size

        // Add the screenshot image to the PDF, filling the page
        $pdf->Image($imagePath, 0, 0, $pdfWidth, $pdfHeight, 'PNG');

        // Save the PDF
        $pdfOutput = storage_path('app/'.$user->id.'/'.$user->name.'.pdf');
        $pdf->Output($pdfOutput, 'D'); // Save the PDF file


        // Close and output PDF document
        // $pdf->Output('sample.pdf', 'D'); // 'I' for inline display, 'D' for download // Download the PDF
    }
}