<?php

namespace App\Http\Controllers;

use App\DataTables\ProductsDataTable;
use App\Models\Product;
use App\Models\User;
use Illuminate\Http\Request;
use DB;
use Spatie\Permission\Models\Permission;

class ProductController extends Controller
{
    public function index(ProductsDataTable $table)
    {
        if (\Auth::user()->can('manage-product')) {

            $users = User::where('type', 'User')->pluck('name', 'id');

        return $table->render('products.index',compact('users'));
        } else {
            return redirect()->back()->with('error', 'Permission denied.');
        }
    }


    public function create($id)
    {
        if (\Auth::user()->can('create-product')) {

        $user = User::findOrFail($id);
        return view('products.create', compact('user'));
        } else {
            return redirect()->back()->with('error', 'Permission denied.');
        }
    }


    public function store(Request $request)
    {
        if (\Auth::user()->can('create-product')) {




            $request->validate([
                'user_id' => 'required',
                'name' => 'required|string',
                'equipment' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'company.*' => 'required',
                
            ]);

            // Handle file upload
            if ($request->hasFile('equipment')) {
                $imageName = time() . '.' . $request->equipment->extension();
                $request->equipment->storeAs('products', $imageName);
                $imageName = 'products/' . $imageName;
            }

            $companies = [];
            foreach ($request->company as $key => $value) {
                $companies[] = [
                    'company' => $value,
                    'specification' => $request->specification[$key],
                ];
            }

            // Create new product
            $product = new Product();
            $product->user_id = $request->user_id;
            $product->equipment = $imageName;
            $product->name = $request->name;
            $product->company = json_encode($companies);
            $product->save();

        return redirect()->route('products.index')
            ->with('success', __('Product Create successfully'));
        } else {
            return redirect()->back()->with('error', 'Permission denied.');
        }
    }


    public function show(product $product)
    {
    }


    public function edit($id)
    {
        if (\Auth::user()->can('edit-product')) {

        $product = Product::find($id);
        return view('products.edit', compact('product'));
        } else {
            return redirect()->back()->with('error', 'Permission denied.');
        }
    }


    public function update(Request $request, $id)
    {
        $product = Product::find($id);
        $request->validate([
            'name' => 'required|string',
            'company.*' => 'required',

        ]);

        // Handle file upload
        if ($request->hasFile('equipment')) {
            $imageName = time() . '.' . $request->equipment->extension();
            $request->equipment->storeAs('products', $imageName);
            $imageName = 'products/' . $imageName;
            $product->equipment = $imageName;
        }

        $companies = [];
        foreach ($request->company as $key => $value) {
            $companies[] = [
                'company' => $value,
                'specification' => $request->specification[$key],
            ];
        }

        
        $product->name = $request->name;
        $product->company = json_encode($companies);
        $product->save();
        return redirect()->route('products.index')->with('message', 'Product Updated Sucessfully.');
    }


    public function destroy($id)
    {
        if (\Auth::user()->can('delete-product')) {

        Product::where('id', $id)->firstorfail()->delete();
        return redirect()->route('products.index')->with('success', __('product delete successfully.'));
        } else {
            return redirect()->back()->with('error', 'Permission denied.');
        }
    }
}
