<?php

namespace App\Http\Controllers;

use App\Facades\UtilityFacades;
use App\Mail\TestMail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Http\Request;
use Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Str;

class SettingsController extends Controller
{

    public function index()
    {
        return view('settings.index');
    }

    public function appNameUpdate(Request $request)
    {
        
        $this->validate($request, [
            'app_logo' => 'nullable|image|max:2048',
            'app_small_logo' => 'nullable|image|max:2048',
            'favicon_logo' => 'nullable|image|max:2048',
            'app_name' => 'required'
        ]);
        $data = [];
        if ($request->app_logo) {
            Storage::delete(UtilityFacades::getsettings('app_logo'));
            // $app_logo_name = 'app-logo.' . $request->app_logo->extension();
            $app_logo_name = 'app-logo' . time() . '.' . $request->app_logo->getClientOriginalExtension();
            $request->app_logo->storeAs('logo', $app_logo_name);
            $data['app_logo'] = 'logo/' . $app_logo_name;
        }
        if ($request->app_small_logo) {

            Storage::delete(UtilityFacades::getsettings('app_small_logo'));
            $app_small_logo_name = 'app-small-logo' . time() . '.' . $request->app_small_logo->getClientOriginalExtension();
            $request->app_small_logo->storeAs('logo', $app_small_logo_name);
            $data['app_small_logo'] = 'logo/' . $app_small_logo_name;
        }

       

        if ($request->favicon_logo) {

            Storage::delete(UtilityFacades::getsettings('favicon_logo'));
            $favicon_logo_name = 'favicon-logo' . time() . '.' . $request->favicon_logo->getClientOriginalExtension();
            $request->favicon_logo->storeAs('logo', $favicon_logo_name);
            $data['favicon_logo'] = 'logo/' . $favicon_logo_name;
        }

        if ($request->support_image) {

            Storage::delete(UtilityFacades::getsettings('support_image'));
            $support_image_name = 'support-image' . time() . '.' . $request->support_image->getClientOriginalExtension();
            $request->support_image->storeAs('logo', $support_image_name);
            $data['support_image'] = 'logo/' . $support_image_name;
        }
        $data['app_name'] = $request->app_name;


        foreach ($data as $key => $value) {
            UtilityFacades::storesettings(['key' => $key, 'value' => $value]);
        }
        return redirect()->back()->with('success', __('App Setting changed successfully'));
    }

    public function pusherSettingUpdate(Request $request)
    {
        $this->validate($request, [
            'pusher_id' => 'required|regex:/^[0-9]+$/',
            'pusher_key' => 'required|regex:/^[A-Za-z0-9_.,()]+$/',
            'pusher_secret' => 'required|regex:/^[A-Za-z0-9_.,()]+$/',
            'pusher_cluster' => 'required|regex:/^[A-Za-z0-9_.,()]+$/',
        ], [
            'pusher_id.regex' => 'Invalid Entry! The pusher id only letters, underscore and numbers are allowed',
            'pusher_key.regex' => 'Invalid Entry! The pusher key only letters, underscore and numbers are allowed',
            'pusher_secret.regex' => 'Invalid Entry! The pusher secret only letters, underscore and numbers are allowed',
            'pusher_cluster.regex' => 'Invalid Entry! The pusher cluster only letters, underscore and numbers are allowed',
        ]);
        $data = [
            'pusher_id' => $request->pusher_id,
            'pusher_key' => $request->pusher_key,
            'pusher_secret' => $request->pusher_secret,
            'pusher_cluster' => $request->pusher_cluster,
        ];

        foreach ($data as $key => $value) {
            UtilityFacades::storesettings(['key' => $key, 'value' => $value]);
        }
        return redirect()->back()->with('success', __('Pusher API Keys Updated Successfully'));
    }

    public function s3SettingUpdate(Request $request)
    {
        if ($request->settingtype == 's3') {
            
            $this->validate($request, [
                's3_key' => 'required',
                's3_secret' => 'required',
                's3_region' => 'required',
                's3_bucket' => 'required',
                's3_url' => 'required',
                's3_endpoint' => 'required',
            ], [
                's3_key.regex' => 'Invalid Entry! The s3 key only letters, underscore and numbers are allowed',
                's3_secret.regex' => 'Invalid Entry! The s3 secret only letters, underscore and numbers are allowed',
            ]);
            
            $data = [
                's3_key' => $request->s3_key,
                's3_secret' => $request->s3_secret,
                's3_region' => $request->s3_region,
                's3_bucket' => $request->s3_bucket,
                's3_url' => $request->s3_url,
                's3_endpoint' => $request->s3_endpoint,
                'settingtype' => $request->settingtype,
            ];
            
            foreach ($data as $key => $value) {
                UtilityFacades::storesettings(['key' => $key, 'value' => $value]);
            }
        } else {
            UtilityFacades::storesettings(['key' => 'settingtype', 'value' => $request->settingtype]);
        }

        return redirect()->back()->with('success', __('S3 API Keys Updated Successfully'));
    }

    public function emailSettingUpdate(Request $request)
    {
        $this->validate($request, [
            'mail_mailer' => 'required',
            'mail_host' => 'required',
            'mail_port' => 'required',
            'mail_username' => 'required|email',
            'mail_password' => 'required',
            'mail_encryption' => 'required',
            'mail_from_address' => 'required',
            'mail_from_name' => 'required',
        ], [
            'mail_mailer.regex' => 'Required Entry! The Mail Mailer Not allow empty',
            'mail_host.regex' => 'Required Entry! The Mail Host Not allow empty',
            'mail_port.regex' => 'Required Entry! The Mail Port Not allow empty',
            'mail_username.regex' => 'Required Entry! The Username Mailer Not allow empty',
            'mail_password.regex' => 'Required Entry! The Password Mailer Not allow empty',
            'mail_encryption.regex' => 'Invalid Entry! The Mail encryption Mailer Not allow empty',
            'mail_from_address.regex' => 'Invalid Entry! The Mail From Address Not allow empty',
            'mail_from_name.regex' => 'Invalid Entry! The From name Not allow empty',
        ]);
        $data = [
            'mail_mailer' => $request->mail_mailer,
            'mail_host' => $request->mail_host,
            'mail_port' => $request->mail_port,
            'mail_username' => $request->mail_username,
            'mail_password' => $request->mail_password,
            'mail_encryption' => $request->mail_encryption,
            'mail_from_address' => $request->mail_from_address,
            'mail_from_name' => $request->mail_from_name,
        ];
        $arrEnv = [
            'MAIL_MAILER' => $request->mail_mailer,
            'MAIL_HOST' => $request->mail_host,
            'MAIL_PORT' => $request->mail_port,
            'MAIL_USERNAME' => $request->mail_username,
            'MAIL_PASSWORD' => $request->mail_password,
            'MAIL_ENCRYPTION' => $request->mail_encryption,
            'MAIL_FROM_ADDRESS' => $request->mail_from_address,
            'MAIL_FROM_NAME' => $request->mail_from_name,
        ];
        
                UtilityFacades::setEnvironmentValue($arrEnv);
               $this->updateSettings($data);
        


        

        return redirect()->back()->with('success',  __('Email Setting Updated Successfully'));
    }

    private function updateSettings($input)
    {
        foreach ($input as $key => $data) {
            // \DB::insert(
            //     'insert into settings (`key`, `value`,`created_by`) values (?, ?, ?) ON DUPLICATE KEY UPDATE `key` = VALUES(`key`) AND `created_by` = VALUES(`created_by`)',
            //     [
            //         $key,
            //         $data,
            //         \Auth::user()->admin_id,
            //     ]
            // );
            DB::table('settings')
            ->updateOrInsert(
                ['key' => $key],
                ['value' => $data]
            );
        }
        // foreach ($input as $key => $value) {
        //     setting([$key => $value])->save();
        // }
    }

    public function authSettingsUpdate(Request $request)
    {
        $data = [
            '2fa' => ($request->two_factor_auth == 'on') ? 1 : 0,
            'captcha' => ($request->captcha == 'on') ? 1 : 0,
            'email_verification' => ($request->email_verification == 'on') ? 1 : 0,

            'address' => $request->address,
            'support_email' => $request->support_email,
            'play_store_link' => $request->play_store_link,
            'app_store_link' => $request->app_store_link,
            'app_gallery_link' => $request->app_gallery_link,

            'facebbok_link' => $request->facebbok_link,
            'twitter_link' => $request->twitter_link,
            'lindedln_link' => $request->lindedln_link,
            'instagram_link' => $request->instagram_link,

            'currency' => $request->currency,
            'currency_symbol' => $request->currency_symbol,
            'date_format' => $request->date_format,
            'time_format' => $request->time_format,
        ];
        foreach ($data as $key => $value) {
            UtilityFacades::storesettings(['key' => $key, 'value' => $value]);
        }
        return redirect()->back()->with('success', __('General Settings Updated Successfully'));
    }


    public function backupFiles()
    {
        Artisan::call('backup:run', ['--only-files' => true]);
        $output = Artisan::output();
        if (Str::contains($output, 'Backup completed!')) {
            return redirect()->back()->with('success', __('Application Files Backed-up successfully'));
        } else {
            return redirect()->back()->with('error', __('Application Files Backed-up failed'));
        }
    }

    public function backupDb()
    {
        Artisan::call('backup:run', ['--only-db' => true]);
        $output = Artisan::output();
        if (Str::contains($output, 'Backup completed!')) {
            return redirect()->back()->with('success', __('Application Database Backed-up successfully'));
        } else {
            return redirect()->back()->with('error', __('Application Database Backed-up failed'));
        }
    }

    private function getBackups()
    {
        $path = storage_path('app/app-backups');
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }
        $files = File::allFiles($path);
        $backups = collect([]);
        foreach ($files as $dt) {
            $backups->push([
                'filename' => pathinfo($dt->getFilename(), PATHINFO_FILENAME),
                'extension' => pathinfo($dt->getFilename(), PATHINFO_EXTENSION),
                'path' => $dt->getPath(),
                'size' => $dt->getSize(),
                'time' => $dt->getMTime(),
            ]);
        }
        return $backups;
    }

    public function downloadBackup($name, $ext)
    {
        $path = storage_path('app/app-backups');
        $file = $path . '/' . $name . '.' . $ext;
        $status = Storage::disk('backup')->download($name . '.' . $ext, $name . '.' . $ext);
        return $status;
    }
    public function deleteBackup($name, $ext)
    {
        $path = storage_path('app/app-backups');
        $file = $path . '/' . $name . '.' . $ext;
        $status = File::delete($file);
        if ($status) {
            return redirect()->back()->with('success', __('Backup deleted successfully'));
        } else {
            return redirect()->back()->with('error', __('Ops! an error occured, Try Again'));
        }
    }

    function loadsetting($type)
    {
        $t =  ucfirst(str_replace('-', ' ', $type));
        return view('settings.' . $type, compact('t'));
    }

    public function testMail()
    {
        return view('settings.test_mail');
    }
    public function testSendMail(Request $request)
    {
        $validator = \Validator::make($request->all(), ['email' => 'required|email']);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('error', $messages->first());
        }
        try {
            Mail::to($request->email)->send(new TestMail());
        } catch (\Exception $e) {
            // dd($e->getMessage());
            $smtp_error = __($e->getMessage());
            return redirect()->back()->with('error', $smtp_error);
        }
        return redirect()->back()->with('success', __('Email send Successfully.'));
    }
}
