<?php

namespace App\Http\Controllers;

use App\DataTables\TestDataTable;
use App\DataTables\TransactionDataTable;
use App\DataTables\UserDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
use Illuminate\Support\Arr;
use App\DataTables\UsersDataTable;
use App\DataTables\WithdrawDataTable;
use App\Facades\Utility;
use App\Facades\UtilityFacades;
use App\Mail\ApproveMail;
use App\Mail\DisapprovedMail;
use App\Models\CardDetails;
use App\Models\ChartDetails;
use App\Models\Offerdetails;
use App\Models\Product;
use App\Models\UserDocuments;
use App\Models\WithdrawRequests;
use Illuminate\Support\Facades\Auth;
use File;
use Notification;
use App\Notifications\SendPushNotification;
use Barryvdh\DomPDF\Facade\Pdf;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\Mail;
use TCPDF;
use Yajra\DataTables\Facades\DataTables;

class UserController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(UserDataTable $dataTable)
    {
        if (\Auth::user()->can('manage-user')) {


            return $dataTable->render('users.index');
        }
    }

    function dynamicPDF($id)
    {
        $user = User::find($id);
        $offerDetails = Offerdetails::where('user_id', $user->id)->first();
        $chartDetails = ChartDetails::where('user_id', $user->id)->get();
        $chartData = ChartDetails::select('year', 'net_return')->where('user_id', $user->id)->orderBy('year')->get();
        $products = Product::where('user_id', $user->id)->get();
        return view('dashboard.index', compact('user','offerDetails','products','chartDetails','chartData'));
        // $pdf = TCPDF::loadView('dashboard.index', compact('user'));
        return $pdf->download('dynamic_pdf.pdf');
    }


    function newPDF($id)
    {

        $websiteContent = file_get_contents('http://localhost/fourcell/dynamic-pdf/5');

        $dompdf = new Dompdf();
        $dompdf->loadHtml($websiteContent);

        $dompdf->render();
        $dompdf->stream('document.pdf');
        
      
        $user = User::find($id);
        $offerDetails = Offerdetails::where('user_id', $user->id)->first();
        $chartDetails = ChartDetails::where('user_id', $user->id)->get();
        $chartData = ChartDetails::select('year', 'net_return')->where('user_id', $user->id)->orderBy('year')->get();
        $products = Product::where('user_id', $user->id)->get();
        // return view('dashboard.index', compact('user', 'offerDetails', 'products', 'chartDetails', 'chartData'));

        $pdf = Pdf::loadView('dashboard.pdf', compact('user', 'offerDetails', 'products', 'chartDetails', 'chartData'));

        // Set paper size and orientation if needed (optional)
        // $pdf->setPaper('A4', 'landscape');

        // Stream the PDF to the browser
        return $pdf->stream('document.pdf');
        // $pdf = TCPDF::loadView('dashboard.index', compact('user'));
        // return $pdf->download('dynamic_pdf.pdf');
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (\Auth::user()->can('create-user')) {
            $roles = Role::where('name', '!=', 'Super Admin')->orderBy('id', 'desc')->pluck('name', 'name')->all();
            return view('users.create', compact('roles'));
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (\Auth::user()->can('create-user')) {

            $this->validate($request, [
                'name' => 'required',
                'address' => 'required',
                'refrence' => 'required',
                'quote_number' => 'required',
                'kw' => 'required',
                'date' => 'required'
            ]);

            $input = $request->all();

            
            // dd(json_encode($social_links));


            $dummy_user = User::find(12);
            $newUser = $dummy_user->replicate(); // Clone the user data

            $newUser->name = $input['name'];
            $newUser->address = $input['address'];
            $newUser->refrence = $input['refrence'];
            $newUser->quote_number = $input['quote_number'];
            $newUser->kw = $input['kw'];
            $newUser->date = $input['date'];
            $newUser->email = 'user' . rand(1000, 9999) . '@gmail.com';
            $newUser->save();
            $newUser->assignRole('User');




            // $all_clinnts = User::where('id', '!=', '12')->where('type', 'User')->get();
            // $social_links = [];
            // foreach ($all_clinnts as $clinnt) {
            //     $social_links[] = [
            //         'name' => $clinnt->name,
            //         'kw' => $clinnt->kw,
            //         'location' => $clinnt->address,
            //         'link' => ''
            //     ];
            // }



            $offer_detials = Offerdetails::where('user_id', 12)->first()->replicate();
            $offer_detials->user_id = $newUser->id;
            $offer_detials->save();

           

            

            
            
            // $chart_detials = ChartDetails::where('user_id', 12)->get();
            // foreach ($chart_detials as $chart) {
            //     $new_chart = $chart->replicate();
            //     $new_chart->user_id = $newUser->id;
            //     $new_chart->save();
            // }

            $products = Product::where('user_id', 12)->get();
            foreach ($products as $product) {
                $new_product = $product->replicate();
                $new_product->user_id = $newUser->id;
                $new_product->save();
            }


            

            
            return redirect()->route('users.index')
                ->with('success', 'Client created successfully');
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (\Auth::user()->can('manage-user')) {

            $user = User::find($id);
            $view = view('users.show', compact('user'))->render();
            return response()->json(['is_success' => true, 'html' => $view], 200);
        } else {
            return response()->json(['is_success' => false, 'message' => 'permission denide'], 200);
        }
    }

    function cardTransactions($card_id, Request $request)
    {
        // dd($request->all());

        // dd($start);
        if (\Auth::user()->can('manage-user')) {
            $card_exist = CardDetails::where('card_id', $card_id)->first();
            // dd($card_exist);
            if ($card_exist) {
                $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card->card_id;

                $card_details = UtilityFacades::callGetApi($card_api);

                if (isset($card_details['status']) && $card_details['status'] == 'success') {


                    $perPage = $request->input('length', 10);
                    // dd($perPage);
                    // Current page
                    $currentPage = $request->input('start', 0) / $perPage + 1;

                    $card_trx_api = env('BASE_API_URL') . 'cards/get_card_transactions?card_id=' . $card_exist->card_id . '&page=' . $currentPage;
                    $transaction_list = UtilityFacades::callGetApi($card_trx_api, 'get');

                    // dd($transaction_list);
                    if (isset($transaction_list['status']) && $transaction_list['status'] == 'success') {
                        // dd($transaction_list);
                        $data = $transaction_list['data'];
                        if ($request->ajax()) {
                            // dd($request->input('draw'));

                            return response()->json([
                                'draw' => $request->input('draw', 1),
                                'recordsTotal' => $transaction_list['data']['meta']['total'], // Total records without pagination
                                // 'recordsTotal' => 10, // Total records without pagination
                                'recordsFiltered' => $transaction_list['data']['meta']['total'], // Total records with pagination
                                'data' => $data['transactions'],
                            ]);
                        }
                        return view('cards.trasactions', compact('card_id', 'data'));
                    } else {
                        return redirect()->back()->with('failed', __($transaction_list['message']));
                    }
                } else {
                    return redirect()->back()->with('failed', __($card_details['message']));
                }
            } else {
                return redirect()->back()->with('failed', __('Card not created.'));
            }
        } else {
            return redirect()->back()->with('failed', 'Permission denied.');
        }
    }

    public function cardTransactionsDetails($card_id, $refrence_id)
    {
        if (\Auth::user()->can('manage-user')) {

            $card = CardDetails::where('card_id', $card_id)->first();
            if ($card) {
                $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card->card_id;

                $card_details = UtilityFacades::callGetApi($card_api);

                if (isset($card_details['status']) && $card_details['status'] == 'success') {

                    // dd($card);
                    $user = User::find($card->user_id);
                    $card_trx_api = env('BASE_API_URL') . 'cards/get_card_transaction_by_id?card_id=' . $card->card_id . '&client_transaction_reference=' . $refrence_id;

                    $trx_details = UtilityFacades::callGetApi($card_trx_api);

                    if (isset($trx_details['status']) && $trx_details['status'] == 'success') {

                        $card_trx_status = env('BASE_API_URL') . 'cards/get_card_transaction_status?card_id=' . $card->card_id . '&client_transaction_reference=' . $refrence_id;

                        $trx_status = UtilityFacades::callGetApi($card_trx_status);
                        if (isset($trx_status['status']) && $trx_status['status'] == 'success') {

                            $details = $trx_details['data'];

                            $details['status'] = $trx_status['data']['transaction_status'];
                            // dd($details);
                            $view = view('cards.transaction_details', compact('card', 'user', 'details'))->render();
                            return response()->json(['is_success' => true, 'html' => $view], 200);
                        } else {
                            return response()->json(['is_success' => false, 'message' => $trx_status['message']], 200);
                        }
                    } else {
                        return response()->json(['is_success' => false, 'message' => $trx_details['message']], 200);
                    }
                } else {
                    return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => 'card not found'], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => 'Permission denide'], 200);
        }
    }

    public function cardDetails($id)
    {
        if (\Auth::user()->can('manage-user')) {

            $card = CardDetails::find($id);
            $user = User::find($card->user_id);
            $card_api = 'https://issuecards-api-bridgecard-co.relay.evervault.com/v1/issuing/sandbox/cards/get_card_details?card_id=' . $card->card_id;

            $card_details = UtilityFacades::callGetApi($card_api);

            if (isset($card_details['status']) && $card_details['status'] == 'success') {
                $details = $card_details['data'];
                // dd($details);
                $view = view('cards.show', compact('card', 'user', 'details'))->render();
                return response()->json(['is_success' => true, 'html' => $view], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
            }
        }
    }


    public function fundUnloadCardForm($id, $action)
    {
        if (\Auth::user()->can('manage-user')) {
            $card = CardDetails::find($id);
            if ($card) {
                $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card->card_id;

                $card_details = UtilityFacades::callGetApi($card_api);

                if (isset($card_details['status']) && $card_details['status'] == 'success') {
                    $view =  view('cards.fund-unload-form', compact('card', 'action'))->render();
                    return response()->json(['is_success' => true, 'html' => $view], 200);
                } else {
                    return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => 'Card not found'], 200);
            }
        }
    }

    public function disaaproveModal($id)
    {
        if (\Auth::user()->can('manage-user')) {
            $user = User::find($id);
            if ($user) {
                $view = view('users.disapprove-form', compact('user'))->render();
                return response()->json(['is_success' => true, 'html' => $view], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => 'Card not found'], 200);
            }
        }
    }



    function fundUnloadCard(Request $request)
    {
        // dd($request->all());
        $validator = \Validator::make($request->all(), [
            'amount' => 'required|numeric|min:1',
        ]);
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json([
                'is_success' => false,
                'message' => $messages->first(),
            ], 200);
        }


        $card_exist = CardDetails::where('id', $request->id)->first();

        if ($card_exist) {
            try {
                $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card_exist->card_id;

                $card_details = UtilityFacades::callGetApi($card_api);

                if (isset($card_details['status']) && $card_details['status'] == 'success') {

                    $timestamp = time();
                    $randomNumber = mt_rand(1000, 9999);

                    $data = [
                        'card_id' => $card_exist->card_id,
                        'amount' => $request->amount,
                        'transaction_reference' => $timestamp . $randomNumber,
                        'currency' => UtilityFacades::getValByName('currency'),
                    ];
                    $wallet_data = [
                        'amount' => $request->amount,
                    ];
                    if ($request->type == 'fund') {

                        $get_wallet_fund = env('BASE_API_URL') . 'cards/get_issuing_wallet_balance';
                        $wallet_balance = UtilityFacades::callGetApi($get_wallet_fund, 'get');

                        $add_wallet_fund = env('BASE_API_URL') . 'cards/fund_issuing_wallet';
                        $fund_wallet = UtilityFacades::callGetApi($add_wallet_fund, 'patch', $wallet_data);
                        // dd($wallet_balance);


                        $fun_card_api = env('BASE_API_URL') . 'cards/fund_card_asynchronously';

                        $fund_card = UtilityFacades::callGetApi($fun_card_api, 'patch', $data);

                        if (isset($fund_card['status']) && $fund_card['status'] == 'success') {
                            return response()->json([
                                'is_success' => true,
                                'message' => __('Card Fund Successfully'),
                            ], 200);
                        } else {
                            return response()->json(['is_success' => false, 'message' => $fund_card['message']], 200);
                        }
                    } else {

                        $unload_card_api = env('BASE_API_URL') . 'cards/unload_card_asynchronously';

                        $unload_card = UtilityFacades::callGetApi($unload_card_api, 'patch', $data);

                        if (isset($unload_card['status']) && $unload_card['status'] == 'success') {

                            $add_wallet_fund = env('BASE_API_URL') . 'cards/fund_issuing_wallet';
                            $fund_wallet = UtilityFacades::callGetApi($add_wallet_fund, 'patch', $wallet_data);
                            if (isset($fund_wallet['status']) && $fund_wallet['status'] == 'success') {
                                return response()->json([
                                    'is_success' => true,
                                    'message' => __('Card Unload Successfully'),
                                ], 200);
                            } else {
                                return response()->json(['is_success' => false, 'message' => $fund_wallet['message']], 200);
                            }
                        } else {
                            return response()->json(['is_success' => false, 'message' => $unload_card['message']], 200);
                        }
                    }
                } else {
                    return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
                }
            } catch (\Exception $e) {
                return response()->json(['is_success' => false, 'failed' => $e->getMessage()], 500);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
        }
    }

    function approveUser(Request $request)
    {
        if (\Auth::user()->can('edit-user')) {
            $user = User::find($request->user_id);
            if ($user) {
                $status = 'Approved';
                $card_exist = CardDetails::where('user_id', $user->id)->first();
                $user_documents = UserDocuments::where('user_id', $user->id)->first();

                if ($card_exist) {
                    $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card_exist->card_id;

                    $card_details = UtilityFacades::callGetApi($card_api);

                    if (isset($card_details['status']) && $card_details['status'] == 'success') {

                        // $result = $this->updateUserStatus($card_exist->card_holder_id,'active');
                        $active_card = env('BASE_API_URL') . 'cards/unfreeze_card?card_id=' . $card_exist->card_id;

                        $result = UtilityFacades::callGetApi($active_card, 'patch');
                        if (isset($result['status']) && $result['status'] == 'success') {
                            $user->is_active = 1;
                            $user->save();

                            $card_exist->status = 1;
                            $card_exist->save();

                            $user_documents->status = 1;
                            $user_documents->save();

                            try {
                                Mail::to($user->email)->send(new ApproveMail($user));
                                return response()->json(['is_success' => true, 'message' => 'User ' . $status . ' Successfully'], 200);
                            } catch (\Exception $e) {
                                $smtp_error = __($e->getMessage());
                                return response()->json(['is_success' => false, 'message' => $smtp_error, 'data' => $user->apiFormat()], 200);
                            }
                        } else {
                            return response()->json(['is_success' => false, 'message' => $result['message']], 200);
                        }
                    } else {
                        return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
                    }
                } else {
                    return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('User not found.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('Permission Denide.')], 200);
        }
    }

    function withdrawStatusForm($id, $status)
    {
        if (\Auth::user()->can('manage-user')) {
            $card = WithdrawRequests::find($id);
            if ($card) {


                $view =  view('users.withdraw-accept-reject-form', compact('card', 'status'))->render();
                return response()->json(['is_success' => true, 'html' => $view], 200);
            } else {
                return response()->json(['is_success' => false, 'message' => 'Card not found'], 200);
            }
        }
    }
    function withdrawStatusUpdate(Request $request)
    {
        dd($request->all());
    }
    function disapproveUser(Request $request)
    {
        if (\Auth::user()->can('edit-user')) {
            $user = User::find($request->user_id);
            if ($user) {
                $status = 'Disapproved';
                $card_exist = CardDetails::where('user_id', $user->id)->first();
                $user_documents = UserDocuments::where('user_id', $user->id)->first();

                if ($card_exist) {
                    $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card_exist->card_id;

                    $card_details = UtilityFacades::callGetApi($card_api);

                    if (isset($card_details['status']) && $card_details['status'] == 'success') {

                        // $result = $this->updateUserStatus($card_exist->card_holder_id,'active');
                        $inactive_card = env('BASE_API_URL') . 'cards/freeze_card?card_id=' . $card_exist->card_id;

                        $result = UtilityFacades::callGetApi($inactive_card, 'patch');
                        if (isset($result['status']) && $result['status'] == 'success') {
                            $user->is_active = 0;
                            $user->disapprove_reason = $request->disapprove_reason;
                            $user->save();

                            $card_exist->status = 0;
                            $card_exist->save();

                            $user_documents->status = 2;
                            $user_documents->save();
                            try {
                                Mail::to($user->email)->send(new DisapprovedMail($user));
                                return response()->json(['is_success' => true, 'message' => 'User ' . $status . ' Successfully'], 200);
                            } catch (\Exception $e) {
                                $smtp_error = __($e->getMessage());
                                return response()->json(['is_success' => false, 'message' => $smtp_error, 'data' => $user->apiFormat()], 200);
                            }
                        } else {
                            return response()->json(['is_success' => false, 'message' => $result['message']], 200);
                        }
                    } else {
                        return response()->json(['is_success' => false, 'message' => $card_details['message']], 200);
                    }
                } else {
                    return response()->json(['is_success' => false, 'message' => __('Card not created.')], 200);
                }
            } else {
                return response()->json(['is_success' => false, 'message' => __('User not found.')], 200);
            }
        } else {
            return response()->json(['is_success' => false, 'message' => __('Permission Denide.')], 200);
        }
    }

    function WithdrawReq(WithdrawDataTable $table)
    {
        return $table->render('users.withdraw_request');
    }





    function updateUserStatus($id, $status, $type)
    {

        if (\Auth::user()->can('edit-user')) {

            $user = User::find($id);
            if ($user) {

                $card_exist = CardDetails::where('user_id', $user->id)->first();
                $user_documents = UserDocuments::where('user_id', $user->id)->first();

                if ($card_exist) {
                    $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card_exist->card_id;

                    $card_details = UtilityFacades::callGetApi($card_api);
                    // dd($card_details);
                    if (isset($card_details['status']) && $card_details['status'] == 'success') {

                        if ($status == 'inactive') {
                            if ($type == 'user') {
                                $user->is_active =  0;
                            }
                            $card_exist->status = 0;
                            $api = 'freeze_card';
                        } else {
                            if ($type == 'user') {
                                $user->is_active =  1;
                            }
                            $card_exist->status = 1;
                            $api = 'unfreeze_card';
                        }

                        $inactive_card = env('BASE_API_URL') . 'cards/' . $api . '?card_id=' . $card_exist->card_id;

                        $result = UtilityFacades::callGetApi($inactive_card, 'patch');
                        // dd($result);
                        if (isset($result['status']) && $result['status'] == 'success') {
                            if ($type == 'user') {
                                $user->save();
                            }
                            $card_exist->save();
                            return redirect()->route(($type == 'user' ? 'users.index' : 'card-list'))
                                ->with('success', 'User ' . $status . ' successfully');
                        } else {
                            return redirect()->back()->with('failed', $result['message']);
                        }
                    } else {
                        return redirect()->back()->with('failed', $card_details['message']);
                    }
                } else {
                    return redirect()->back()->with('failed', __('Card not created.'));
                }
            } else {
                return redirect()->back()->with('failed', __('User not found.'));
            }
        } else {
            return redirect()->back()->with('failed', 'Permission denied.');
        }
    }

    function deleteCard($user_id)
    {
        if (\Auth::user()->can('edit-user')) {
            $user = User::find($user_id);
            if ($user) {
                $status = 'Disapproved';
                $card_exist = CardDetails::where('user_id', $user->id)->first();
                $user_documents = UserDocuments::where('user_id', $user->id)->first();

                if ($card_exist) {
                    $card_api = env('BASE_API_URL') . 'cards/get_card_details?card_id=' . $card_exist->card_id;

                    $card_details = UtilityFacades::callGetApi($card_api);

                    if (isset($card_details['status']) && $card_details['status'] == 'success') {

                        // $result = $this->updateUserStatus($card_exist->card_holder_id,'active');
                        $delete_card_holder = env('BASE_API_URL') . 'cardholder/delete_cardholder/' . $card_exist->card_holder_id;
                        $delete_cardholder_response = UtilityFacades::callGetApi($delete_card_holder, 'delete');
                        // dd($delete_cardholder_response);
                        if (isset($delete_cardholder_response['status']) && $delete_cardholder_response['status'] == 'success') {
                            $card_exist->delete();

                            return redirect()->back()->with('success', 'Card deleted Succesfully');
                        } else {
                            return redirect()->back()->with('failed', $delete_cardholder_response['message']);
                        }
                    } else {
                        return redirect()->back()->with('failed', $card_details['message']);
                    }
                } else {
                    return redirect()->back()->with('failed', __('Card not created.'));
                }
            } else {
                return redirect()->back()->with('failed', __('User not found.'));
            }
        } else {
            return redirect()->back()->with('failed', 'Permission denied.');
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        if (\Auth::user()->can('edit-user')) {
            $user = User::find($id);
            $roles = Role::pluck('name', 'name')->all();
            $userRole = $user->roles->pluck('name', 'name')->all();

            return view('users.edit', compact('user', 'roles', 'userRole'));
        }
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (\Auth::user()->can('edit-user')) {
            $this->validate($request, [
                'name' => 'required',
                'address' => 'required',
                'refrence' => 'required',
                'quote_number' => 'required',
                'kw' => 'required',
                'date' => 'required'
            ]);
            $input = $request->all();
            // dd($input);

            $user = User::find($id);
           
            $user->update($input);


            return redirect()->route('users.index')
                ->with('success', 'Basic Details updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (\Auth::user()->can('delete-user')) {
            ChartDetails::where('user_id', $id)->delete();
            Product::where('user_id', $id)->delete();
            Offerdetails::where('user_id', $id)->delete();
            User::find($id)->delete();
            return redirect()->route('users.index')
                ->with('success', 'User deleted successfully');
        }
    }

    public function profile()
    {

        $users = \Auth::user();
        return view('users.profile', ['users' => $users]);
    }

    public function editprofile(Request $request)
    {
        $user = \Auth::user();
        $user       = User::findOrFail($user['id']);
        $this->validate(
            $request,
            [
                'name' => 'required|max:120',
                'email' => 'required|email|unique:users,email,' . $user['id'],
            ]
        );
        if ($request->hasFile('profile')) {
            $filenameWithExt = $request->file('profile')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('profile')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;

            $dir        = storage_path('uploads/avatar');
            $image_path = $dir . $user['avatar'];

            if (File::exists($image_path)) {
                File::delete($image_path);
            }

            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }

            $path = $request->file('profile')->storeAs('uploads/avatar', $fileNameToStore);
        }

        if (!empty($request->profile)) {
            $user['avatar'] = $fileNameToStore;
        }
        $user['name']  = $request['name'];
        $user['email'] = $request['email'];
        $user->save();

        return redirect()->back()->with(
            'success',
            'Profile successfully updated.'
        );
    }


    public function updatePassword(Request $request)
    {
        if (Auth::Check()) {
            $request->validate(
                [
                    'current_password' => 'required',
                    'new_password' => 'required|min:6',
                    'confirm_password' => 'required|same:new_password',
                ]
            );
            $objUser          = Auth::user();
            $request_data     = $request->All();
            $current_password = $objUser->password;
            if (Hash::check($request_data['current_password'], $current_password)) {
                $user_id            = Auth::User()->id;
                $obj_user           = User::find($user_id);
                $obj_user->password = Hash::make($request_data['new_password']);;
                $obj_user->save();

                return redirect()->route('profile', $objUser->id)->with('success', __('Password successfully updated.'));
            } else {
                return redirect()->route('profile', $objUser->id)->with('failed', __('Please enter correct current password.'));
            }
        } else {
            return redirect()->route('profile', \Auth::user()->id)->with('failed', __('Something is wrong.'));
        }
    }

    function noti()
    {
        return view('users.noti');
    }

    public function saveToken(Request $request)
    {
        auth()->user()->update(['fcm_token' => $request->token]);
        return response()->json(['token saved successfully.']);
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function sendNotification(Request $request)
    {
        $firebaseToken = User::whereNotNull('fcm_token')->pluck('fcm_token')->all();

        $SERVER_API_KEY = 'XXXXXX';

        $data = [
            "registration_ids" => $firebaseToken,
            "notification" => [
                "title" => $request->title,
                "body" => $request->body,
            ]
        ];
        $dataString = json_encode($data);

        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        $response = curl_exec($ch);

        dd($response);
    }
}
