<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class ApiTokenMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next)
    {
        // Check if the request has a valid API token
        if (Auth::guard('api')->check()) {
            return $next($request);
        }

        // Custom JSON response for invalid token
        return response()->json([
            'is_success' => false,
            'error' => 'Invalid API token',
            'message' => 'Please provide a valid API token in the Authorization header.'
        ], 401);
    }
}
