<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeMail extends Mailable
{
    use Queueable, SerializesModels;
    protected $vendor_details;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($vendor_details)
    {
        $this->vendor_details = $vendor_details;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('mails.email_verification')->with('vendor_details', $this->vendor_details)->subject('Email Verification');
    }
}
