<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Crypt;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'address',
        'refrence',
        'quote_number',
        'type',
        'kw',
        'date',
        'lang',
        'welcome_message',
        'mw',
        'customers',
        'category',
        
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
    public function currentLanguage()
    {
        return $this->lang;
    }

    function Citydetails(){
        return $this->hasOne('App\Models\Cities', 'id', 'city')->select('id','name');
    }

    function offerDetails()
    {
        return $this->hasOne('App\Models\Offerdetails', 'id', 'user_id');
    }
    function products()
    {
        return $this->hasMany(Product::class);
        
    }
    function chartDetails()
    {
        return $this->hasMany(ChartDetails::class);
        
    }
    function Carddetails()
    {
        return $this->hasOne('App\Models\CardDetails', 'user_id', 'id');
        
    }
    function Documents()
    {
        return $this->hasOne('App\Models\UserDocuments', 'user_id', 'id');
    }
    

    public function generateToken()
    {
        $expirationTime = now()->addHour(1);
        $token = $this->createToken('api-token');
        $this->api_token = $token->plainTextToken;
        $this->save();
        return $this->api_token;
    }

    
    public function plan()
    {
        return $this->hasOne(Plan::class, 'id', 'plan_id');
    }

   


    public function assignPlan($plan_id)
    {
        $this->plan_id = $plan_id;
        $this->save();
        $this->syncplanChanges($plan_id);
    }

    public function syncplanChanges($plan_id)
    {
       

        $usr  = $this;

        if ($this->plan->durationtype == 'Month') {
            $this->plan_expired_date = Carbon::now()->addMonths($this->plan->duration)->isoFormat('YYYY-MM-DD');
        } elseif ($this->plan->durationtype == 'Year') {
            $this->plan_expired_date = Carbon::now()->addYears($this->plan->duration)->isoFormat('YYYY-MM-DD');
        } else {
            $this->plan_expired_date = null;
        }
    }

    public function apiFormat()
    {
        $data = $this->toArray();

        unset($data['type']);
        unset($data['updated_at']);
        unset($data['created_at']);
        $data['avatar'] = Storage::url($data['avatar']);
        $data['city_details'] = $this->Citydetails;
        $data['plan_details'] = $this->Plandetails;
        if($this->Carddetails){

            $card_api = 'https://issuecards-api-bridgecard-co.relay.evervault.com/v1/issuing/sandbox/cards/get_card_details?card_id=' . $this->Carddetails->card_id;

            $card_details = $this->callGetApi($card_api);
            // dd($card_details);
            if (isset($card_details['status']) && $card_details['status'] == 'success') {
                $data['card_details'] = $card_details['data'];
            }
            $card_holder = 'https://issuecards.api.bridgecard.co/v1/issuing/sandbox/cardholder/get_cardholder?cardholder_id='. $this->Carddetails->card_holder_id;
            $card_holder_details = $this->callGetApi($card_holder);
            if (isset($card_holder_details['status']) && $card_holder_details['status'] == 'success') {
                $data['card_holder_details'] = $card_holder_details['data'];
            }
            
        }
        return array_map(function ($value) {
            return is_null($value) ? '' : $value;
        }, $data);
    }

     function callGetApi($url, $data = array())
    {

        $token =  env('BRIDGECARD_TOKEN');

        $headers = [
            'token' => 'Bearer ' . $token,
        ];
        // dd($token);

        $client = new Client();

        try {
            $response = $client->get($url, [
                'headers' => $headers
            ]);

            // dd($response);
            $responseData = json_decode($response->getBody(), true);
            return $responseData;
        } catch (\Exception $e) {

            // dd('Error: ' . $e->getMessage());
            return ['status' => false, 'message' => __($e->getMessage())];
            // die;
        }
    }

}
