<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_card_details', function (Blueprint $table) {
            $table->id();
            $table->smallInteger('user_id');
            $table->string('card_holder_id')->nullable();
            $table->string('card_id')->nullable();
            $table->string('card_number')->nullable();
            $table->string('cvc')->nullable();
            $table->string('exp_month')->nullable();
            $table->string('exp_year')->nullable();
            $table->smallInteger('pin')->nullable();
            $table->string('brand')->nullable();
            $table->string('currency')->nullable();
            $table->decimal('spending_limit_amount',8,2)->nullable(0.00);
            $table->string('type')->nullable();
            $table->smallInteger('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_card_details');

    }
};
