<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('offer_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Connects to users table
            $table->decimal('per_kw')->nullable();
            $table->decimal('gross_total')->nullable();
            $table->decimal('dc_capacity')->nullable();
            $table->decimal('ac_capacity')->nullable();
            $table->string('roof_type')->nullable();
            $table->string('evacuation')->nullable();
            $table->decimal('geda_charge')->nullable();
            $table->decimal('meter_charge')->nullable();
            $table->decimal('structure_charge')->nullable();
            $table->decimal('safety_charge')->nullable();
            $table->decimal('manual_cleaning_charge')->nullable();
            $table->decimal('gst')->nullable();
            $table->decimal('grand_total')->nullable();
            $table->decimal('total_amount')->nullable();
            $table->json('included_charges')->nullable(); // To store included charges as JSON
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('offer_details');
    }
};
