<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chart_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Connects to users table
            $table->string('year');
            $table->decimal('yearly_kw', 10, 2);
            $table->decimal('percentage', 5, 2);
            $table->decimal('unit', 10, 2);
            $table->decimal('net_unit', 10, 2);
            $table->decimal('unit_cost', 10, 2);
            $table->decimal('gross_return', 10, 2);
            $table->decimal('bank_ch', 5, 2);
            $table->decimal('bank_charge', 10, 2);
            $table->decimal('maintenance_cost', 10, 2);
            $table->decimal('net_return', 10, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chart_details');
    }
};
