@extends('layouts.front')
@section('title', 'Pricing')
@section('content')

<section class="banner-inner">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-sm-7 text-center text-sm-start">
                <div class="title">
                    <h2>{{ Utility::getcontents('banner_title','pricing-page') }}</h2>
                </div>
            </div>
            <div class="col-sm-5 d-none d-sm-block text-end">
                <div class="image-wrapper lh-0">
                    <img src="{{ Storage::url('content/'.Utility::getcontents('banner_image','pricing-page')) }}" alt="Image" />
                </div>
            </div>
        </div>
    </div>
</section>
<section class="pricing-table">
    <div class="container">
        @if($plans && $plan_country)
        @foreach($plan_country as $country)
        <div class="section-gap">
            <div class="main-title text-center">
                <h2>{{$country['country']}}</h2>
            </div>
            <div class="row g-4">
                @foreach($plans as $plan)
                @if($plan->country == $country['country'])
                <div class="col-lg-6">
                    <div class="pricing-card">
                        <div class="title">
                            {{$plan->name}}
                        </div>
                        <ul>
                            @if($plan->Features)
                            @foreach($plan->Features as $feature)
                            <li>
                                <div class="icon"><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Icon"></div>
                                <h6> {{$feature->feature}} </h6>
                            </li>
                            @endforeach
                            @endif


                        </ul>
                    </div>
                </div>
                @endif
                @endforeach
            </div>
        </div>
        @endforeach
        @endif

    </div>
</section>
<section class="cta section-gap">
    <div class="container">
        <div class="cta-wrapper-main">
            <div class="questions">
                <div class="row">
                    <div class="col-xl-5">
                        <div class="main-title mb-xl-0">
                            <h2>Still have questions ?</h2>
                            <p class="mb-0">We are here to help you</p>
                        </div>
                    </div>
                    <div class="col-xl-7">
                        <ul class="contact">
                            <li>
                                <div class="icon"><img src="{{ asset('assets/front/images/icons/location.svg') }}" alt="Map"></div>
                                <div class="content">
                                    <p>{{ Utility::getsettings('address') }}</p>
                                    <h6>Headquarters</h6>
                                </div>
                            </li>
                            <li>
                                <div class="icon"><img src="{{ asset('assets/front/images/icons/email.svg') }}" alt="Map"></div>
                                <div class="content">
                                    <p> <a href="mailto: {{ Utility::getsettings('support_email') }}">{{ Utility::getsettings('support_email') }}</a> </p>
                                    <h6>Support Email</h6>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <section class="cta-wrapper">
                <div class="container">
                    <div class="cta-wrapper">
                        <div class="row align-items-center">
                            <div class="col-xl-5 col-lg-6 offset-lg-1 order-2 order-lg-1">
                                <div class="main-title">
                                    <h2>{{ Utility::getcontents('app_feature_title','home-page') }}</h2>
                                    <p>
                                        {{ Utility::getcontents('app_feature_description','home-page') }}
                                    </p>
                                </div>
                                <div class="row g-4 mb-4 mb-sm-5">
                                    <div class="col-6">
                                        <div class="cta-card">
                                            <h6>
                                                <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_1','home-page') }}
                                            </h6>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="cta-card">
                                            <h6>
                                                <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_2','home-page') }}
                                            </h6>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="cta-card">
                                            <h6>
                                                <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_3','home-page') }}
                                            </h6>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="cta-card">
                                            <h6>
                                                <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_4','home-page') }}
                                            </h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="btn-wrapper">
                                    <a href="{{ Utility::getsettings('play_store_link') }}"><img src="{{ asset('assets/front/images/icons/play-store.svg') }}" alt="Play Store"></a>
                                    <a href="{{ Utility::getsettings('app_store_link') }}"><img src="{{ asset('assets/front/images/icons/app-store.svg') }}" alt="App Store"></a>
                                    <a href="{{ Utility::getsettings('app_gallery_link') }}"><img src="{{ asset('assets/front/images/icons/app-gallery.svg') }}" alt="App Gallery"></a>
                                </div>
                            </div>
                            <div class="col-lg-4 offset-xl-1 order-1 order-lg-2">
                                <div class="img-wrapper lh-0">
                                    <img src="{{ Storage::url('content/'.Utility::getcontents('app_feature_image','home-page')) }}" alt="Images" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</section>

@endsection