@extends('layouts.front')
@section('title', 'Support & contact')
@section('content')

<section class="banner-inner">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-sm-7 text-center text-sm-start">
                <div class="title">
                    <h2>{{ Utility::getcontents('banner_title','support-page') }}</h2>
                </div>
            </div>
            <div class="col-sm-5 d-none d-sm-block text-end">
                <div class="image-wrapper lh-0">
                    <img src="{{ Storage::url('content/'.Utility::getcontents('banner_image','support-page')) }}" alt="Image" />
                </div>
            </div>
        </div>
    </div>
</section>
<section class="questions-section">
    <div class="container">
        <div class="questions">
            <div class="row">
                <div class="col-xl-5">
                    <div class="main-title mb-xl-0">
                        <h2>Still have questions ?</h2>
                        <p class="mb-0">We are here to help you</p>
                    </div>
                </div>
                <div class="col-xl-7">
                    <ul class="contact">
                        <li>
                            <div class="icon"><img src="{{ asset('assets/front/images/icons/location.svg') }}" alt="Map"></div>
                            <div class="content">
                                <p>{{ Utility::getsettings('address') }}</p>
                                <h6>Headquarters</h6>
                            </div>
                        </li>
                        <li>
                            <div class="icon"><img src="{{ asset('assets/front/images/icons/email.svg') }}" alt="Map"></div>
                            <div class="content">
                                <p> <a href="mailto: {{ Utility::getsettings('support_email') }}">{{ Utility::getsettings('support_email') }}</a> </p>
                                <h6>Support Email</h6>
                            </div>
                        </li>
                    </ul>
                    <div class="social-media">
                        <ul>
                            <li> <a href="{{ Utility::getsettings('facebbok_link') }}"> <img src="{{ asset('assets/front/images/icons/fb.svg') }}" alt="Icon"> Facebook</a></li>
                            <li> <a href="{{ Utility::getsettings('twitter_link') }}"> <img src="{{ asset('assets/front/images/icons/tw.svg') }}" alt="Icon"> Twitter</a></li>
                            <li> <a href="{{ Utility::getsettings('lindedln_link') }}"> <img src="{{ asset('assets/front/images/icons/lnk.svg') }}" alt="Icon"> LinkedIn</a></li>
                            <li> <a href="{{ Utility::getsettings('instagram_link') }}"> <img src="{{ asset('assets/front/images/icons/insta.svg') }}" alt="Icon"> Instagram</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="categories">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <div class="tab-main">
                    <div class="title">
                        <h2>Categories</h2>
                    </div>
                    <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        @if($faq_categories)
                        @foreach($faq_categories as $key => $category)
                        <button class="nav-link {{ $key == 0?'active':'' }} " id="v-pills-{{$category->id}}-tab" data-bs-toggle="pill" data-bs-target="#v-pills-{{$category->id}}" type="button" role="tab" aria-controls="v-pills-{{$category->id}}" aria-selected="true">{{$category->name}}</button>
                        @endforeach
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                @if($faq_categories && $faqs)
                <div class="tab-content" id="v-pills-tabContent">
                    @foreach($faq_categories as $key => $cat)

                    <div class="tab-pane fade {{ $key == 0?'show active':'' }} " id="v-pills-{{$cat->id}}" role="tabpanel" aria-labelledby="v-pills-{{$cat->id}}-tab" tabindex="0">
                        <div class="main-title">
                            <h2>{{$cat->name}}</h2>
                        </div>
                        <div id="accordion{{ $cat->id }}" class="myaccordion">
                            @foreach($cat->Faqs as $k => $faq)
                            <div class="card">
                                <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse{{$faq->id}}" aria-expanded="false" aria-controls="collapse{{$faq->id}}" id="heading1">
                                    <h2 class="mb-0">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div>{{ $faq->question }}</div>
                                            <i class="icon"></i>
                                        </div>
                                    </h2>
                                </div>
                                <div id="collapse{{$faq->id}}" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion{{ $cat->id }}">
                                    <div class="card-body">
                                        {{ $faq->answer }}
                                    </div>
                                </div>
                            </div>
                            @endforeach

                        </div>
                    </div>
                    @endforeach

                </div>
                @endif
            </div>
        </div>
    </div>
</section>
<section class="cta section-gap">
    <div class="container">
        <div class="cta-wrapper">
            <div class="row align-items-center">
                <div class="col-xl-5 col-lg-6 offset-lg-1 order-2 order-lg-1">
                    <div class="main-title">
                        <h2>It's your turn to play</h2>
                        <p>
                            Pay anything you want online and send money to your loved
                            ones without limits or restrictions.
                        </p>
                    </div>
                    <div class="row g-4 mb-4 mb-sm-5">
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>Fast transactions
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>Secure data
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>Virtual wallet
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>Permanent assistance
                                </h6>
                            </div>
                        </div>
                    </div>
                    <div class="btn-wrapper">
                        <a href="#"><img src="{{ asset('assets/front/images/icons/play-store.svg') }}" alt="Play Store" /></a>
                        <a href="#"><img src="{{ asset('assets/front/images/icons/app-store.svg') }}" alt="App Store" /></a>
                        <a href="#"><img src="{{ asset('assets/front/images/icons/app-gallery.svg') }}" alt="App Gallery" /></a>
                    </div>
                </div>
                <div class="col-lg-4 offset-xl-1 order-1 order-lg-2">
                    <div class="img-wrapper lh-0">
                        <img src="{{ asset('assets/front/images/cta.png') }}" alt="Images" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection