<script src="https://js.stripe.com/v3/"></script>
<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css"> -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<!-- <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script> -->

<style>
    @import url('https://fonts.googleapis.com/css2?family=josefin+Sans:wght@400;500;600;700&display=swap');

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Josefin Sans', sans-serif;
    }

    .container {
        min-height: 100vh;
        width: 100%;
        background: #41ACEF;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .card {
        width: 500px;
        height: 300px;
        color: #fff;
        cursor: pointer;
        perspective: 1000px;
    }

    .card-inner {
        width: 100%;
        height: 100%;
        position: relative;
        transition: transform 1s;
        transform-style: preserve-3d;
    }

    .front,
    .back {
        width: 100%;
        height: 100%;
        background-image: linear-gradient(45deg, #0045c7, #ff2c7d);
        position: absolute;
        top: 0;
        left: 0;
        padding: 20px 30px;
        border-radius: 15px;
        overflow: hidden;
        z-index: 1;
        backface-visibility: hidden;
    }

    .row {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .map-img {
        width: 100%;
        position: absolute;
        top: 0;
        left: 0;
        opacity: 0.3;
        z-index: -1;
    }

    .card-no {
        font-size: 35px;
        margin-top: 30px;
    }

    .card-holder {
        font-size: 12px;
        margin-top: 40px;
    }

    .name {
        font-size: 20px;

    }

    .bar {
        background: #222;
        margin-left: -30px;
        margin-right: -30px;
        height: 60px;
        margin-top: 10px;
    }

    .card-cvv {
        margin-top: 20px;
    }

    .card-cvv div {
        flex: 1;
    }

    .card-cvv img {
        width: 100%;
        display: block;
        line-height: 0;
    }

    .card-cvv p {
        background: #fff;
        color: #000;
        font-size: 22px;
        padding: 10px 20px;
    }

    .card-text {
        margin-top: 30px;
        font-size: 14px;
    }

    .signature {
        margin-top: 30px;
    }

    .back {
        transform: rotateY(180deg);
    }

    .card:hover .card-inner {
        transform: rotateY(-180deg);
    }

    .loader,
    .loader:after {
        border-radius: 50%;
        width: 10em;
        height: 10em;
    }

    .loader {
        margin: 60px auto;
        font-size: 10px;
        position: relative;
        text-indent: -9999em;
        border-top: 1.1em solid rgba(255, 255, 255, 0.2);
        border-right: 1.1em solid rgba(255, 255, 255, 0.2);
        border-bottom: 1.1em solid rgba(255, 255, 255, 0.2);
        border-left: 1.1em solid #ffffff;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
        -webkit-animation: load8 1.1s infinite linear;
        animation: load8 1.1s infinite linear;
    }

    @-webkit-keyframes load8 {
        0% {
            -webkit-transform: rotate(0deg);
            transform: rotate(0deg);
        }

        100% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

    @keyframes load8 {
        0% {
            -webkit-transform: rotate(0deg);
            transform: rotate(0deg);
        }

        100% {
            -webkit-transform: rotate(360deg);
            transform: rotate(360deg);
        }
    }

    #loadingDiv {
        position: absolute;
        padding-top: 150px;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: #41ACEF;
    }
</style>

<body>

    <div class="container">
        <input type="hidden" name="card_id" id="card_id" value="{{ $card->card_id }}">
        <input type="hidden" name="nonce_url" id="nonce_url" value="{{ route('create.nonce') }}">
        <div class="card">
            <div class="card-inner">
                <div class="front">
                    <img src="https://i.ibb.co/PYss3yv/map.png" class="map-img">
                    <div class="row">
                        <img src="https://i.ibb.co/G9pDnYJ/chip.png" width="60px">
                        <h3>{{ $card->brand }}</h3>
                    </div>



                    <div class="row card-no">
                        <p style="padding: 5px; width:350px" id="card-number"></p>
                    </div>
                    <div class="row card-holder">
                        <p>CARD HOLDER</p>
                        <p>VALID TILL</p>
                    </div>
                    <div class="row name">
                        <p>{{$user->first_name}} {{$user->last_name}}</p>
                        <p style="padding: 5px;width:65px;margin-top:10px" id="card-exp"></p>
                    </div>
                </div>
                <div class="back">
                    <img src="https://i.ibb.co/PYss3yv/map.png" class="map-img">
                    <div class="bar"></div>
                    <div class="row card-cvv">
                        <div>
                            <img src="https://i.ibb.co/S6JG8px/pattern.png">
                        </div>
                        <p style="padding: 13px; width:70px;" id="card-cvc"></p>
                    </div>
                    <div class="row card-text">
                        <p>this is a virtual card design using Stripe. You can use for shoping and online</p>
                    </div>
                    <div class="row signature">
                        <p>{{$user->first_name}} {{$user->last_name}}</p>
                        <h3>{{ $card->brand }}</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('assets/js/stripe/script.js') }}"></script>
    <script>
        $('body').append('<div style="" id="loadingDiv"><div class="loader">Loading...</div></div>');
        $(window).on('load', function() {
            setTimeout(removeLoader, 2000); //wait for page load PLUS two seconds.
        });

        function removeLoader() {
            $("#loadingDiv").fadeOut(500, function() {
                // fadeOut complete. Remove the loading div
                $("#loadingDiv").remove(); //makes page more lightweight 
            });
        }
    </script>
</body>