@extends('layouts.front')
@section('title', 'Virtual product')
@section('content')

<section class="banner-inner">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-sm-7 text-center text-sm-start">
                <div class="title">
                    <h2>{{ Utility::getcontents('banner_title','product-page') }}</h2>
                </div>
            </div>
            <div class="col-sm-5 d-none d-sm-block text-end">
                <div class="image-wrapper lh-0">
                    <img src="{{ Storage::url('content/'.Utility::getcontents('banner_image','product-page')) }}" alt="Image">
                </div>
            </div>
        </div>
    </div>
</section>
<section class="product-card-info">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7">
                <div class="main-title text-center mb-0">
                    <h2>{{ Utility::getcontents('product_info_title','product-page') }}</h2>
                    <p class="mb-0">{{ Utility::getcontents('product_info_description','product-page') }}</p>
                </div>
            </div>
        </div>
        <div class="section-gap">
            <div class="row">
                <div class="col-lg-7 col-xxl-5 offset-xxl-1">
                    <div class="product-card-info-tabs">
                        <img src="{{ asset('assets/front/images/blog-arrow.svg') }}" class="blog-arrow" alt="Arrow">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="{{ Utility::getcontents('tab_title_1','product-page') }}-tab" data-bs-toggle="tab" data-bs-target="#{{ Utility::getcontents('tab_title_1','product-page') }}-tab-pane" type="button" role="tab" aria-controls="{{ Utility::getcontents('tab_title_1','product-page') }}-tab-pane" aria-selected="true">{{ Utility::getcontents('tab_title_1','product-page') }}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="{{ Utility::getcontents('tab_title_2','product-page') }}-tab" data-bs-toggle="tab" data-bs-target="#{{ Utility::getcontents('tab_title_2','product-page') }}-tab-pane" type="button" role="tab" aria-controls="{{ Utility::getcontents('tab_title_2','product-page') }}-tab-pane" aria-selected="false">{{ Utility::getcontents('tab_title_2','product-page') }}</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="{{ Utility::getcontents('tab_title_3','product-page') }}-tab" data-bs-toggle="tab" data-bs-target="#{{ Utility::getcontents('tab_title_3','product-page') }}-tab-pane" type="button" role="tab" aria-controls="{{ Utility::getcontents('tab_title_3','product-page') }}-tab-pane" aria-selected="false">{{ Utility::getcontents('tab_title_3','product-page') }}</button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="{{ Utility::getcontents('tab_title_1','product-page') }}-tab-pane" role="tabpanel" aria-labelledby="{{ Utility::getcontents('tab_title_1','product-page') }}-tab" tabindex="0">
                                <div class="main-title">
                                    <h2>{{ Utility::getcontents('info_title_1','product-page') }}</h2>
                                    <p>{{ Utility::getcontents('info_description_1','product-page') }}</p>
                                </div>
                                <div>
                                    <div class="cta-card mb-3 mb-md-4">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_1_feature_1','product-page') }}
                                        </h6>
                                    </div>
                                    <div class="cta-card  mb-3 mb-md-4">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_1_feature_2','product-page') }}
                                        </h6>
                                    </div>
                                    <div class="cta-card">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_1_feature_3','product-page') }}
                                        </h6>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="{{ Utility::getcontents('tab_title_2','product-page') }}-tab-pane" role="tabpanel" aria-labelledby="{{ Utility::getcontents('tab_title_2','product-page') }}-tab" tabindex="0">
                                <div class="main-title">
                                    <h2>{{ Utility::getcontents('info_title_2','product-page') }}</h2>
                                    <p>{{ Utility::getcontents('info_description_2','product-page') }}</p>
                                </div>
                                <div>
                                    <div class="cta-card mb-3 mb-md-4">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_2_feature_1','product-page') }}
                                        </h6>
                                    </div>
                                    <div class="cta-card  mb-3 mb-md-4">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_2_feature_2','product-page') }}
                                        </h6>
                                    </div>
                                    <div class="cta-card">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_2_feature_3','product-page') }}
                                        </h6>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="{{ Utility::getcontents('tab_title_3','product-page') }}-tab-pane" role="tabpanel" aria-labelledby="{{ Utility::getcontents('tab_title_3','product-page') }}-tab" tabindex="0">
                                <div class="main-title">
                                    <h2>{{ Utility::getcontents('info_title_3','product-page') }}</h2>
                                    <p>{{ Utility::getcontents('info_description_3','product-page') }}</p>
                                </div>
                                <div>
                                    <div class="cta-card mb-3 mb-md-4">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_3_feature_1','product-page') }}
                                        </h6>
                                    </div>
                                    <div class="cta-card  mb-3 mb-md-4">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_3_feature_2','product-page') }}
                                        </h6>
                                    </div>
                                    <div class="cta-card">
                                        <h6>
                                            <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('tab_3_feature_3','product-page') }}
                                        </h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 offset-lg-1 d-none d-lg-block">
                    <div class="text-end">
                        <img src="{{ Storage::url('content/'.Utility::getcontents('product_info_image','product-page')) }}" alt="Image">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="feature-section">
    <div class="container">
        <div class="feature-wrapper">
            <div class="feature">
                <div class="row align-items-center">
                    <div class="col-lg-5">
                        <div class="img-wrapper text-center">
                            <img src="{{ Storage::url('content/'.Utility::getcontents('card_feature_image','product-page')) }}" alt="Image" />
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="content-wrapper">
                            <div class="main-title">
                                <h2>{{ Utility::getcontents('card_feature_title','product-page') }}</h2>
                                <p>{{ Utility::getcontents('card_feature_description','product-page') }}</p>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="feature-card">
                                        <div class="icon">
                                            <img src="{{ Storage::url('content/'.Utility::getcontents('feature_icon_1','product-page')) }}" alt="Icon" />
                                        </div>
                                        <h6>{{ Utility::getcontents('feature_title_1','product-page') }}</h6>
                                        <p>
                                            {{ Utility::getcontents('feature_description_1','product-page') }}
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="feature-card">
                                        <div class="icon">
                                            <img src="{{ Storage::url('content/'.Utility::getcontents('feature_icon_2','product-page')) }}" alt="Icon" />
                                        </div>
                                        <h6>{{ Utility::getcontents('feature_title_2','product-page') }}</h6>
                                        <p>
                                            {{ Utility::getcontents('feature_description_2','product-page') }}
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="feature-card">
                                        <div class="icon">
                                            <img src="{{ Storage::url('content/'.Utility::getcontents('feature_icon_3','product-page')) }}" alt="Icon" />
                                        </div>
                                        <h6>{{ Utility::getcontents('feature_title_3','product-page') }}</h6>
                                        <p>
                                            {{ Utility::getcontents('feature_description_3','product-page') }}
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="feature-card">
                                        <div class="icon">
                                            <img src="{{ Storage::url('content/'.Utility::getcontents('feature_icon_4','product-page')) }}" alt="Icon" />
                                        </div>
                                        <h6>{{ Utility::getcontents('feature_title_4','product-page') }}</h6>
                                        <p>{{ Utility::getcontents('feature_description_4','product-page') }}</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="feature-card">
                                        <div class="icon">
                                            <img src="{{ Storage::url('content/'.Utility::getcontents('feature_icon_5','product-page')) }}" alt="Icon" />
                                        </div>
                                        <h6>{{ Utility::getcontents('feature_title_5','product-page') }}</h6>
                                        <p>{{ Utility::getcontents('feature_description_5','product-page') }}</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="feature-card mb-0">
                                        <div class="icon">
                                            <img src="{{ Storage::url('content/'.Utility::getcontents('feature_icon_6','product-page')) }}" alt="Icon" />
                                        </div>
                                        <h6>{{ Utility::getcontents('feature_title_6','product-page') }}</h6>
                                        <p>{{ Utility::getcontents('feature_description_6','product-page') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="feature-info">
                <div class="row align-items-center">
                    <div class="col-lg-5">
                        <div class="main-title">
                            <h2>{{ Utility::getcontents('extra_feature_title','product-page') }}</h2>
                            <p>
                                {{ Utility::getcontents('extra_feature_description','product-page') }}
                            </p>
                        </div>
                        <div class="text-start mb-4 mb-sm-5 md-lg-0">
                            <div class="cta-card mb-3 ">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('extra_feature_1','product-page') }}
                                </h6>
                            </div>
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('extra_feature_2','product-page') }}
                                </h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="img-wrapper text-center text-lg-end lh-0">
                            <img src="{{ Storage::url('content/'.Utility::getcontents('extra_feature_image','product-page')) }}" alt="Image" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="our-product mb-4 pb-4 mb-lg-5 pb-lg-5">
    <div class="container">
        <div class="main-title text-center">
            <h2>Choose your card</h2>
            <p>
                Choose one of our cards, depending on what suits you best.
            </p>
        </div>
        <div class="row g-4 justify-content-center">
            <div class="col-lg-4">
                <div class="product-card">
                    <div class="img-wrapper">
                        <img src="{{ asset('assets/front/images/virtual-card.svg') }}" alt="Card" />
                    </div>
                    <h2>Virtual card</h2>
                    <p>A virtual card with multiple possibilities</p>
                    <a class="my-button" href="#">Start</a>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="product-card">
                    <div class="img-wrapper">
                        <img src="{{ asset('assets/front/images/physical-card.svg') }}" alt="Card" />
                    </div>
                    <h2>Physical card</h2>
                    <p>A physical card to do even more</p>
                    <a class="my-button" href="#">Start</a>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="cta">
    <div class="container">
        <div class="cta-wrapper">
            <div class="row align-items-center">
                <div class="col-xl-5 col-lg-6 offset-lg-1 order-2 order-lg-1">
                    <div class="main-title">
                        <h2>{{ Utility::getcontents('app_feature_title','home-page') }}</h2>
                        <p>
                            {{ Utility::getcontents('app_feature_description','home-page') }}
                        </p>
                    </div>
                    <div class="row g-4 mb-4 mb-sm-5">
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_1','home-page') }}
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_2','home-page') }}
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_3','home-page') }}
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="{{ asset('assets/front/images/icons/tick.svg') }}" alt="Tick" /></span>{{ Utility::getcontents('app_feature_4','home-page') }}
                                </h6>
                            </div>
                        </div>
                    </div>
                    <div class="btn-wrapper">
                        <a href="{{ Utility::getsettings('play_store_link') }}"><img src="{{ asset('assets/front/images/icons/play-store.svg') }}" alt="Play Store"></a>
                        <a href="{{ Utility::getsettings('app_store_link') }}"><img src="{{ asset('assets/front/images/icons/app-store.svg') }}" alt="App Store"></a>
                        <a href="{{ Utility::getsettings('app_gallery_link') }}"><img src="{{ asset('assets/front/images/icons/app-gallery.svg') }}" alt="App Gallery"></a>
                    </div>
                </div>
                <div class="col-lg-4 offset-xl-1 order-1 order-lg-2">
                    <div class="img-wrapper lh-0">
                        <img src="{{ Storage::url('content/'.Utility::getcontents('app_feature_image','home-page')) }}" alt="Images" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="need-help section-gap">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-lg-6 col-xl-6">
                <div class="main-title">
                    <h2>{{ Utility::getcontents('help_title','home-page') }}</h2>
                    <p>{{ Utility::getcontents('help_description','home-page') }}</p>
                </div>
                <ul class="contact">
                    <li>
                        <div class="icon"><img src="{{ asset('assets/front/images/icons/location.svg') }}" alt="Map"></div>
                        <div class="content">
                            <p>{{ Utility::getsettings('address') }}</p>
                            <h6>Headquarters</h6>
                        </div>
                    </li>
                    <li>
                        <div class="icon"><img src="{{ asset('assets/front/images/icons/email.svg') }}" alt="Map"></div>
                        <div class="content">
                            <p> <a href="mailto: {{ Utility::getsettings('support_email') }}">{{ Utility::getsettings('support_email') }}</a> </p>
                            <h6>Support Email</h6>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="col-lg-6 col-xxl-5">
                <div id="accordion" class="myaccordion">
                    <div class="card">
                        <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false" aria-controls="collapse1" id="heading1">
                            <h2 class="mb-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>How to get a virtual card?</div>
                                    <i class="icon"></i>
                                </div>
                            </h2>
                        </div>
                        <div id="collapse1" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion">
                            <div class="card-body">
                                If you have ordered/purchased a product or subscribed to a service on a 3-days trial
                                basis for €2.00, we suggest that you check your latest bank statement to see the
                                transaction - any transaction from us is managed with 3D Secure technology.
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false" aria-controls="collapse2" id="heading1">
                            <h2 class="mb-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>How to recharge my PaySen account?</div>
                                    <i class="icon"></i>
                                </div>
                            </h2>
                        </div>
                        <div id="collapse2" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion">
                            <div class="card-body">
                                If you have ordered/purchased a product or subscribed to a service on a 3-days trial
                                basis for €2.00, we suggest that you check your latest bank statement to see the
                                transaction - any transaction from us is managed with 3D Secure technology.
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapse3" id="heading1">
                            <h2 class="mb-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>How to verify my PaySen account?</div>
                                    <i class="icon"></i>
                                </div>
                            </h2>
                        </div>
                        <div id="collapse3" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion">
                            <div class="card-body">
                                If you have ordered/purchased a product or subscribed to a service on a 3-days trial
                                basis for €2.00, we suggest that you check your latest bank statement to see the
                                transaction - any transaction from us is managed with 3D Secure technology.
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapse4" id="heading1">
                            <h2 class="mb-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>How to withdraw money from my PaySen account?</div>
                                    <i class="icon"></i>
                                </div>
                            </h2>
                        </div>
                        <div id="collapse4" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion">
                            <div class="card-body">
                                If you have ordered/purchased a product or subscribed to a service on a 3-days trial
                                basis for €2.00, we suggest that you check your latest bank statement to see the
                                transaction - any transaction from us is managed with 3D Secure technology.
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="false" aria-controls="collapse5" id="heading1">
                            <h2 class="mb-0">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div>How to recharge my PaySen virtual card?</div>
                                    <i class="icon"></i>
                                </div>
                            </h2>
                        </div>
                        <div id="collapse5" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion">
                            <div class="card-body">
                                If you have ordered/purchased a product or subscribed to a service on a 3-days trial
                                basis for €2.00, we suggest that you check your latest bank statement to see the
                                transaction - any transaction from us is managed with 3D Secure technology.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection