@php
$currantLang = session()->get('locale');
$languages = Utility::languages();
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', session()->get('locale')) }}">

<head>
    <!--------------- Meta tags start --------------->
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0,user-scalable=0" />
    <meta name="format-detection" content="telephone=no" />
    <meta name="theme-color" content="#000" />
    <meta name="referrer" content="origin" />
    <!--------------- META TAG START HERE --------------->
    <meta charset="UTF-8" />
    <meta name="title" content="Paysen" />
    <meta name="format-detection" content="telephone=no" />
    <meta name="theme-color" content="#de7243" />
    <meta name="description" content="Content" />

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website" />
    <meta property="og:url" content="url" />
    <meta property="og:title" content="Paysen" />
    <meta property="og:description" content="Content" />
    <meta property="og:image" content="url/assets/images/thumbnail.jpg" />

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image" />
    <meta property="twitter:url" content="url" />
    <meta property="twitter:title" content="Paysen" />
    <meta property="twitter:description" content="Content" />
    <meta property="twitter:image" content="url/assets/images/thumbnail.jpg" />
    <!--------------- META TAG END'S HERE --------------->

    <!-- Page title -->
    <title>@yield('title') | {{ Utility::getsettings('app_name') }}</title>
    <!-- Favicon -->
    <link href="{{ asset('assets/front/images/icon/favicon.png') }}" rel="shortcut icon" type="image/x-icon" />
    <!-- Font Link -->
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet" />
    <!-- CSS Links -->
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.9.0/css/all.css?display=swap" integrity="sha384-vlOMx0hKjUCl4WzuhIhSNZSm2yQCaf0mOU1hEDK/iztH3gU4v5NMmJln9273A6Jz" crossorigin="anonymous" />
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/front/vendors/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/front/vendors/css/swiper.css') }}" />
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/front/css/app.css') }}" />
    @stack('css')
</head>

<body class="home-page">
    <header class="fixed-top">
        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <a class="navbar-brand" href="#"><img src="{{ Storage::url(Utility::getsettings('app_small_logo')) }}" alt="Not Found" /></a>
                <div class="d-flex align-items-center d-lg-none">
                    <button class="header-button">Open Account</button>
                    <button class="navbar-toggler ms-2" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                        <svg width="28" height="28" viewBox="0 0 100 100">
                            <path class="line line1" d="M 20,29.000046 H 80.000231 C 80.000231,29.000046 94.498839,28.817352 94.532987,66.711331 94.543142,77.980673 90.966081,81.670246 85.259173,81.668997 79.552261,81.667751 75.000211,74.999942 75.000211,74.999942 L 25.000021,25.000058" />
                            <path class="line line2" d="M 20,50 H 80" />
                            <path class="line line3" d="M 20,70.999954 H 80.000231 C 80.000231,70.999954 94.498839,71.182648 94.532987,33.288669 94.543142,22.019327 90.966081,18.329754 85.259173,18.331003 79.552261,18.332249 75.000211,25.000058 75.000211,25.000058 L 25.000021,74.999942" />
                        </svg>
                    </button>
                    <div id="teams-dropdown-menu" onclick="toggleActive(this)">
                        <ul>
                            <li onclick="setTeam(this),update_session_value('EN')" class="has-text-weight-semibold">
                                EN
                            </li>
                            <li onclick="setTeam(this),update_session_value('IT')">IT</li>
                            <li onclick="setTeam(this),update_session_value('FR')">FR</li>
                            <li onclick="setTeam(this),update_session_value('SP')">SP</li>
                            <li onclick="setTeam(this),update_session_value('GR')">GR</li>
                        </ul>
                        <div class="lang-drop-inner">
                            <span class="is-size-6 has-text-weight-semibold flag-text" id="current-team">
                                EN
                            </span>
                            <span class="icon is-pulled-right"></span>
                        </div>
                    </div>
                </div>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item active">
                            <a class="nav-link" href="{{ route('front') }}">Home</a>
                        </li>
                        
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                Product
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{ route('virtual-product') }}">Virtual product</a></li>
                                <!-- <li><a class="dropdown-item" href="{{ route('physical-product') }}">Physical product</a></li> -->
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('pricing') }}">Pricing</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('support') }}">Support and Contact</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">About</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('blogs') }}">Blog</a>
                        </li>
                    </ul>
                    <button class="header-button d-none d-lg-block">
                        Open Account
                    </button>
                    <div id="teams-dropdown-menu" class="d-none d-lg-block" onclick="toggleActive(this)">
                        <ul>
                            @foreach ($languages as $language)
                            <li class="has-text-weight-semibold">
                                <a class=" @if ($language == $currantLang) text-danger @endif" href="{{ route('change.lng', $language) }}">{{ Str::upper($language) }}</a>
                            </li>

                            @endforeach

                        </ul>
                        <div class="lang-drop-inner">
                            <span class="is-size-6 has-text-weight-semibold flag-text" id="current-team">
                                EN
                            </span>
                            <span class="icon is-pulled-right"></span>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
    </header>
    <div class="main-wrapper {{ request()->is('blog-details/*') ? 'blog-details' : '' }}">
        @yield('content')
    </div>
    <footer>
        <div class="container">
            <div class="main-footer">
                <div class="row">
                    <div class="col-md-3">
                        <div class="footer-links">
                            <h2 class="footer-title mob" data-bs-target="#about" data-bs-toggle="collapse">
                                About
                                <div class="footer-toggler"></div>
                            </h2>
                            <ul id="about" class="collapse foot-mob" data-parent="#foot-accordion">
                                <li><a href="{{ route('front') }}">Home</a></li>
                                <li><a href="{{ route('pricing') }}">Pricing</a></li>
                                <li><a href="{{ route('support') }}">Support and contact</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="footer-links">
                            <h2 class="footer-title mob" data-bs-target="#social" data-bs-toggle="collapse">
                                Social networks
                                <div class="footer-toggler"></div>
                            </h2>
                            <ul id="social" class="collapse foot-mob" data-parent="#foot-accordion">
                                <li><a href="#"> <img src="{{ asset('assets/front/images/icons/facebook.svg') }}" alt="Icon"> Facebook</a></li>
                                <li><a href="#"> <img src="{{ asset('assets/front/images/icons/twitter.svg') }}" alt="Icon"> Twitter</a></li>
                                <li><a href="#"> <img src="{{ asset('assets/front/images/icons/linkedin.svg') }}" alt="Icon"> LinkedIn</a></li>
                                <li><a href="#"> <img src="{{ asset('assets/front/images/icons/instagram.svg') }}" alt="Icon"> Instagram</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="footer-links">
                            <h2 class="footer-title mob" data-bs-target="#product" data-bs-toggle="collapse">
                                Our products
                                <div class="footer-toggler"></div>
                            </h2>
                            <ul id="product" class="collapse foot-mob" data-parent="#foot-accordion">
                                <li><a href="{{ route('virtual-product') }}">Virtual product</a></li>
                                <li><a href="{{ route('virtual-product') }}">Physical product</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="footer-links">
                            <h2 class="footer-title mob" data-bs-target="#resources" data-bs-toggle="collapse">
                                Resources
                                <div class="footer-toggler"></div>
                            </h2>
                            <ul id="resources" class="collapse foot-mob" data-parent="#foot-accordion">
                                <li><a href="{{ route('blogs') }}">Blog</a></li>
                                <li><a href="{{ route('privacy-policy') }}">Legal notice</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="app-area">
                <div class="logo lh-0">
                    <img src="{{ asset('assets/front/images/logo.svg') }}" alt="Logo">
                </div>
                <div class="download">
                    <h6>Download Our App</h6>
                    <div class="btn-wrapper">
                        <a href="#"><img src="{{ asset('assets/front/images/icons/play-store.png') }}" alt="Button" /></a>
                        <a href="#"><img src="{{ asset('assets/front/images/icons/app-store.png') }}" alt="Button" /></a>
                        <a href="#"><img src="{{ asset('assets/front/images/icons/app-gallery.png') }}" alt="Button" /></a>
                    </div>
                </div>
            </div>
            <div class="sub-footer">
                <p>Copyright © 2023 PaySen. All rights reserved.</p>
                <div class="back-top" id="back-to-top">
                    Back to top
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 22.75C6.07 22.75 1.25 17.93 1.25 12C1.25 6.07 6.07 1.25 12 1.25C17.93 1.25 22.75 6.07 22.75 12C22.75 17.93 17.93 22.75 12 22.75ZM12 2.75C6.9 2.75 2.75 6.9 2.75 12C2.75 17.1 6.9 21.25 12 21.25C17.1 21.25 21.25 17.1 21.25 12C21.25 6.9 17.1 2.75 12 2.75Z" fill="white" />
                        <path d="M12 16.25C11.59 16.25 11.25 15.91 11.25 15.5V9.5C11.25 9.09 11.59 8.75 12 8.75C12.41 8.75 12.75 9.09 12.75 9.5V15.5C12.75 15.91 12.41 16.25 12 16.25Z" fill="white" />
                        <path d="M14.9999 12.2499C14.8099 12.2499 14.6199 12.1799 14.4699 12.0299L11.9999 9.55994L9.52994 12.0299C9.23994 12.3199 8.75994 12.3199 8.46994 12.0299C8.17994 11.7399 8.17994 11.2599 8.46994 10.9699L11.4699 7.96994C11.7599 7.67994 12.2399 7.67994 12.5299 7.96994L15.5299 10.9699C15.8199 11.2599 15.8199 11.7399 15.5299 12.0299C15.3799 12.1799 15.1899 12.2499 14.9999 12.2499Z" fill="white" />
                    </svg>
                </div>
            </div>
        </div>
    </footer>
    <script src="{{ asset('assets/front/vendors/jquery/jquery-3.7.0.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="{{ asset('assets/front/vendors/jquery/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/app.js') }}"></script>
</body>

</html>