@extends('layouts.admin')
@section('title', 'Products')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Create Product</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="{{ route('modules.index') }}">Products</a></div>
                <div class="breadcrumb-item">Create Product</div>
            </div>
        </div>

        {!! Form::open(['route'=> 'products.store', 'method' => 'POST', 'enctype' => 'multipart/form-data' ]) !!}
        <div class="col-md-12 m-auto">
            <div class="card p-4">
                <div class="card-header">{{ __('Create New Product') }} </div>
                <div class="card-body row">

                    <div class="form-group col-md-6">
                        {{ Form::label('name', __('Name')) }}
                        {{ Form::text('name', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Product name']) }}
                    </div>
                    <div class="form-group col-md-6">
                        {{ Form::label('equipment', __('Equipment')) }}
                        {!! Form::file('equipment', ['class' => 'form-control']) !!}
                    </div>

                    <div class="form-group col-md-12">


                        <div class="col-md-12 mt-auto p-3">

                            <table border="2" class="text-center w-100" id="repeater-table">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Company</th>
                                        <th>Specification</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    <input type="hidden" name="product_company_count" id="product_company_count" value="1">

                                    <tr>
                                        <td>1</td> <!-- First Installment No. -->
                                        <td style="width: 200px;"><input type="text" class="text-center form-control" name="company[]" required></td>
                                        <td><textarea class="text-center form-control specification" name="specification[]"></textarea></td>
                                        <td><button type="button" class="btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td> <!-- First row has no remove button -->
                                    </tr>

                                </tbody>
                            </table>

                        </div>
                    </div>

                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                    {{ Form::submit(__('Submit'), ['class' => 'btn btn-primary']) }}

                    <a class="btn btn-secondary" href="{{ route('products.index') }}"> {{ __('Back') }}</a>

                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </section>
</div>
</div>
@endsection
@push('javascript')
<script>
    $(document).ready(function() {
        var rowCount = $('#product_company_count').val(); // Initialize row count for Installment No.
        // Initialize row count for Installment No.

        // Function to add a new row
        $('#add-row').click(function() {

            rowCount++;
            var newRow = `<tr>
            <td>${rowCount}</td> <!-- Auto increment Installment No -->
            <td><input type="text" class="text-center form-control" name="company[]" ></td>
            <td><textarea class="text-center form-control specification" name="specification[]" ></textarea></td>

                                        <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
                                    </tr>`;
            $('#repeater-table tbody').append(newRow);

            $('.specification').last().summernote({
                height: 200, // set editor height
                toolbar: [
                    ['font', ['bold', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']],
                ]
            });
        });

        // Function to remove a row and update Installment Nos
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            updateInstallmentNumbers();
        });

        // Function to update Installment Nos after a row is removed
        function updateInstallmentNumbers() {
            rowCount = 0; // Reset row count
            $('#repeater-table tbody tr').each(function() {
                rowCount++;
                $(this).find('td:first').text(rowCount); // Update Installment No text
            });
        }
        $('.specification').summernote({
            height: 200, // set editor height
            toolbar: [
                ['font', ['bold', 'underline', 'clear']],
                ['para', ['ul', 'ol', 'paragraph']],
            ]
        });
    });
</script>
@endpush