@extends('layouts.admin')
@section('title')
{{ __('Products') }}
@endsection

@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Products</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item">Products</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row col-md-6 mx-auto">

                <div class="col-md-6 m-auto">
                    {!! Form::select('user_select', $users, null, ['class' => 'form-control form-control-sm w-auto d-inline custom_padding form-control-light select2', 'required', 'placeholder' => 'Select Client']) !!}
                </div>
                <div class="col-md-6 m-auto">
                    <button class="btn btn-primary btn-lg ml-2" id="filter">{{ __('Filter') }}</button>
                </div>
            </div>
            <div class="row" id="product_table" style="display:none;">
                <div class=" col-12">
                    <div class="table-responsive py-4">
                        {{ $dataTable->table(['width' => '100%']) }}
                    </div>
                </div>
            </div>
    </section>
</div>
</div>



@endsection

@push('css')
@include('layouts.includes.datatable_css')
@endpush
@push('javascript')

@include('layouts.includes.datatable_js')



<script>
    $(document).ready(function() {
        window.LaravelDataTables = null;

        function getData() {
            if (window.LaravelDataTables == null) {
                window.LaravelDataTables = $("#products-table").DataTable({
                    "serverSide": true,
                    "processing": true,
                    "ajax": {
                        "url": "{{ route('products.index') }}",
                        "type": "GET",
                        "data": function(data) {
                            for (var i = 0, len = data.columns.length; i < len; i++) {
                                if (!data.columns[i].search.value) delete data.columns[i].search;
                                if (data.columns[i].searchable === true) delete data.columns[i]
                                    .searchable;
                                if (data.columns[i].orderable === true) delete data.columns[i]
                                    .orderable;
                                if (data.columns[i].data === data.columns[i].name) delete data
                                    .columns[i]
                                    .name;
                            }
                            delete data.search.regex;
                            data.user_id = $('select[name="user_select"]').val();
                        }
                    },
                    "columns": [{
                        "name": "id",
                        "data": "DT_RowIndex",
                        "title": "No",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "name",
                        "name": "name",
                        "title": "Name",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "equipment",
                        "name": "equipment",
                        "title": "Equipment",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "company",
                        "name": "company",
                        "title": "Company",
                        "orderable": false,
                        "searchable": false
                    }, {
                        "data": "action",
                        "name": "action",
                        "title": "Action",
                        "orderable": false,
                        "searchable": false,
                        "width": 120,
                        "className": "text-center"
                    }],
                    "order": [
                        [1, "desc"]
                    ],
                    "language": {
                        "paginate": {
                            "next": "<i class=\"fas fa-angle-right\"><\/i>",
                            "previous": "<i class=\"fas fa-angle-left\"><\/i>"
                        }
                    },
                    "dom": "\n                                <'row'<'col-sm-12'><'col-sm-9 text-left'B><'col-sm-3'f>>\n                                <'row'<'col-sm-12'tr>>\n                                <'row mt-3'<'col-sm-5'i><'col-sm-7'p>>\n                                ",
                    "buttons": [{
                        "extend": "create",
                        "className": "btn btn-primary btn-sm no-corner add_product",
                        "action": function(e, dt, node, config) {
                            window.location = "{{ url('product-create') }}/" + $('select[name="user_select"]').val();
                        }
                    }, {
                        "extend": "export",
                        "className": "btn btn-primary btn-sm no-corner"
                    }, {
                        "extend": "print",
                        "className": "btn btn-primary btn-sm no-corner"
                    }, {
                        "extend": "reset",
                        "className": "btn btn-primary btn-sm no-corner"
                    }, {
                        "extend": "reload",
                        "className": "btn btn-primary btn-sm no-corner"
                    }, {
                        "extend": "pageLength",
                        "className": "btn btn-danger btn-sm no-corner"
                    }],
                    "scrollX": true
                });
            } else {
                window.LaravelDataTables.ajax.reload();
            }
        }

        $('#filter').click(function() {
            var user_id = $('select[name="user_select"]').val();
            if (user_id != '') {
                $('#product_table').show();
                getData();
                // window.LaravelDataTables["products-table"].draw();
            } else {
                $('#product_table').hide();
            }
        });
    });
</script>
@endpush