@extends('layouts.admin')
@section('title', $t)
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>{{ $t }}</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item"><a href="{{ route('settings') }}">{{ __('Settings') }}</a></div>
                <div class="breadcrumb-item">{{ $t }}</div>
            </div>
        </div>
        <div class="section-body">
            <h2 class="section-title">All About {{ $t }}</h2>
            <p class="section-lead">
                You can adjust all {{ $t }} here
            </p>
            <div id="output-status"></div>
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h4>Jump To</h4>
                        </div>
                        <div class="card-body">
                            <ul class="nav nav-pills flex-column">
                                <li class="nav-item"><a href="{{ route('setting', 'app-setting') }}" class="nav-link ">App Setting</a></li>
                                <li class="nav-item"><a href="{{ route('setting', 'general-setting') }}" class="nav-link active">General</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <form id="setting-form" action="{{ route('settings/auth-settings/update') }}" enctype="multipart/form-data" method="POST">
                        @csrf
                        <div class="card" id="settings-card">
                            <div class="card-header">
                                <h4> {{ $t }}</h4>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="name">{{ __('Headquarters Address') }}</label>
                                    <textarea name="address" class="form-control" required placeholder="{{ __('Address') }}">{{ Utility::getsettings('address') }}</textarea>

                                </div>
                                <div class="form-group">
                                    <label for="name">{{ __('Support Email') }}</label>
                                    <input type="email" name="support_email" class="form-control" value="{{ Utility::getsettings('support_email') }}" required placeholder="{{ __('Support Email') }}">
                                </div>
                                <h5 class="text-muted"> {{ __('App link') }} </h5>
                                <div class="form-group">
                                    <label for="name">{{ __('Play store link') }}</label>
                                    <input type="url" name="play_store_link" class="form-control" value="{{ Utility::getsettings('play_store_link') }}" required placeholder="{{ __('Play store link') }}">
                                </div>
                                <div class="form-group">
                                    <label for="name">{{ __('App store link') }}</label>
                                    <input type="url" name="app_store_link" class="form-control" value="{{ Utility::getsettings('app_store_link') }}" required placeholder="{{ __('App store link') }}">
                                </div>
                                <div class="form-group">
                                    <label for="name">{{ __('App gallery link') }}</label>
                                    <input type="url" name="app_gallery_link" class="form-control" value="{{ Utility::getsettings('app_gallery_link') }}" required placeholder="{{ __('App gallery link') }}">
                                </div>
                                <h5 class="text-muted"> {{ __('Social Accounts') }} </h5>
                                <div class="form-group">
                                    <label for="name">{{ __('Facebbok') }}</label>
                                    <input type="url" name="facebbok_link" class="form-control" value="{{ Utility::getsettings('facebbok_link') }}" required placeholder="{{ __('Facebbok') }}">
                                </div>
                                <div class="form-group">
                                    <label for="name">{{ __('Twitter') }}</label>
                                    <input type="url" name="twitter_link" class="form-control" value="{{ Utility::getsettings('twitter_link') }}" required placeholder="{{ __('Twitter') }}">
                                </div>
                                <div class="form-group">
                                    <label for="name">{{ __('Linkedln') }}</label>
                                    <input type="url" name="lindedln_link" class="form-control" value="{{ Utility::getsettings('lindedln_link') }}" required placeholder="{{ __('Linkedln') }}">
                                </div>
                                <div class="form-group">
                                    <label for="name">{{ __('Instagram') }}</label>
                                    <input type="url" name="instagram_link" class="form-control" value="{{ Utility::getsettings('instagram_link') }}" required placeholder="{{ __('Instagram') }}">
                                </div>
                                <h5 class="text-muted"> {{ __('Currency  Date & time') }} </h5>
                                <div class="form-group">
                                    <label for="date_format">{{ __('Currency') }}</label>
                                    <select name="currency" class="form-control">
                                        <option value="USD" {{ Utility::getsettings('currency') == 'USD' ? 'selected' : '' }}>{{ __('USD') }}</option>
                                        <option value="INR" {{ Utility::getsettings('currency') == 'INR' ? 'selected' : '' }}>{{ __('INR') }}</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="date_format">{{ __('Currency Symbol') }}</label>
                                    <select name="currency_symbol" class="form-control">
                                        <option value="$" {{ Utility::getsettings('currency_symbol') == '$' ? 'selected' : '' }}> $ </option>
                                        <option value="₹" {{ Utility::getsettings('currency_symbol') == '₹' ? 'selected' : '' }}> ₹ </option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="date_format">{{ __('Date Format') }}</label>
                                    <select name="date_format" class="form-control">
                                        <option value="M j, Y" {{ Utility::getsettings('date_format') == 'M j, Y' ? 'selected' : '' }}>{{ __('Jan 1, 2020') }}</option>
                                        <option value="d-M-y" {{ Utility::getsettings('date_format') == 'd-M-y' ? 'selected' : '' }}>{{ __('01-Jan-20') }}</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="time_format">{{ __('Time Format') }}</label>
                                    <select name="time_format" class="form-control">
                                        <option value="g:i A" {{ Utility::getsettings('time_format') == 'g:i A' ? 'selected' : '' }}>{{ __('hh:mm AM/PM') }}</option>
                                        <option value="H:i:s" {{ Utility::getsettings('time_format') == 'H:i:s' ? 'selected' : '' }}>{{ __('HH:mm:ss') }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="card-footer bg-whitesmoke text-md-right">
                                <button class="btn btn-primary" type="submit" id="save-btn">{{ __('Save Changes') }}</button>
                                <a href="{{ route('settings') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection