@extends('layouts.admin')
@section('title', 'Basic Deatils')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Basic Deatils</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="{{ route('users.index') }}">Clients</a></div>
                <div class="breadcrumb-item">Basic Deatils</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                @if($id != '')
                <div class="col-md-8 m-auto">
                    <div class="card p-4">
                        {!! Form::model($user, ['route' => ['users.update', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']) !!}

                        <div class="row">
                            <div class="form-group col-md-6">
                                {{ Form::label('name', __('Name')) }}
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    {!! Form::text('name', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Name']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6 ">
                                {{ Form::label('address', __('Address')) }}
                                <div class="input-group ">
                                    {!! Form::textarea('address', null, ['class' => 'form-control', 'cols' => '30', 'rows' => '5', 'required', 'placeholder' => 'Enter Address']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('refrence', __('Refrence')) }}
                                <div class="input-group ">
                                    {!! Form::text('refrence', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Refrence']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('quote_number', __('Quote Number')) }}
                                <div class="input-group ">
                                    {!! Form::text('quote_number', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Quote Number ']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('kw', __('KW')) }}
                                <div class="input-group ">
                                    {!! Form::text('kw', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter KW']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('date', __('Date')) }}
                                <div class="input-group ">
                                    {!! Form::date('date', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Date ']) !!}
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                {{ Form::label('welcome_message', __('Welcome Message')) }}

                                {!! Form::textarea('welcome_message', null, ['class' => 'form-control', 'required', 'placeholder' => 'Enter Welcome Message', 'id' => 'welcome_message']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                {{ Form::label('mw', __('MW of Installation')) }}
                                <div class="input-group ">
                                    {!! Form::text('mw', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter MW of Installation']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-4">
                                {{ Form::label('customers', __('Satisfied Customers')) }}
                                <div class="input-group ">
                                    {!! Form::text('customers', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Satisfied Customers']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-4">
                                {{ Form::label('category', __('Approval Category')) }}
                                <div class="input-group ">
                                    {!! Form::text('category', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Approval Category']) !!}
                                </div>
                            </div>


                        </div>


                        <div class="btn-flt">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">{{__('Cancel')}}</a>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
                @else

                <div class="col-md-6 m-auto">
                    <div class="form-group col-md-6">
                        {{ Form::label('user_select', __('Select Client')) }}
                        <div class="input-group">
                            {!! Form::select('user_select', $users, null, ['class' => 'form-control select2', 'required', 'placeholder' => 'Select Client']) !!}
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <button type="button " id="submit-client" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                @endif
            </div>
        </div>
    </section>
</div>

@endsection
@push('javascript')

<script>
    $(document).ready(function() {
        $('#welcome_message').summernote({
            height: 200, // set editor height
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']]
            ]
        });

        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "{{ url('basic-details') }}/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });
    });
</script>
@endpush