@extends('layouts.admin')
@section('title', 'Chart Details')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Chart Detaills </h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="{{ route('users.index') }}">Clients</a></div>
                <div class="breadcrumb-item">Chart Detaills</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                @if($id != '')
                <div class="col-md-12 m-auto">
                    <div class="card p-4">
                        <div card="card-header ">
                            <h6 class="text-center p-3">Chart Detaills</h6>
                            @if(count($chartDetails) > 0 && $chartDetails[0]->kw == $user->kw)
                            <a href="{{ route('regenerate-chart', $user->id) }}" class="btn btn-primary float-right">Regenerate Chart Detaills</a>
                            @endif
                        </div>
                        {!! Form::model($chartDetails, ['route' => ['update-chart-details', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']) !!}

                        <div class="row">
                            <div class="form-group col-md-12">
                                <div class="col-md-12 mt-auto p-3">

                                    @if(count($chartDetails) > 0 && $chartDetails[0]->kw == $user->kw)

                                    <div style="width: 75%; margin: auto;" class="p-3">
                                        <canvas id="netReturnChart"></canvas>
                                    </div>

                                    @endif


                                    <table border="2" class="text-center w-100" id="repeater-table">
                                        <thead>
                                            <tr>
                                                <th>KW</th>
                                                <th colspan="9" class="text-center">
                                                    {!! Form::number('kw', $user->kw , ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW','id' => 'kw']) !!}
                                                </th>
                                            </tr>
                                            <tr>
                                                <td colspan="10"></td>
                                            </tr>
                                            <tr>
                                                <th>No</th>
                                                <th>PER DAY*365 DAY</th>
                                                <th>%</th>
                                                <th>Unit</th>
                                                <th>Net Unit</th>
                                                <th>Unit Cost</th>
                                                <th>Gross Return</th>
                                                @if(count($chartDetails) > 0 && $chartDetails[0]->kw == $user->kw)
                                                <th>
                                                    Bank Charge
                                                    {!! Form::number('bank_ch', rtrim(number_format($chartDetails[0]->bank_ch, 2), '0'), ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => '1.5 / 1.1','id' => 'bank_ch']) !!}

                                                </th>
                                                @else
                                                <th>
                                                    Bank Charge
                                                    {!! Form::number('bank_ch', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => '1.5 / 1.1','id' => 'bank_ch']) !!}
                                                </th>
                                                @endif
                                                <th>Maintenance Cost</th>
                                                <th>Net Return</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if(count($chartDetails) > 0 && $chartDetails[0]->kw == $user->kw)
                                            @foreach($chartDetails as $key => $chartDetail)
                                            <tr>
                                                <td>{{ $chartDetail->year }}</td>
                                                <td>
                                                    {!! Form::number('yearly_kw', $chartDetail->yearly_kw, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW','id' => 'yearly_kw']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('percentage', $chartDetail->percentage, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Percentage','id' => 'percentage']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('unit', $chartDetail->unit, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit','id'=> 'unit']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('net_unit', $chartDetail->net_unit, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Unit','id' => 'net_unit']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('unit_cost', $chartDetail->unit_cost, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit Cost','id' => 'unit_cost']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('gross_return', $chartDetail->gross_return, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Gross Return','id' => 'gross_return']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('bank_charge', $chartDetail->bank_charge, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Bank Charge','id' => 'bank_charge']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('maintenance_cost', $chartDetail->maintenance_cost, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Maintenance Cost','id' => 'maintenance_cost']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('net_return', $chartDetail->net_return, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Return','id' => 'net_return']) !!}
                                                </td>
                                            </tr>
                                            @endforeach
                                            @elseif(count($chartDetails) > 0 && $chartDetails[0]->kw != $user->kw)
                                            <tr>
                                                <td>1</td>
                                                <td>
                                                    {!! Form::number('yearly_kw', ($user->kw * 4) * 365 , ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW','id' => 'yearly_kw']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('percentage', $chartDetails[0]->percentage, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Percentage','id' => 'percentage']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('unit', $chartDetails[0]->unit, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit','id'=> 'unit']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('net_unit', $chartDetails[0]->net_unit, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Unit','id' => 'net_unit']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('unit_cost', $chartDetails[0]->unit_cost, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit Cost','id' => 'unit_cost']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('gross_return', $chartDetails[0]->gross_return, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Gross Return','id' => 'gross_return']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('bank_charge', $chartDetails[0]->bank_charge, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Bank Charge','id' => 'bank_charge']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('maintenance_cost', $chartDetails[0]->maintenance_cost, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Maintenance Cost','id' => 'maintenance_cost']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('net_return', $chartDetails[0]->net_return, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Return','id' => 'net_return']) !!}
                                                </td>
                                            </tr>
                                            @else
                                            <tr>
                                                <td>1</td>
                                                <td>
                                                    {!! Form::number('yearly_kw', ($user->kw * 4) * 365 , ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW','id' => 'yearly_kw']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('percentage', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Percentage','id' => 'percentage']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('unit', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit','id'=> 'unit']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('net_unit', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Unit','id' => 'net_unit']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('unit_cost', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit Cost','id' => 'unit_cost']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('gross_return', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Gross Return','id' => 'gross_return']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('bank_charge', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Bank Charge','id' => 'bank_charge']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('maintenance_cost', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Maintenance Cost','id' => 'maintenance_cost']) !!}
                                                </td>
                                                <td>
                                                    {!! Form::number('net_return', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Return','id' => 'net_return']) !!}
                                                </td>
                                            </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>




                        </div>

                        @if(count($chartDetails) > 0 && $chartDetails[0]->kw != $user->kw)
                        <div class="btn-flt">
                            <div class="alert alert-success">
                                This Client KW changed to {{ ($chartDetails[0]->kw)? $chartDetails[0]->kw : 0 }}kw to {{ $user->kw }}kw. Please update 27 Year data.
                            </div>
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">{{__('Cancel')}}</a>
                            <button type="submit" class="btn btn-primary">Update 27 Year data</button>
                        </div>
                        @endif
                        @if(count($chartDetails) == 0)
                        <div class="btn-flt">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">{{__('Cancel')}}</a>
                            <button type="submit" class="btn btn-primary">Generate 27 Year data</button>
                        </div>
                        @endif
                        {!! Form::close() !!}

                    </div>
                </div>
                @else

                <div class="col-md-6 m-auto">
                    <div class="form-group col-md-6">
                        {{ Form::label('user_select', __('Select Client')) }}
                        <div class="input-group">
                            {!! Form::select('user_select', $users, null, ['class' => 'form-control select2', 'required', 'placeholder' => 'Select Client']) !!}
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <button type="button " id="submit-client" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                @endif
            </div>
        </div>
    </section>
</div>


@endsection

@push('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


@if($id != '' && count($chartDetails) > 0 && $chartDetails[0]->kw == $user->kw)
<script>
    // Convert PHP data to JavaScript
    const dataFromServer = @json($chartDetails);

    // Extract labels (years) and data points (net_return)
    const labels = dataFromServer.map(item => item.year);
    const data = dataFromServer.map(item => item.net_return);

    const ctx = document.getElementById('netReturnChart').getContext('2d');
    const netReturnChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Net Return',
                data: data,
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'blue',
                borderWidth: 1,
                barThickness: 10
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
@endif
<script>
    $(document).ready(function() {
        recalculateValues();
        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "{{ url('chart-details') }}/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });

        function recalculateValues() {
            var kw = $('#kw').val();
            var percentage = $('#percentage').val();
            var cost_unit = $('#unit_cost').val();
            var bank_ch = $('#bank_ch').val();
            var maintenance_cost = $('#maintenance_cost').val();
            var yearly_kw = (kw * 4) * 365;
            var unit = yearly_kw * (percentage / 100);
            var net_unit = yearly_kw - unit;
            var gross_return = net_unit * cost_unit;
            var bank_charge = Math.round(net_unit * bank_ch);
            var net_return = Math.round(gross_return - bank_charge - maintenance_cost);
            // alert(yearly_kw);
            // alert(percentage);

            $('#unit').val(unit);
            $('#net_unit').val(net_unit);
            $('#gross_return').val(gross_return);
            $('#bank_charge').val(bank_charge);
            $('#net_return').val(net_return);
        }


        $('#percentage, #unit_cost, #bank_ch, #maintenance_cost').on('input', recalculateValues);






    });
</script>
@endpush