@extends('layouts.admin')
@section('title', 'Clients')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Add Client</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="{{ route('users.index') }}">Clients</a></div>
                <div class="breadcrumb-item">Add Client</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <div class="card p-4">
                        {!! Form::open(['route' => 'users.store', 'method' => 'Post', 'enctype' => 'multipart/form-data']) !!}
                        <div class="row">
                            <div class="form-group col-md-6">
                                {{ Form::label('name', __('Name')) }}
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    {!! Form::text('name', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Name']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6 ">
                                {{ Form::label('address', __('Address')) }}
                                <div class="input-group ">
                                    {!! Form::textarea('address', null, ['class' => 'form-control', 'cols' => '30', 'rows' => '5', 'required', 'placeholder' => 'Enter Address']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('refrence', __('Refrence')) }}
                                <div class="input-group ">
                                    {!! Form::text('refrence', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Refrence']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('quote_number', __('Quote Number')) }}
                                <div class="input-group ">
                                    {!! Form::text('quote_number', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Quote Number ']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('kw', __('KW')) }}
                                <div class="input-group ">
                                    {!! Form::text('kw', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter KW']) !!}
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                {{ Form::label('date', __('Date')) }}
                                <div class="input-group ">
                                    {!! Form::date('date', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Date ']) !!}
                                </div>
                            </div>
                        </div>



                        <div class="btn-flt">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
                            <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection