 <div class="modal-header">
     <h5 class="modal-title">User Details</h5>
     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
         <span aria-hidden="true">×</span>
     </button>
 </div>
 <div class="modal-body">
     <div class="row ">
         <div class="col-lg-12 product-left mb-5 mb-lg-0">
             <table class="table table-sm">
                 <tbody>
                     <tr>
                         <td class="text-left">Name</td>
                         <td class="text-right">{{ $user->first_name }} {{ $user->last_name }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">Email</td>
                         <td class="text-right">{{ $user->email }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">Mobile</td>
                         <td class="text-right">{{ $user->phone }}</td>
                     </tr>
                     @if($user->CardDetails)
                     <tr>
                         <td class="text-left">Card holder id</td>
                         <td class="text-right">{{ $user->CardDetails->card_holder_id }}</td>
                     </tr>
                     @endif
                     <tr>
                         <td class="text-left">Status</td>
                         <td class="text-right">
                             @if ($user->is_active == 1)
                             <label class="badge badge-primary">Active</label>
                             @else
                             <label class="badge badge-danger">In active</label>
                             @endif
                         </td>
                     </tr>
                     <tr class="mt-3">
                         <th><strong>Address</strong></th>
                     </tr>
                     <tr>
                         <td class="text-left">Country</td>
                         <td class="text-right">{{ $user->country }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">State</td>
                         <td class="text-right" {{ $user->Citydetails->name }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">City</td>
                         <td class="text-right">{{ $user->Citydetails->name }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">Address</td>
                         <td class="text-right">{{ $user->address }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">Postal code</td>
                         <td class="text-right">{{ $user->postal_code }}</td>
                     </tr>
                     @if($user->Documents)
                     <tr class="mt-3">
                         <th><strong>Documents</strong></th>
                     </tr>
                     <tr>
                         <td class="text-left">ID Type</td>
                         <td class="text-right">{{ $user->Documents->id_type }}</td>
                     </tr>
                     <tr>
                         <td class="text-left">ID Number</td>
                         <td class="text-right"> {{ $user->Documents->id_no }}</td>
                     </tr>
                     @if($user->Documents->status != 0)
                     <tr>
                         <td class="text-left">Status</td>
                         <td class="text-right">
                             @if ($user->status == 1)
                             <label class="badge badge-primary">Active</label>
                             @else
                             <label class="badge badge-danger">In active</label>
                             @endif
                         </td>
                     </tr>
                     @endif
                     @endif

                 </tbody>
             </table>
             @if($user->Documents)
             <div class="card">
                 <div class="card-header">
                     <h4>{{ __('Document Images') }}</h4>
                 </div>
                 <div class="card-body  m-auto">
                     <div class="gallery gallery-md">
                         <div class="gallery-item gallery-more" data-image="{{ $user->avatar ? Storage::url($user->id.$user->avatar) : asset('assets/img/avatar/avatar-1.png') }}" data-title="Avatar" href="{{ $user->avatar ? Storage::url($user->id.$user->avatar) : asset('assets/img/avatar/avatar-1.png') }}" title="Avtar" style="background-image: url(&quot;{{ $user->avatar ? Storage::url($user->id.$user->avatar) : asset('assets/img/avatar/avatar-1.png') }}&quot;);">
                             <div>Selfie</div>
                         </div>
                         <div class="gallery-item gallery-more" data-image="{{ $user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/news/img01.jpg') }}" data-title="Avatar" href="{{ $user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/news/img01.jpg') }}" title="Avtar" style="background-image: url(&quot;{{ $user->id.$user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/news/img01.jpg') }}&quot;);">
                             <div>Id Front</div>
                         </div>
                         <div class="gallery-item gallery-more" data-image="{{ $user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/avatar/avatar-1.png') }}" data-title="Avatar" href="{{ $user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/avatar/avatar-1.png') }}" title="Avtar" style="background-image: url(&quot;{{ $user->id.$user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/avatar/avatar-1.png') }}&quot;);">
                             <div>Id Back</div>
                         </div>

                     </div>
                 </div>
                 <div class="card-footer text-right bg-whitesmoke br">
                     @if($user->Documents->status == 0)
                     <button type="button" class="btn btn-danger view-details" data-url="{{ route('open_disapprove_modal',$user->id) }}">Disapprove</button>
                     <button type="button" class="btn btn-success approve_user" data-url="{{ route('approve-user') }}" data-id="{{ $user->id }}">Approve</button>
                     @elseif($user->Documents->status == 1)
                     <h5 class="text-center text-success">{{ __('User Approved') }} <i class="fa fa-check"></i></h5>
                     @else
                     <h5 class="text-center text-danger">{{ __('User Disapproved') }} <i class="fa fa-times"></i></h5>
                     <p class="text-center">{{ __('Reason') }}<br>{{ $user->disapprove_reason }}</p>
                     @endif
                 </div>
             </div>
             @endif


         </div>
     </div>
 </div>
 <div class="modal-footer bg-whitesmoke br">
     <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

 </div>