@extends('layouts.admin')
@section('title', 'Social Links')
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Social Links</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="{{ route('users.index') }}">Clients</a></div>
                <div class="breadcrumb-item">Social Links</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                @if($id != '')
                <div class="col-md-12 m-auto">
                    <div class="card p-4">
                        <div card="card-header ">
                            <h6 class="text-center p-3">Social Links</h6>
                        </div>
                        {!! Form::model($offerDetails, ['route' => ['update-social-links', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']) !!}

                        <div class="row">


                            <div class="form-group col-md-12">

                                @php
                                $social_links = json_decode($offerDetails->social_links);
                                @endphp
                                <div class="col-md-12 mt-auto p-3">

                                    <table border="2" class="text-center w-100" id="repeater-table">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Name</th>
                                                <th>KW</th>
                                                <th>Location</th>
                                                <th>Link</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if($social_links)
                                            <input type="hidden" name="payment_terms_count" id="payment_terms_count" value="{{ count($social_links) }}">
                                            @php
                                            $k = 1;
                                            @endphp
                                            @foreach($social_links as $k => $terms)
                                            <tr>
                                                <td>{{ $k + 1 }}

                                                </td>
                                                <td><input type="text" class="text-center form-control" name="name[]" value="{{ $terms->name }}" required></td>
                                                <td><input type="text" class="text-center form-control" name="kw[]" value="{{ $terms->kw }}" required></td>
                                                <td><input type="text" class="text-center form-control" name="location[]" value="{{ $terms->location }}" required></td>
                                                <td><input type="text" class="text-center form-control" name="link[]" value="{{ $terms->link }}" required></td>
                                                @if($k == 0)
                                                <td><button type="button" class=" btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td>
                                                @else
                                                <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
                                                @endif
                                            </tr>
                                            @endforeach
                                            @else
                                            <input type="hidden" name="payment_terms_count" id="payment_terms_count" value="1">

                                            <tr>
                                                <td>1</td> <!-- First Installment No. -->
                                                <td><input type="text" class="text-center form-control" name="name[]" required></td>
                                                <td><input type="text" class="text-center form-control" name="kw[]" required></td>
                                                <td><input type="text" class="text-center form-control" name="location[]" required></td>
                                                <td><input type="url" class="text-center form-control" name="link[]" required></td>
                                                <td><button type="button" class="btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td> <!-- First row has no remove button -->
                                            </tr>
                                            @endif
                                        </tbody>
                                    </table>

                                </div>
                            </div>


                        </div>


                        <div class="btn-flt">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">{{__('Cancel')}}</a>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                        {!! Form::close() !!}

                    </div>
                </div>
                @else

                <div class="col-md-6 m-auto">
                    <div class="form-group col-md-6">
                        {{ Form::label('user_select', __('Select Client')) }}
                        <div class="input-group">
                            {!! Form::select('user_select', $users, null, ['class' => 'form-control select2', 'required', 'placeholder' => 'Select Client']) !!}
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <button type="button " id="submit-client" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                @endif
            </div>
        </div>
    </section>
</div>


@endsection

@push('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script>
    $(document).ready(function() {

        var rowCount = $('#payment_terms_count').val(); // Initialize row count for Installment No.
        var maxRows = 6; // Initialize row count for Installment No.

        // Function to add a new row
        $('#add-row').click(function() {

            rowCount++;
            var newRow = `<tr>
            <td>${rowCount}</td> <!-- Auto increment Installment No -->
            <td><input type="text" class="text-center form-control" name="name[]" required></td>
            <td><input type="text" class="text-center form-control" name="kw[]" required></td>
            <td><input type="text" class="text-center form-control" name="location[]" required></td>
            <td><input type="url"  class="text-center form-control" name="link[]" required></td>
            <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
        </tr>`;
            $('#repeater-table tbody').append(newRow);

        });

        // Function to remove a row and update Installment Nos
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            updateInstallmentNumbers();
        });

        // Function to update Installment Nos after a row is removed
        function updateInstallmentNumbers() {
            rowCount = 0; // Reset row count
            $('#repeater-table tbody tr').each(function() {
                rowCount++;
                $(this).find('td:first').text(rowCount); // Update Installment No text
            });
        }

        // Form submission
        $('#repeater-form').submit(function(e) {
            e.preventDefault();
            alert("Form submitted!");
            // Here you can handle the form data using AJAX or any other method
        });

        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "{{ url('social-links') }}/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });




    });
</script>
@endpush