<?php


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\StripeController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('/check-mobile', [UserController::class, 'mobileCheck'])->name('check-mobile');
Route::post('register', [UserController::class, 'register'])->name('register');
Route::post('login', [UserController::class, 'login'])->name('login');
Route::post('refresh-token', [UserController::class, 'refreshToken'])->name('refresh-token');
Route::get('cities', [ApiController::class, 'cities'])->name('cities');
Route::get('terms-conditions', [ApiController::class, 'TncList'])->name('terms-conditions');

Route::group(
    ['middleware' => 'api.token'],
    function () {
        Route::post('home', [UserController::class, 'home']);
        Route::get('profile', [UserController::class, 'getProfile']);
        Route::get('delete-user', [StripeController::class, 'deleteUser']);
        Route::post('update-profile', [UserController::class, 'update_profile']);
        Route::get('plan-list', [ApiController::class, 'planList'])->name('planList');
        Route::post('change-plan', [ApiController::class, 'changePlan']);
        Route::get('send-verification-code', [UserController::class, 'sendVerificationCode']);
        Route::post('verify-email', [UserController::class, 'emailVerify']);
        Route::post('change-passcode', [UserController::class, 'changePasscode']);
        Route::get('language-list', [ApiController::class, 'languageList'])->name('languageList');
        Route::post('select-language', [ApiController::class, 'selectLanguage'])->name('selectLanguage');
        Route::get('get-profile/{id}', [ApiController::class, 'getProfile'])->name('getProfile');
        Route::POST('document-verification/{id}', [ApiController::class, 'documentVerification'])->name('documentVerification');
        Route::POST('change-password', [ApiController::class, 'changePassword'])->name('changePassword');

        //Virtual cards 
        
        Route::POST('issuing-card', [StripeController::class, 'cardIssuing'])->name('cardIssuing');        
        Route::POST('fund-card', [StripeController::class, 'fundCard'])->name('fundCard');        
        Route::GET('card-balance', [StripeController::class, 'cardBalance'])->name('cardBalance');        
        Route::POST('card-transactions', [StripeController::class, 'cardTransactions'])->name('cardTransactions');        
        Route::POST('transaction-details', [StripeController::class, 'transactionDetails'])->name('transactionDetails');        
        Route::POST('update-status', [StripeController::class, 'updateStatus'])->name('updateStatus');        
        Route::POST('update-limit', [StripeController::class, 'updateLimit'])->name('updateStatus');        
        Route::GET('stripe-credentials', [StripeController::class, 'stripeCredentials'])->name('stripeCredentials');
        Route::POST('withdraw-request', [StripeController::class, 'withdrawRequest'])->name('withdrawRequest');        

    }
);

