<?php


use App\Http\Controllers\FrontController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\ProductController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Auth::routes();

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('change-lng/{lang}', [FrontController::class, 'changeLanquage'])->name('change.lng');

Route::group(['middleware' => ['auth']], function () {
    Route::resource('roles', RoleController::class);
    Route::resource('users', UserController::class);
    Route::resource('products', ProductController::class);
    Route::resource('modules', ModuleController::class);
    
    
    Route::resource('profile', ProfileController::class);
    Route::get('/basic-details/{id?}', [HomeController::class, 'basicDetails'])->name('basic-details');
    Route::get('/offer-details/{id?}', [HomeController::class, 'offerDetails'])->name('offer-details');
    Route::put('/update-offer-details/{id?}', [HomeController::class, 'updateofferDetails'])->name('update-offer-details');

    Route::get('/social-links/{id?}', [HomeController::class, 'socialLinks'])->name('social-links');
    Route::put('/update-social-links/{id?}', [HomeController::class, 'updatesocialLinks'])->name('update-social-links');

    Route::get('/work-scopes/{id?}', [HomeController::class, 'workScopes'])->name('work-scopes');
    Route::put('/update-work-scopes/{id?}', [HomeController::class, 'updateworkScopes'])->name('update-work-scopes');

    Route::get('/execution-plans/{id?}', [HomeController::class, 'executionPlans'])->name('execution-plans');
    Route::put('/update-execution-plans/{id?}', [HomeController::class, 'updateexecutionPlans'])->name('update-execution-plans');

    Route::get('/chart-details/{id?}', [HomeController::class, 'chartDetails'])->name('chart-details');
    Route::put('/update-chart-details/{id?}', [HomeController::class, 'updatechartDetails'])->name('update-chart-details');
    Route::get('/regenerate-chart/{id?}', [HomeController::class, 'regenerateChart'])->name('regenerate-chart');

    Route::get('product-create/{id?}', [ProductController::class, 'create'])->name('product-create');
    
    
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::get('/fund-unload-card-form/{card}/{action}', [UserController::class, 'fundUnloadCardForm'])->name('fund-unload-card-form');
    Route::post('/fund-unload-card', [UserController::class, 'fundUnloadCard'])->name('fund-unload-card');
    Route::post('/approve-user', [UserController::class, 'approveUser'])->name('approve-user');
    Route::get('/disaaprove-modal/{id}', [UserController::class, 'disaaproveModal'])->name('open_disapprove_modal');
    Route::post('/disapprove-user', [UserController::class, 'disapproveUser'])->name('disapprove-user');
    Route::delete('/card-delete/{user_id}', [UserController::class, 'deleteCard'])->name('card.delete');
    Route::get('/card-transaction/{card_id}', [UserController::class, 'cardTransactions'])->name('card-transaction');
    Route::get('/transaction-details/{card_id}/{refrence_id}', [UserController::class, 'cardTransactionsDetails'])->name('card-transaction-details');
    Route::get('/withdraw-request', [UserController::class, 'WithdrawReq'])->name('withdraw-request-list');
    Route::get('change-status/withdraw/{id}/{status}', [UserController::class, 'withdrawStatusForm'])->name('withdraw.change_status');
    Route::post('update-withdraw-status', [UserController::class, 'withdrawStatusUpdate'])->name('accept-reject-withdraw');


    
    Route::post('/role/{id}', [RoleController::class, 'assignPermission'])->name('roles_permit');
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings');
    Route::post('settings/app-name/update', [SettingsController::class, 'appNameUpdate'])->name('settings/app-name/update');
    Route::post('settings/app-logo/update', [SettingsController::class, 'appNameUpdate'])->name('settings/app-name/update');
    Route::post('settings/pusher-setting/update', [SettingsController::class, 'pusherSettingUpdate'])->name('settings/pusher-setting/update');
    Route::post('settings/s3-setting/update', [SettingsController::class, 's3SettingUpdate'])->name('settings/s3-setting/update');
    Route::post('settings/email-setting/update', [SettingsController::class, 'emailSettingUpdate'])->name('settings/email-setting/update');
    Route::post('settings/auth-settings/update', [SettingsController::class, 'authSettingsUpdate'])->name('settings/auth-settings/update');
    Route::get('setting/{id}', [SettingsController::class, 'loadsetting'])->name('setting');
    Route::get('update-avatar/{id}', [ProfileController::class, 'showAvatar'])->name('update-avatar');
    Route::post('update-avatar/{id}', [ProfileController::class, 'updateAvatar'])->name('update-new-avatar');
    Route::get('update-profile-login/{id}', [ProfileController::class, 'updateLogin'])->name('update-login');
    Route::get('change-language/{lang}', [LanguageController::class, 'changeLanquage'])->name('change.language');
    Route::get('manage-language/{lang}', [LanguageController::class, 'manageLanguage'])->name('manage.language');
    Route::post('store-language-data/{lang}', [LanguageController::class, 'storeLanguageData'])->name('store.language.data');
    Route::get('create-language', [LanguageController::class, 'createLanguage'])->name('create.language');
    Route::get('card-details/{id}', [UserController::class, 'cardDetails'])->name('card.details');
    Route::post('store-language', [LanguageController::class, 'storeLanguage'])->name('store.language');
    Route::delete('/lang/{lang}', [LanguageController::class, 'destroyLang'])->name('lang.destroy');

   
    
    Route::GET('update/status/{id}/{status}/{type}', [App\Http\Controllers\UserController::class, 'updateUserStatus'])->name('updateUserStatus');


    Route::post('/send-test-mail', [SettingsController::class, 'testSendMail'])->name('test.send.mail');
    Route::get('/noti', [UserController::class, 'noti'])->name('noti');
    Route::post('/save-token', [App\Http\Controllers\UserController::class, 'saveToken'])->name('save-token');
    Route::post('/send-notification', [App\Http\Controllers\UserController::class, 'sendNotification'])->name('send.notification');
    Route::get('/index', [HomeController::class, 'index']);
    Route::post('/save-screenshot', [PDFController::class, 'saveScreenshot'])->name('saveScreenshot');
    
    Route::get('/new-pdf/{id?}', [UserController::class, 'newPdf'])->name('newPDF');
    Route::get( '/generate-pdf/{id?}', [PDFController::class, 'generatePDF'])->name('generate-pdf');
    Route::get('dynamic-pdf/{id?}', [UserController::class, 'dynamicPDF'])->name('dynamic-pdf');

    Route::get('background-image', function () {
        $image = file_get_contents('https://fourcell.nexprism.com/assets/img/main.jpg');
        return response($image, 200)->header('Content-Type', 'image/png');
    });
});


