<?php $__env->startSection('title', 'Offer Deatils'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Offer Deatils</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('users.index')); ?>">Clients</a></div>
                <div class="breadcrumb-item">Offer Deatils</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <?php if($id != ''): ?>
                <div class="col-md-12 m-auto">
                    <div class="card p-4">
                        <div card="card-header ">
                            <h6 class="text-center p-3">INDUSTRIAL OFFER</h6>
                        </div>
                        <?php echo Form::model($offerDetails, ['route' => ['update-offer-details', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']); ?>


                        <div class="row">
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('kw', __('KW'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::text('kw', $user->kw, ['class' => 'form-control', 'readonly'=>'readonly', ' required', 'placeholder' => 'Enter DC Capacity']); ?>

                                    <?php echo Form::hidden('gross_total', null, ['class' => 'form-control', 'required', 'placeholder' => 'Enter ','id'=> 'gross_tot' ]); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('per_kw', __('Price Per KW'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('per_kw', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('dc_capacity', __('DC Capacity'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('dc_capacity', null, ['class' => 'form-control', 'min' => '0', 'step' => '0.01', 'required', 'placeholder' => 'Enter DC Capacity', 'onkeyup' => "$('#dc').text($(this).val())"]); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('ac_capacity', __('AC Capacity'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('ac_capacity', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter AC Capacity','onkeyup' => "$('#ac').text($(this).val())"]); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('roof_type', __('Roof type'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::text('roof_type', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Roof Type','onkeyup' => "$('#rooftype').text($(this).val())"]); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('evacuation', __('Evacuation'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::text('evacuation', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Evacuation','onkeyup' => "$('#evacuation_val').text($(this).val())"]); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('geda_charge', __('GEDA Charge'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('geda_charge', null, ['class' => 'form-control', 'min' => '0', 'step' => '0.01',' required', 'placeholder' => 'Enter Geda Charge','onkeyup' => "$('#geda_charge').text($(this).val())"]); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('meter_charge', __('Meter Number'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('meter_charge', null, ['class' => 'form-control','min' => '0', 'step' => '0.01' ,' required', 'placeholder' => 'Enter Meter Number ']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('structure_charge', __('Structure Charge'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('structure_charge', null, ['class' => 'form-control','min' => '0', 'step' => '0.01' ,'required', 'placeholder' => 'Enter Structure Charge']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('safety_charge', __('Safety Charge'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('safety_charge', null, ['class' => 'form-control', 'required','min' => '0', 'step' => '0.01', 'placeholder' => 'Enter Safety Charge']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('manual_cleaning_charge', __('Manual Cleaning Charge'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('manual_cleaning_charge', null, ['class' => 'form-control', 'required', 'min' => '0', 'step' => '0.01','placeholder' => 'Enter Manual Cleaning Charge']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('gst', __('GST'))); ?>

                                <div class="input-group ">
                                    <?php echo Form::number('gst', null, ['class' => 'form-control','id'=>'gst_amount','readonly' => 'readonly', 'required']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <?php echo e(Form::label('total_amount', __('Total Amount'))); ?>

                                <div class="input-group ">

                                    <?php echo Form::hidden('grand_total', null, ['class' => 'form-control', 'required', 'placeholder' => 'Enter ','id'=> 'grand_tot' ]); ?>

                                    <?php echo Form::number('total_amount', null, ['class' => 'form-control','id'=>'total_amount','readonly' => 'readonly', 'required']); ?>

                                </div>
                            </div>




                            <?php
                            $included_charges = json_decode($offerDetails->included_charges);
                            ?>



                            <div class="form-group col-md-3">
                                <div class="control-label">Included Charges</div>
                                <div class="custom-switches-stacked mt-2">
                                    <label class="custom-switch">
                                        <input type="checkbox" name="included_charges[]" value="geda_charge" class="custom-switch-input geda_charge">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">GEDA Charge</span>
                                    </label>
                                    <label class="custom-switch">
                                        <input type="checkbox" name="included_charges[]" value="meter_charge" class="custom-switch-input meter_charge">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Meter Charge</span>
                                    </label>
                                    <label class="custom-switch">
                                        <input type="checkbox" name="included_charges[]" value="structure_charge" class="custom-switch-input structure_charge">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Structure Charge</span>
                                    </label>
                                    <label class="custom-switch">
                                        <input type="checkbox" name="included_charges[]" value="safety_charge" class="custom-switch-input safety_charge">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Safety Charge</span>
                                    </label>
                                    <label class="custom-switch">
                                        <input type="checkbox" name="included_charges[]" value="manual_cleaning_charge" class="custom-switch-input manual_cleanig_charge">
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">Manual Cleanig Charge</span>
                                    </label>
                                </div>
                            </div>



                            <div class="col-md-12 mt-auto p-3">

                                <table border="2" class="text-center w-100">
                                    <thead>
                                        <tr>
                                            <th>System Description</th>
                                            <th colspan="2">Capacity</th>
                                            <th>Roof Type</th>
                                            <th>Evacuation</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="text-center">
                                            <td rowspan="2">Grid connected (Without Battery)</td>
                                            <td>DC</td>
                                            <td id="dc"><?php echo e($offerDetails->dc_capacity ?? 0); ?></td>
                                            <td rowspan="2" id="rooftype"><?php echo e($offerDetails->roof_type ?? ''); ?></td>
                                            <td rowspan="2" id="evacuation_val"><?php echo e($offerDetails->evacuation ?? ''); ?></td>
                                        </tr>
                                        <tr>
                                            <td>AC</td>
                                            <td id="ac"><?php echo e($offerDetails->ac_capacity ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Price per kw</td>
                                            <td></td>
                                            <td id="perkw"><?php echo e($offerDetails->per_kw ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Gross total</td>
                                            <td></td>
                                            <td id="gross_total"><?php echo e($offerDetails->gross_total ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">GEDA charge</td>
                                            <td></td>
                                            <td id="geda"><?php echo e($offerDetails->geda_charge ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Meter Charge</td>
                                            <td></td>
                                            <td id="meter"><?php echo e($offerDetails->meter_charge ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Structure Charge</td>
                                            <td></td>
                                            <td id="structure"><?php echo e($offerDetails->structure_charge ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Safety railing</td>
                                            <td></td>
                                            <td id="safety"><?php echo e($offerDetails->safety_charge ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Manual cleaning system</td>
                                            <td></td>
                                            <td id="manualcharge"><?php echo e($offerDetails->manual_cleaning_charge ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Gross total</td>
                                            <td></td>
                                            <td id="grand_total"><?php echo e($offerDetails->gross_total ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">GST</td>
                                            <td></td>
                                            <td id="gst_amt"><?php echo e($offerDetails->gst ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">Net total</td>
                                            <td></td>
                                            <td id="net_total"><?php echo e($offerDetails->total_amount ?? 0); ?></td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>


                            <div class="form-group col-md-12">
                                <h6 class="text-center p-3">Total project cost of the plant = <strong>Rs <span id="ttl"><?php echo e($offerDetails->total_amount ?? 0); ?></span></strong></h6>
                            </div>

                            <div class="form-group col-md-12">
                                <?php echo e(Form::label('note', __('Note'))); ?>

                                <?php echo Form::textarea('note', null, ['class' => 'form-control', 'required', 'placeholder' => 'Enter Notes', 'id' => 'note']); ?>

                            </div>

                            <div class="form-group col-md-12">
                                <h6 class="text-center p-3">Payment Terms</h6>
                                <?php
                                $payment_terms = json_decode($offerDetails->payment_terms);
                                ?>
                                <div class="col-md-12 mt-auto p-3">

                                    <table border="2" class="text-center w-100" id="repeater-table">
                                        <thead>
                                            <tr>
                                                <th>Installment No</th>
                                                <th>Percentage of PO</th>
                                                <th>Clause</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if($payment_terms): ?>
                                            <input type="hidden" name="payment_terms_count" id="payment_terms_count" value="<?php echo e(count($payment_terms)); ?>">
                                            <?php
                                            $k = 1;
                                            ?>
                                            <?php $__currentLoopData = $payment_terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($k + 1); ?>


                                                </td>
                                                <td><input type="text" class="text-center form-control" name="percentage[]" value="<?php echo e($terms->percentage); ?>" required></td>
                                                <td><input type="text" class="text-center form-control" name="clause[]" value="<?php echo e($terms->clause); ?>" required></td>
                                                <?php if($k == 0): ?>
                                                <td><button type="button" class=" btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td>
                                                <?php else: ?>
                                                <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
                                                <?php endif; ?>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                            <input type="hidden" name="payment_terms_count" id="payment_terms_count" value="1">

                                            <tr>
                                                <td>1</td> <!-- First Installment No. -->
                                                <td><input type="text" class="text-center form-control" name="percentage[]" required></td>
                                                <td><input type="text" class="text-center form-control" name="clause[]" required></td>
                                                <td><button type="button" class="btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td> <!-- First row has no remove button -->
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>

                                </div>
                            </div>


                        </div>


                        <div class="btn-flt">
                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                        <?php echo Form::close(); ?>


                    </div>
                </div>
                <?php else: ?>

                <div class="col-md-6 m-auto">
                    <div class="form-group col-md-6">
                        <?php echo e(Form::label('user_select', __('Select Client'))); ?>

                        <div class="input-group">
                            <?php echo Form::select('user_select', $users, null, ['class' => 'form-control select2', 'required', 'placeholder' => 'Select Client']); ?>

                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <button type="button " id="submit-client" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                <?php endif; ?>
            </div>
        </div>
    </section>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<?php if($id != ''): ?>
<script>
    $(document).ready(function() {
        <?php $__currentLoopData = $included_charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $charge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        $('input[name="included_charges[]"][value="<?php echo e($charge); ?>"]').prop('checked', true);
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });
</script>
<?php endif; ?>
<script>
    $(document).ready(function() {

        var rowCount = $('#payment_terms_count').val(); // Initialize row count for Installment No.
        var maxRows = 6; // Initialize row count for Installment No.

        // Function to add a new row
        $('#add-row').click(function() {
            if (rowCount < maxRows) {
                rowCount++;
                var newRow = `<tr>
            <td>${rowCount}</td> <!-- Auto increment Installment No -->
            <td><input type="text" class="text-center form-control" name="percentage[]" required></td>
            <td><input type="text"  class="text-center form-control" name="clause[]" required></td>
            <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
        </tr>`;
                $('#repeater-table tbody').append(newRow);
            } else {
                alert("Maximum of 6 Terms allowed.");
            }
        });

        // Function to remove a row and update Installment Nos
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            updateInstallmentNumbers();
        });

        // Function to update Installment Nos after a row is removed
        function updateInstallmentNumbers() {
            rowCount = 0; // Reset row count
            $('#repeater-table tbody tr').each(function() {
                rowCount++;
                $(this).find('td:first').text(rowCount); // Update Installment No text
            });
        }

        // Form submission
        $('#repeater-form').submit(function(e) {
            e.preventDefault();
            alert("Form submitted!");
            // Here you can handle the form data using AJAX or any other method
        });

        $('#note').summernote({
            height: 200, // set editor height
            toolbar: [
                ['font', ['bold', 'underline', 'clear']],
                ['para', ['ul', 'ol', 'paragraph']],
            ]
        });

        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "<?php echo e(url('offer-details')); ?>/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });

        function calculateTotal() {
            var kw = parseFloat($('input[name="kw"]').val()) || 0;
            var per_kw = parseFloat($('input[name="per_kw"]').val()) || 0;
            var geda_charge = $('input[name="included_charges[]"][value="geda_charge"]:checked').length ? 0 : parseFloat($('input[name="geda_charge"]').val()) || 0;
            var meter_charge = $('input[name="included_charges[]"][value="meter_charge"]:checked').length ? 0 : parseFloat($('input[name="meter_charge"]').val()) || 0;
            var structure_charge = $('input[name="included_charges[]"][value="structure_charge"]:checked').length ? 0 : parseFloat($('input[name="structure_charge"]').val()) || 0;
            var safety_charge = $('input[name="included_charges[]"][value="safety_charge"]:checked').length ? 0 : parseFloat($('input[name="safety_charge"]').val()) || 0;
            var manual_cleaning_charge = $('input[name="included_charges[]"][value="manual_cleaning_charge"]:checked').length ? 0 : parseFloat($('input[name="manual_cleaning_charge"]').val()) || 0;

            $('#perkw').text(per_kw);

            $('#geda').text(geda_charge);
            $('#meter').text(meter_charge);
            $('#structure').text(structure_charge);
            $('#safety').text(safety_charge);
            $('#manualcharge').text(manual_cleaning_charge);

            var totalCharges = geda_charge + meter_charge + structure_charge + safety_charge + manual_cleaning_charge;
            // console.log(totalCharges);
            var t = (kw * per_kw);
            //round off to 2 decimal places
            t = Math.round(t * 100) / 100;
            $('#gross_total').text(t);
            $('#gross_tot').val(t);

            var total = (kw * per_kw) + totalCharges;
            //round off to 2 decimal places
            total = Math.round(total * 100) / 100;
            // console.log(total);
            $('#grand_total').text(total);
            $('#grand_tot').val(total);
            var gst = total * 0.138; // 13.8% GST
            //round off to 2 decimal places
            gst = Math.round(gst * 100) / 100;
            // console.log(gst);
            $('#gst_amount').val(gst);
            $('#gst_amt').text(gst);
            var finalTotal = total + gst;
            //round off to 2 decimal places
            finalTotal = Math.round(finalTotal * 100) / 100;
            $('#net_total').text(finalTotal);
            // console.log(finalTotal);
            // console.log("Total Amount: ", finalTotal); // Display total in console or update a field
            $('#total_amount').val(finalTotal);
            $('#ttl').text(finalTotal);
        }

        // Attach change event to input fields
        $('input').on('input change', calculateTotal);
        $('input[name="included_charges[]"]').on('change', calculateTotal);
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\fourcell\resources\views/users/offer_details.blade.php ENDPATH**/ ?>