<?php $__env->startSection('title', 'Plans'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Create plan</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('plans.index')); ?>">Plans</a></div>
                <div class="breadcrumb-item">Create plan</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <div class="card p-4">
                        <?php echo Form::open(['route' => 'plans.store', 'method' => 'Post', 'enctype' => 'multipart/form-data']); ?>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <?php echo e(Form::label('name', __('Name'))); ?>

                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::text('name', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Name']); ?>

                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <?php echo e(Form::label('price', __('Price'))); ?>

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fa fa-rupee-sign"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::number('price', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Price']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <?php echo e(Form::label('country', __('Select Country'))); ?>

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-globe"></i>
                                        </div>
                                    </div>
                                    <select name="country" class="form-control">
                                        <option value="cameroon">Cameroon</option>
                                        <option value="other-countries">Other countries</option>
                                    </select>
                                </div>
                            </div>
                        </div>




                        <div class="row repeater">

                            <div class="col-md-3">
                                <button class="btn btn-info" data-repeater-create type="button" title="Add new "><i class="fas fa-plus"></i> Add Features</button>
                            </div>
                            <div class="form-group col-md-8" data-repeater-list='features_list'>
                                <?php echo e(Form::label('features', __('Features'))); ?>

                                <div class="input-group" data-repeater-item>
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fa fa-list"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::text('features', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Features']); ?>

                                </div>
                            </div>
                            <br>
                        </div>


                        <div class="btn-flt">
                            <a href="<?php echo e(route('plans.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php echo $__env->make('layouts.includes.datatable_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script>
    $(".repeater").repeater();
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/plan/create.blade.php ENDPATH**/ ?>