<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>FOURCELL</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/pdf.css')); ?>" />
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap");

        .second-page .text-cont {
            text-align: justify;
            text-justify: inter-word;
            line-height: 25px;
            font-size: 20px;
            max-width: 655px;
            width: 700px;
            background: #65b6cf;
            padding: 4vw;
            height: 700px;
            color: white;

        }

        .ninth-page .left .ninth-bottom {
            max-width: 70%;
            min-width: 70%;

            p {
                font-weight: 800;
                font-size: 18px;
            }

            li {
                font-size: 16px;
                word-spacing: 4px;
                line-height: 22px;
                margin-bottom: 20px;
                font-weight: 500;
                max-width: 550px;
            }
        }

        .tenth-page {
            width: 100%;
            min-height: 100vh;
            display: flex;
            justify-content: center;
        }

        .tenth-page img {
            width: 80%;


        }

        /*.right .windmil {*/
        /*    min-height: 160vh;*/
        /*    max-height: 1400px;*/
        /*    width: 100%;*/
        /*    object-fit: cover;*/

        /*}*/

        @media print {
            .ninth-page .left .ninth-bottom {
                max-width: 100%;
                min-width: 96%;

                p {
                    font-weight: 800;
                    font-size: 18px;
                    margin-bottom: 10px !important;
                }

                li {
                    font-size: 16px;
                    word-spacing: 4px;
                    line-height: 22px;
                    margin-bottom: 15px;
                    font-weight: 500;
                    max-width: 600px;
                }
            }

            .tenth-page {
                width: 100%;
                min-height: 100vh;
                display: flex;
                justify-content: center;
            }

            .tenth-page img {
                width: 100%;
                object-fit: cover;
            }
        }
         .page-break {
        page-break-before: always;
    }
    </style>

</head>

<body>
    <button onclick="window.print()" style="z-index:99; bottom:5%; right:5%; padding:8px 20px;" class="btn btn-primary no-print">Print</button>


    <div class="main-structure printable-content" style="max-width: 1550px; margin: 0 auto">
        <div class="main-landing-page">
            <div class="upper">
                <div class="logo">
                    <img src="<?php echo e(asset('assets/img/mainLogo.png')); ?>" alt="" />
                </div>
                <div class="text">
                    <h1 class="roboto-bold">
                        <?php echo e($user->kw); ?> KW <br />
                        Solar <br />
                        Proposal
                    </h1>
                </div>
                <div class="cover-image">
                    <img src="<?php echo e(asset('assets/img/bottom.png')); ?>" alt="" />
                </div>
            </div>
            <div class="bottom-landing-page">
                <img src="<?php echo e(asset('assets/img/bottom-bg.png')); ?>" alt="" />
                <div style="font-weight:500" class="label">
                    <span class="roboto-regular">To : <?php echo e($user->name); ?>

                        <br>
                        <br>
                        Address : <?php echo e($user->address); ?>

                    </span><span class="roboto-regular">Date:<?php echo e($user->date); ?></span>
                </div>
                <div class="label">
                    <span class="roboto-regular">Quote Number:<?php echo e($user->quote_number); ?></span><span class="roboto-regular">Ref No:<?php echo e($user->refrence); ?></span>
                </div>
            </div>
        </div>

        <div class="second-page">
            <div>
                <h2 class="roboto-bold">Welcome</h2>

                <div class="text-cont roboto-regular">
                    <?php echo $user->welcome_message; ?>

                </div>
            </div>
        </div>

        <div class="third-page">

            <div class="text">
                <h2 class="roboto-medium"><?php echo e($user->mw); ?></h2>
                <h2 class="roboto-medium"><?php echo e($user->customers); ?></h2>
                <h2 class="roboto-medium"><?php echo e($user->category); ?></h2>
            </div>
            <img src="<?php echo e(asset('assets/img/PAGE3-three.png')); ?>" alt="" />

        </div>

        <div class="fourth-page">
            <div class="image"></div>
            <div class="content">
                <img src="<?php echo e(asset('assets/img/detail.png')); ?>" alt="" />
                <div class="table">
                    <h2 class="heading roboto-bold">INDUSTRIAL OFFER</h2>
                    <table>
                        <tr class="header">
                            <th>System Description</th>
                            <th colspan="2">Capacity</th>
                            <th>Roof Type</th>
                            <th>Evacuation</th>
                        </tr>
                        <tr>
                            <td rowspan="2">Grid connected (Without Battery)</td>
                            <td>DC</td>
                            <td id="dc"><?php echo e($offerDetails->dc_capacity ?? 0); ?></td>
                            <td rowspan="2" id="rooftype" class="roboto-bold"><?php echo e($offerDetails->roof_type ?? ''); ?></td>
                            <td rowspan="2" id="evacuation_val"><?php echo e($offerDetails->evacuation ?? ''); ?></td>
                        </tr>
                        <tr>
                            <td>AC</td>
                            <td id="ac"><?php echo e($offerDetails->ac_capacity ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Price per kw</td>
                            <td></td>
                            <td id="perkw"><?php echo e($offerDetails->per_kw ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Gross total</td>
                            <td></td>
                            <td id="gross_total"><?php echo e($offerDetails->gross_total ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">GEDA charge</td>
                            <td></td>
                            <td id="geda"><?php echo e($offerDetails->geda_charge ?? 0); ?></td>
                        </tr>

                        <tr>
                            <td colspan="3">Meter Charge</td>
                            <td></td>
                            <td id="meter"><?php echo e($offerDetails->meter_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Structure Charge</td>
                            <td></td>
                            <td id="structure"><?php echo e($offerDetails->structure_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Safety railing</td>
                            <td></td>
                            <td id="safety"><?php echo e($offerDetails->safety_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Manual cleaning system</td>
                            <td></td>
                            <td id="manualcharge"><?php echo e($offerDetails->manual_cleaning_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Gross total</td>
                            <td></td>
                            <td id="grand_total" class="roboto-bold"><?php echo e($offerDetails->gross_total ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">GST</td>
                            <td class="roboto-bold">13.8%</td>
                            <td id="gst_amt" class="roboto-bold"><?php echo e($offerDetails->gst ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Net total</td>
                            <td></td>
                            <td id="net_total" class="roboto-bold"><?php echo e($offerDetails->total_amount ?? 0); ?></td>
                        </tr>
                    </table>
                </div>

                <p class="para roboto-regular" style="width: 58%">
                    Total project cost of the plant =
                    <span style="font-weight: 700" class="roboto-bold">RS <?php echo e($offerDetails->total_amount ?? 0); ?></span>
                </p>

                <div class="points" style=" padding: 20px">
                    <?php echo $offerDetails->note; ?>

                </div>

                <div class="table">
                    <table>
                        <tr>
                            <th>Installment No.</th>
                            <th>Percentage of PO</th>
                            <th>Clause</th>
                        </tr>
                        <?php
                        $payment_terms = json_decode($offerDetails->payment_terms);
                        ?>
                        <?php if($payment_terms): ?>
                        <?php
                        $k = 1;
                        ?>
                        <?php $__currentLoopData = $payment_terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($k + 1); ?></td>
                            <td><?php echo e($terms->percentage); ?></td>
                            <td><?php echo e($terms->clause); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>

        <div class="fifth-page">
            <!--<img-->
            <!--    src="<?php echo e(asset('assets/img/1.png')); ?>"-->
            <!--    alt=""-->
            <!--    style="height:100%; width:100%; position:absolute; z-index:1;" />-->
            <div style="position:relative; z-index:9;">
               
               
                <table id="custom-table" style="margin: 0 auto">
    <tr>
        <th>No.</th>
        <th>Name</th>
        <th>KW</th>
        <th>Location</th>
        <th>Link</th>
    </tr>
    <?php
        $social_links = json_decode($offerDetails->social_links);
        $j = 0;
    ?>
    <?php if($social_links): ?>
        <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($j > 0 && $j % 20 == 0): ?>
                <!-- Add a page break every 20 records -->
                </table>
                <div class="page-break"></div>
                <table id="custom-table" style="margin: 0 auto">
                    <tr>
                        <th>No.</th>
                        <th>Name</th>
                        <th>KW</th>
                        <th>Location</th>
                        <th>Link</th>
                    </tr>
            <?php endif; ?>
            <tr class="singleRow">
                <td><?php echo e($j + 1); ?></td>
                <td><?php echo e($terms->name); ?></td>
                <td><?php echo e($terms->kw); ?></td>
                <td><?php echo e($terms->location); ?></td>
                <td><a href="<?php echo e($terms->link); ?>">Link</a></td>
            </tr>
            <?php $j++; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</table>

               
            </div>
        </div>
        
<!--        <div class="fifth-page">-->
<!--    <div style="position:relative; z-index:9;">-->
<!--        <table id="custom-table" style="margin: 0 auto">-->
<!--            <tr>-->
<!--                <th>No.</th>-->
<!--                <th>Name</th>-->
<!--                <th>KW</th>-->
<!--                <th>Location</th>-->
<!--                <th>Link</th>-->
<!--            </tr>-->
<!--            <?php-->
<!--            $social_links = json_decode($offerDetails->social_links);-->
<!--            ?>-->
<!--            <?php if($social_links): ?>-->
<!--            <?php-->
<!--            $j = 1;-->
<!--            ?>-->
<!--            <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
<!--            <tr class="singleRow">-->
<!--                <td><?php echo e($j + 1); ?></td>-->
<!--                <td><?php echo e($terms->name); ?></td>-->
<!--                <td><?php echo e($terms->kw); ?></td>-->
<!--                <td><?php echo e($terms->location); ?></td>-->
<!--                <td><a href="<?php echo e($terms->link); ?>">Link</a></td>-->
<!--            </tr>-->
<!--            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
<!--            <?php endif; ?>-->
<!--        </table>-->
<!--    </div>-->
<!--</div>-->


        <div class="sixth-page">
            <img
                src="<?php echo e(asset('assets/img/14.png')); ?>"
                alt=""
                style="width: 100%; margin-bottom: 30px" />
            <!-- <img src="<?php echo e(asset('assets/img/2.png')); ?>" alt="" class="bottom"> -->

            <div class="des">
                <table id="sixthpagetable" style="max-width: 60%; margin: 0 auto; font-weight: 600; position: relative; z-index: 99;">
                    <thead style="margin-top: 40px!important;">
                        <tr style="margin-top: 40px!important;">
                            <th>No.</th>
                            <th>Equipment</th>
                            <th>Company / Particulars</th>
                            <th>Technical Specification</th>
                        </tr>
                    </thead>
                    <tbody id="maint-body">
                        <?php if($products): ?>
                        <?php
                        $i = 1;
                        ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $compnies = json_decode($product->company);
                        ?>
                        <?php $__currentLoopData = $compnies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $q => $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <?php if($q < 1): ?>
                                <td rowspan="<?php echo e(count($compnies)); ?>"><?php echo e($i + 1); ?></td>
                                <td rowspan="<?php echo e(count($compnies)); ?>"><img src="<?php echo e(Storage::url( $product->equipment )); ?>" alt="" /></td>
                                <?php endif; ?>
                                <td style="text-align:center; vertical-align:middle"><?php echo e($company->company); ?></td>
                                <td style="max-width: 400px">
                                    <?php echo $company->specification; ?>

                                </td>

                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </tbody>
                </table>
                <img id="bottom-img" src="<?php echo e(asset('assets/img/4.png')); ?>" alt="">
            </div>
        </div>



        <?php
        $yearly_kw = $chartDetails[0]->yearly_kw;
        $unit_cost = $chartDetails[0]->unit_cost;
        $cost = $offerDetails->grand_total;
        $saving = $unit_cost * $yearly_kw;
        $payback = $cost / $saving;
        $ibs = $user->kw * 6345;
        $co2 = $ibs * 0.4536;
        $roi = (100 / $payback) / 12;



        ?>




        <div class="seventh-page">
            <div class="visual">
                <h1
                    class="roboto-medium"
                    style="margin-bottom: 20px; margin-left: 70px">
                    A Visual Guide
                </h1>

                <!-- <img class="save" src="<?php echo e(asset('assets/img/save.png')); ?>" alt="" /> -->
            </div>

            <div class="seventh-wrapper">
                <div class="chart-container">
                    <?php if(count($chartDetails) > 0): ?>
                    <div style="width: 75%;" class="chartdom p-3">
                        <canvas id="netReturnChart"></canvas>
                    </div>
                    <?php endif; ?>
                </div>


                <div class="seventh-container">
                    <div id="box1" class="seventh-box">
                        <img src="<?php echo e(asset('assets/img/18.png')); ?>" alt="">
                        <div class="detail-wrapper">
                            <h4 class="roboto-medium">Payback Period</h4>
                            <h2 class="roboto-bold"><?php echo e(number_format($payback, 2)); ?> Years</h2>
                        </div>
                    </div>
                    <div id="box2" class="seventh-box">
                        <img style="scale: 1.1;" src="<?php echo e(asset('assets/img/19.png')); ?>" alt="">
                        <div class="detail-wrapper">
                            <h4 class="roboto-medium">Average Yealy <br> Generation</h4>
                            <h2 class="roboto-bold"><?php echo e(number_format($yearly_kw,2)); ?> Units</h2>
                        </div>
                    </div>
                    <div id="box3" class="seventh-box">
                        <img src="<?php echo e(asset('assets/img/20.png')); ?>" alt="">
                        <div class="detail-wrapper">
                            <h4 class="roboto-medium">Average Annual <br> Savings</h4>
                            <h2 class="roboto-bold">₹ <?php echo e(number_format($saving,2)); ?></h2>
                        </div>
                    </div>
                    <div id="box4" class="seventh-box">
                        <img src="<?php echo e(asset('assets/img/21.png')); ?>" alt="">
                        <div class="detail-wrapper">
                            <h4 class="roboto-medium">Project Cost</h4>
                            <h2 class="roboto-bold">₹ <?php echo e(number_format($cost,2)); ?></h2>
                        </div>
                    </div>
                    <div id="box5" class="seventh-box">
                        <img style="scale: 1.1;" src="<?php echo e(asset('assets/img/22.png')); ?>" alt="">
                        <div class="detail-wrapper">
                            <h4 class="roboto-medium">ROI</h4>
                            <h2 class="roboto-bold"><?php echo e(number_format($roi,2)); ?> %</h2>
                        </div>
                    </div>
                    <div id="box6" class="seventh-box">
                        <img src="<?php echo e(asset('assets/img/23.png')); ?>" alt="">
                        <div class="detail-wrapper">
                            <h4 class="roboto-medium">CO2 Reduction</h4>
                            <h2 class="roboto-bold">₹ <?php echo e(number_format($co2,2)); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="eight-page">
            <img class="detailed-work" src="<?php echo e(asset('assets/img/detailed-work.png')); ?>" alt="">
            <table id="eightpagetable" style="width: 80%; margin: 20px auto; border-collapse: collapse; font-family: Arial, sans-serif; font-size: 14px;">
                <thead>
                    <tr style="background: linear-gradient(to right, #f76b1c, #fcdc4a); border: 1px solid #000;">
                        <th style="border: 1px solid #000; padding: 8px;">No.</th>
                        <th style="border: 1px solid #000; padding: 8px;">Scope of Work</th>
                        <th style="border: 1px solid #000; padding: 8px;">Foucell</th>
                        <th style="border: 1px solid #000; padding: 8px;">Customer</th>
                    </tr>
                </thead>
                <?php
                $work_scopes = json_decode($offerDetails->work_scopes);
                ?>
                <tbody class="eightPageContent">
                    <?php if($work_scopes): ?>
                    <?php
                    $k = 1;
                    ?>
                    <?php $__currentLoopData = $work_scopes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $work_scope): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;"><?php echo e($k + 1); ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?php echo e($work_scope->work); ?></td>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;"><?php echo e($work_scope->fourcell); ?></td>
                        <td style="border: 1px solid #000; padding: 8px;text-align: center;"><?php echo e($work_scope->customer); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>



                </tbody>
            </table>

        </div>

        <div class="ninth-page">
            <div class="left">
                <img class="execution" src="<?php echo e(asset('assets/img/execution.png')); ?>" alt="">
                <table class="execution-table">
                    <thead>
                        <tr>
                            <th style="text-align:center;">Job</th>
                            <th style="text-align:center;">Task</th>
                            <th style="text-align:center;">Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>Issuance of PO</td>
                            <td><?php echo e($offerDetails->po_issuance); ?></td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td><?php echo e($offerDetails->geda_registration); ?></td>
                            <td>15-20 Days</td>
                        </tr>
                        <tr>
                            <td colspan="3"><strong>Detailed Engineering</strong></td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Site Survey & Measurements</td>
                            <td rowspan="2"><?php echo e($offerDetails->detailed_engineering); ?></td>
                        </tr>
                        <tr>
                            <td>4</td>
                            <td>System Design & Engineering drawings</td>
                        </tr>
                        <tr>
                            <td colspan="3"><strong>Procurement, Inspection & Delivery</strong></td>
                        </tr>
                        <tr>
                            <td>5</td>
                            <td>Module mounting structures</td>
                            <td rowspan="8"><?php echo e($offerDetails->procurement); ?></td>
                        </tr>
                        <tr>
                            <td>6</td>
                            <td>Solar modules</td>
                        </tr>
                        <tr>
                            <td>7</td>
                            <td>Cables</td>
                        </tr>
                        <tr>
                            <td>8</td>
                            <td>Junction Boxes</td>
                        </tr>
                        <tr>
                            <td>9</td>
                            <td>Inverter</td>
                        </tr>
                        <tr>
                            <td>10</td>
                            <td>DCDB/ACDB</td>
                        </tr>
                        <tr>
                            <td>11</td>
                            <td>Earthing</td>
                        </tr>
                        <tr>
                            <td>12</td>
                            <td>Lightning Arrester & other items</td>
                        </tr>
                        <tr>
                            <!-- <!DOCTYPE html> -->
                            <!-- I/flutter (27199): ^ -->

                            <td colspan="3"><strong>Installation, Testing & Commissioning</strong></td>
                        </tr>
                        <tr>
                            <td>13</td>
                            <td>Site taking over</td>
                            <td rowspan="8"><?php echo e($offerDetails->installation_testing); ?></td>
                        </tr>
                        <tr>
                            <td>14</td>
                            <td>Marking & Construction of pedestals/foundation</td>
                        </tr>
                        <tr>
                            <td>15</td>
                            <td>Assembly & fixing of structures</td>
                        </tr>
                        <tr>
                            <td>16</td>
                            <td>Module Mounting over structures</td>
                        </tr>
                        <tr>
                            <td>17</td>
                            <td>Cabling & Termination</td>
                        </tr>
                        <tr>
                            <td>18</td>
                            <td>Inverter installations</td>
                        </tr>
                        <tr>
                            <td>19</td>
                            <td>DCDB/ACDB installation</td>
                        </tr>
                        <tr>
                            <td>20</td>
                            <td>Earthing & Lightning Arrester Installation</td>
                        </tr>
                        <tr>
                            <td>21</td>
                            <td>Pre-commissioning test</td>
                            <td rowspan="2"><?php echo e($offerDetails->pre_commissioning); ?></td>
                        </tr>
                        <tr>
                            <td>22</td>
                            <td>Commissioning & handing over of Plant</td>
                        </tr>
                    </tbody>
                </table>

                <div class="ninth-bottom">
                    <P id="ninth-bottom-heading" class="roboto-medium" style="margin-bottom: 30px;">General terms and Conditions for the Proposal</P>
                    <div class="ninth-bottom-content">
                        <p class="roboto-regular">
                            <?php echo $offerDetails->general_terms; ?>

                        </p>
                    </div>
                </div>

            </div>
            <div class="right" style="width: 100%;">
                <img class="windmil" src="<?php echo e(asset('assets/img/windmil.png')); ?>" alt="">
            </div>
        </div>

        <div class="tenth-page">
            <img src="<?php echo e(Storage::url(Utility::getsettings('support_image'))); ?>" alt="">
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.3.1/jspdf.umd.min.js"></script>
<?php if($chartDetails): ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Convert PHP data to JavaScript
    const dataFromServer = <?php echo json_encode($chartDetails, 15, 512) ?>;

    // Extract labels (years) and data points (net_return)
    const labels = dataFromServer.map(item => item.year);
    const data = dataFromServer.map(item => item.net_return);

    const ctx = document.getElementById('netReturnChart').getContext('2d');
    const netReturnChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Net Return',
                data: data,
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'blue',
                borderWidth: 1,
                barThickness: 10
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
<?php endif; ?>
<script>
    $(document).ready(function() {
        // Capture the full page screenshot on page load
        //set timeout to wait for the page to load
        setTimeout(function() {
            // var a4 = [595.28, 841.89]; // A4 size in points
            // $('body').width((a4[0] * 1.33333) - 80).css('max-width', 'none');

            html2canvas(document.body, {
                onrendered: function(canvas) {
                    var imageData = canvas.toDataURL('image/png');

                    // Send the captured image data to the backend via AJAX
                    $.ajax({
                        url: '<?php echo e(url("save-screenshot")); ?>',
                        method: 'POST',
                        data: {
                            id: '<?php echo e($user->id); ?>',
                            image: imageData,
                            _token: $('meta[name="csrf-token"]').attr('content') // Laravel CSRF token
                        },
                        success: function(response) {
                            console.log('Screenshot saved and PDF generated.');
                        },
                        error: function() {
                            console.error('Failed to save the screenshot.');
                        }
                    });
                }
            });
        }, 7000);


    });
</script>
<!--//-->
<!--//         document.addEventListener("DOMContentLoaded", function() {-->
<!--//     const sixthPage = document.querySelector('.sixth-page');-->
<!--//     const contentHeight = sixthPage.scrollHeight;-->
<!--//     const pageHeight = window.innerHeight;-->

<!--//     if (contentHeight > pageHeight && contentHeight <= pageHeight * 1.5) {-->
<!--//         sixthPage.classList.add('content-1-5');-->
<!--//     } else if (contentHeight > pageHeight * 1.5 && contentHeight <= pageHeight * 2) {-->
<!--//         sixthPage.classList.add('content-2');-->
<!--//     } else if (contentHeight > pageHeight * 2) {-->
<!--//         sixthPage.classList.add('content-3');-->
<!--//     }-->
<!--// });-->
<!--//-->

<script>
    
//     document.addEventListener("DOMContentLoaded", function() {
//     const sixthPage = document.querySelector('.sixth-page');
//     const customTable = document.getElementById('sixthpagetable');

//     const A4PageHeight = 1122; // A4 page height in pixels

//     function applyImgHeightClass() {
//         if (!customTable) return;

//         const contentHeight = customTable.clientHeight;

        
//         sixthPage.classList.remove('image-1-5', 'image-2', 'image-3', 'image-4', 'image-5', 'image-6', 'image-7', 'image-8', 'image-9');
//         // sixthPage.classList.remove('sixth-image-1-5', 'sixth-image-2', 'sixth-image-3', 'sixth-image-4', 'sixth-image-5', 'sixth-image-6', 'sixth-image-7', 'sixth-image-8', 'sixth-image-9');

       
//         if (contentHeight > 0 && contentHeight <= A4PageHeight * 1.5) {
//             sixthPage.classList.add('image-1-5');
//         } else if (contentHeight > A4PageHeight * 1.5 && contentHeight <= A4PageHeight * 2) {
//             sixthPage.classList.add('image-2');
//         } else if (contentHeight > A4PageHeight * 2 && contentHeight <= A4PageHeight * 3) {
//             sixthPage.classList.add('image-3');
//         } else if (contentHeight > A4PageHeight * 3 && contentHeight <= A4PageHeight * 4) {
//             sixthPage.classList.add('image-4');
//         } else if (contentHeight > A4PageHeight * 4 && contentHeight <= A4PageHeight * 5) {
//             sixthPage.classList.add('image-5');
//         } else if (contentHeight > A4PageHeight * 5 && contentHeight <= A4PageHeight * 6) {
//             sixthPage.classList.add('image-6');
//         } else if (contentHeight > A4PageHeight * 6 && contentHeight <= A4PageHeight * 7) {
//             sixthPage.classList.add('image-7');
//         } else if (contentHeight > A4PageHeight * 7 && contentHeight <= A4PageHeight * 8) {
//             sixthPage.classList.add('image-8');
//         } else if (contentHeight > A4PageHeight * 8) {
//             sixthPage.classList.add('image-9');
//         }
//     }

//     applyImgHeightClass();

  
//     window.addEventListener('resize', applyImgHeightClass);
// });

document.addEventListener("DOMContentLoaded", function() {
    // Sixth Page Script
    const sixthPage = document.querySelector('.sixth-page');
    const sixthPageTable = document.getElementById('sixthpagetable');
    const A4PageHeight = 1000; // A4 page height in pixels

    function applySixthPageImgHeightClass() {
        if (!sixthPageTable) return;

        const contentHeight = sixthPageTable.clientHeight;
        
        sixthPage.classList.remove('image-1-5', 'image-2', 'image-3', 'image-4', 'image-5', 'image-6', 'image-7', 'image-8', 'image-9');

        if (contentHeight > 0 && contentHeight <= A4PageHeight * 1.5) {
            sixthPage.classList.add('image-1-5');
        } else if (contentHeight > A4PageHeight * 1.5 && contentHeight <= A4PageHeight * 2) {
            sixthPage.classList.add('image-2');
        } else if (contentHeight > A4PageHeight * 2 && contentHeight <= A4PageHeight * 3) {
            sixthPage.classList.add('image-3');
        } else if (contentHeight > A4PageHeight * 3 && contentHeight <= A4PageHeight * 4) {
            sixthPage.classList.add('image-4');
        } else if (contentHeight > A4PageHeight * 4 && contentHeight <= A4PageHeight * 5) {
            sixthPage.classList.add('image-5');
        } else if (contentHeight > A4PageHeight * 5 && contentHeight <= A4PageHeight * 6) {
            sixthPage.classList.add('image-6');
        } else if (contentHeight > A4PageHeight * 6 && contentHeight <= A4PageHeight * 7) {
            sixthPage.classList.add('image-7');
        } else if (contentHeight > A4PageHeight * 7 && contentHeight <= A4PageHeight * 8) {
            sixthPage.classList.add('image-8');
        } else if (contentHeight > A4PageHeight * 8) {
            sixthPage.classList.add('image-9');
        }
    }

    applySixthPageImgHeightClass();
    window.addEventListener('resize', applySixthPageImgHeightClass);
});
    
    
 </script>
 
 
<script>


// document.addEventListener("DOMContentLoaded", function() {
//     const fifthPage = document.querySelector('.fifth-page');
//     const customTable = document.getElementById('custom-table');

//     const A4PageHeight = 1122; // A4 page height in pixels

//     function applyImgHeightClass() {
//         if (!customTable) return;

//         const contentHeight = customTable.clientHeight;
//         console.log(contentHeight);

        
//         // fifthPage.classList.remove('image-1-5', 'image-2', 'image-3', 'image-4', 'image-5', 'image-6', 'image-7', 'image-8', 'image-9');
//         fifthPage.classList.remove('fifth-image-1-5', 'fifth-image-2', 'fifth-image-3', 'fifth-image-4', 'fifth-image-5', 'fifth-image-6', 'fifth-image-7', 'fifth-image-8', 'fifth-image-9');

       
//         if (contentHeight > 0 && contentHeight <= A4PageHeight * 1.5) {
//             fifthPage.classList.add('fifth-image-1-5');
//         } else if (contentHeight > A4PageHeight * 1.5 && contentHeight <= A4PageHeight * 2) {
//             fifthPage.classList.add('fifth-image-2');
//         } else if (contentHeight > A4PageHeight * 2 && contentHeight <= A4PageHeight * 3) {
//             fifthPage.classList.add('fifth-image-3');
//         } else if (contentHeight > A4PageHeight * 3 && contentHeight <= A4PageHeight * 4) {
//             fifthPage.classList.add('fifth-image-4');
//         } else if (contentHeight > A4PageHeight * 4 && contentHeight <= A4PageHeight * 5) {
//             fifthPage.classList.add('fifth-image-5');
//         } else if (contentHeight > A4PageHeight * 5 && contentHeight <= A4PageHeight * 6) {
//             fifthPage.classList.add('fifth-image-6');
//         } else if (contentHeight > A4PageHeight * 6 && contentHeight <= A4PageHeight * 7) {
//             fifthPage.classList.add('fifth-image-7');
//         } else if (contentHeight > A4PageHeight * 7 && contentHeight <= A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-8');
//         } else if (contentHeight > A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-9');
//         }
//     }

//     applyImgHeightClass();

  
//     window.addEventListener('resize', applyImgHeightClass);
// });



// document.addEventListener("DOMContentLoaded", function() {
//     // Fifth Page Script with Debugging
//     const fifthPage = document.querySelector('.fifth-page');
//     const fifthPageTable = document.getElementById('custom-table');
//     const A4PageHeight = 1122; 

//     function applyFifthPageImgHeightClass() {
//         if (!fifthPageTable) return;

//         // Log content height for debugging
//         const contentHeight = fifthPageTable.clientHeight;
//          const contentHeight2 = fifthPage.clientHeight;
//         console.log("Fifth Page Table Content Height:", contentHeight);
//         console.log("Fifth Page Table Content Height:", contentHeight2);

//         // Remove previous classes
//         fifthPage.classList.remove(
//             'fifth-image-1', 'fifth-image-2', 'fifth-image-3',
//             'fifth-image-4', 'fifth-image-5', 'fifth-image-6',
//             'fifth-image-7', 'fifth-image-8', 'fifth-image-9'
//         );

//         // Apply class based on content height
//         if (contentHeight > 0 && contentHeight <= A4PageHeight * 1) {
//             fifthPage.classList.add('fifth-image-1');
//         } else if (contentHeight > A4PageHeight * 1 && contentHeight <= A4PageHeight * 2) {
//             fifthPage.classList.add('fifth-image-2');
//         } else if (contentHeight > A4PageHeight * 2 && contentHeight <= A4PageHeight * 3) {
//             fifthPage.classList.add('fifth-image-3');
//         } else if (contentHeight > A4PageHeight * 3 && contentHeight <= A4PageHeight * 4) {
//             fifthPage.classList.add('fifth-image-4');
//         } else if (contentHeight > A4PageHeight * 4 && contentHeight <= A4PageHeight * 5) {
//             fifthPage.classList.add('fifth-image-5');
//         } else if (contentHeight > A4PageHeight * 5 && contentHeight <= A4PageHeight * 6) {
//             fifthPage.classList.add('fifth-image-6');
//         } else if (contentHeight > A4PageHeight * 6 && contentHeight <= A4PageHeight * 7) {
//             fifthPage.classList.add('fifth-image-7');
//         } else if (contentHeight > A4PageHeight * 7 && contentHeight <= A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-8');
//         } else if (contentHeight > A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-9');
//         }
        
        
        
//     }


//     setTimeout(applyFifthPageImgHeightClass, 100);

//     // Reapply classes on resize
//     window.addEventListener('resize', applyFifthPageImgHeightClass);
// });


// document.addEventListener("DOMContentLoaded", function() {
//     // Fifth Page Script with Debugging
//     const fifthPage = document.querySelector('.fifth-page');
//     const fifthPageTable = document.getElementById('custom-table');
//     const A4PageHeight = 1122; 

//     function applyFifthPageImgHeightClass() {
//         if (!fifthPageTable) return;

//         // Log content height for debugging
//         const contentHeight = fifthPageTable.clientHeight;
//         const fifthPageHeight = fifthPage.clientHeight;
//         console.log("Fifth Page Table Content Height:", contentHeight);
//         console.log("Fifth Page Container Height:", fifthPageHeight);

//         // Remove previous classes
//         fifthPage.classList.remove(
//             'fifth-image-1', 'fifth-image-2', 'fifth-image-3',
//             'fifth-image-4', 'fifth-image-5', 'fifth-image-6',
//             'fifth-image-7', 'fifth-image-8', 'fifth-image-9'
//         );

//         // Apply class based on content height
//         if (contentHeight > 0 && contentHeight <= A4PageHeight * 1) {
//             fifthPage.classList.add('fifth-image-1');
//         } else if (contentHeight > A4PageHeight * 1 && contentHeight <= A4PageHeight * 2) {
//             fifthPage.classList.add('fifth-image-2');
//         } else if (contentHeight > A4PageHeight * 2 && contentHeight <= A4PageHeight * 3) {
//             fifthPage.classList.add('fifth-image-3');
//         } else if (contentHeight > A4PageHeight * 3 && contentHeight <= A4PageHeight * 4) {
//             fifthPage.classList.add('fifth-image-4');
//         } else if (contentHeight > A4PageHeight * 4 && contentHeight <= A4PageHeight * 5) {
//             fifthPage.classList.add('fifth-image-5');
//         } else if (contentHeight > A4PageHeight * 5 && contentHeight <= A4PageHeight * 6) {
//             fifthPage.classList.add('fifth-image-6');
//         } else if (contentHeight > A4PageHeight * 6 && contentHeight <= A4PageHeight * 7) {
//             fifthPage.classList.add('fifth-image-7');
//         } else if (contentHeight > A4PageHeight * 7 && contentHeight <= A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-8');
//         } else if (contentHeight > A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-9');
//         }

//         // Calculate the remaining space and add as padding to fifthPageTable
//         const remainingSpace = fifthPageHeight - contentHeight;
//         const paddingToAdd = remainingSpace > 0 ? remainingSpace : 0;
//         fifthPageTable.style.paddingBottom = `${paddingToAdd}px`;

//         console.log("Remaining space (padding added):", paddingToAdd);
//     }

//     // Delay execution slightly to ensure the element is fully loaded
//     setTimeout(applyFifthPageImgHeightClass, 100);

//     // Reapply classes on resize
//     window.addEventListener('resize', applyFifthPageImgHeightClass);
// });



// ---------------- main ---------------------

// document.addEventListener("DOMContentLoaded", function() {
//     // Fifth Page Script with Debugging
//     const fifthPage = document.querySelector('.fifth-page');
//     const fifthPageTables = document.querySelectorAll('#custom-table'); // Select all custom-tables
//     const A4PageHeight = 1122; 

//     function applyFifthPageImgHeightClass() {
//         if (!fifthPageTables.length) return;

//         // Calculate total height of all custom-tables
//         let totalTableHeight = 0;
//         fifthPageTables.forEach(table => {
//             totalTableHeight += table.clientHeight;
//         });

//         const fifthPageHeight = fifthPage.clientHeight;

//         console.log("Total Table Height:", totalTableHeight);
//         console.log("Fifth Page Container Height:", fifthPageHeight);

//         // Remove previous classes
//         fifthPage.classList.remove(
//             'fifth-image-1', 'fifth-image-2', 'fifth-image-3',
//             'fifth-image-4', 'fifth-image-5', 'fifth-image-6',
//             'fifth-image-7', 'fifth-image-8', 'fifth-image-9'
//         );

//         // Apply class based on total table height
//         if (totalTableHeight > 0 && totalTableHeight <= A4PageHeight * 1) {
//             fifthPage.classList.add('fifth-image-1');
//         } else if (totalTableHeight > A4PageHeight * 1 && totalTableHeight <= A4PageHeight * 2) {
//             fifthPage.classList.add('fifth-image-2');
//         } else if (totalTableHeight > A4PageHeight * 2 && totalTableHeight <= A4PageHeight * 3) {
//             fifthPage.classList.add('fifth-image-3');
//         } else if (totalTableHeight > A4PageHeight * 3 && totalTableHeight <= A4PageHeight * 4) {
//             fifthPage.classList.add('fifth-image-4');
//         } else if (totalTableHeight > A4PageHeight * 4 && totalTableHeight <= A4PageHeight * 5) {
//             fifthPage.classList.add('fifth-image-5');
//         } else if (totalTableHeight > A4PageHeight * 5 && totalTableHeight <= A4PageHeight * 6) {
//             fifthPage.classList.add('fifth-image-6');
//         } else if (totalTableHeight > A4PageHeight * 6 && totalTableHeight <= A4PageHeight * 7) {
//             fifthPage.classList.add('fifth-image-7');
//         } else if (totalTableHeight > A4PageHeight * 7 && totalTableHeight <= A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-8');
//         } else if (totalTableHeight > A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-9');
//         }

//         // // Calculate the remaining space and add as padding to fifthPageTable
//         // const remainingSpace = fifthPageHeight - totalTableHeight;
//         // const paddingToAdd = remainingSpace > 0 ? remainingSpace : 0;

//         // // Apply the calculated padding to each custom-table
//         // fifthPageTables.forEach(table => {
//         //     table.style.paddingBottom = `${paddingToAdd}px`;
//         // });

//         // console.log("Remaining space (padding added):", paddingToAdd);
//     }

//     // Delay execution slightly to ensure the element is fully loaded
//     setTimeout(applyFifthPageImgHeightClass, 100);

//     // Reapply classes on resize
//     window.addEventListener('resize', applyFifthPageImgHeightClass);
// });



document.addEventListener("DOMContentLoaded", function() {
    // Fifth Page Script with Debugging
    const fifthPage = document.querySelector('.fifth-page');
    const fifthPageTables = document.querySelectorAll('#custom-table'); // Select all custom-tables
    const A4PageHeight = 1000; 

    function applyFifthPageImgHeightClass() {
        if (!fifthPageTables.length) return;

        // Calculate total height of all custom-tables
        let totalTableHeight = 0;
        fifthPageTables.forEach(table => {
            totalTableHeight += table.clientHeight;
        });

        const fifthPageHeight = fifthPage.clientHeight;

        console.log("Total Table Height:", totalTableHeight);
        console.log("Fifth Page Container Height:", fifthPageHeight);

        // Remove previous classes
        fifthPage.classList.remove(
            'fifth-image-1', 'fifth-image-2', 'fifth-image-3',
            'fifth-image-4', 'fifth-image-5', 'fifth-image-6',
            'fifth-image-7', 'fifth-image-8', 'fifth-image-9'
        );

        // Apply class based on total table height
        if (totalTableHeight <= A4PageHeight * 1) {
            fifthPage.classList.add('fifth-image-1');
        } else if (totalTableHeight > A4PageHeight * 1 && totalTableHeight <= A4PageHeight * 2) {
            fifthPage.classList.add('fifth-image-2');
        } else if (totalTableHeight > A4PageHeight * 2 && totalTableHeight <= A4PageHeight * 3) {
            fifthPage.classList.add('fifth-image-3');
        } else if (totalTableHeight > A4PageHeight * 3 && totalTableHeight <= A4PageHeight * 4) {
            fifthPage.classList.add('fifth-image-4');
        } else if (totalTableHeight > A4PageHeight * 4 && totalTableHeight <= A4PageHeight * 5) {
            fifthPage.classList.add('fifth-image-5');
        } else if (totalTableHeight > A4PageHeight * 5 && totalTableHeight <= A4PageHeight * 6) {
            fifthPage.classList.add('fifth-image-6');
        } else if (totalTableHeight > A4PageHeight * 6 && totalTableHeight <= A4PageHeight * 7) {
            fifthPage.classList.add('fifth-image-7');
        } else if (totalTableHeight > A4PageHeight * 7 && totalTableHeight <= A4PageHeight * 8) {
            fifthPage.classList.add('fifth-image-8');
        } else if (totalTableHeight > A4PageHeight * 8) {
            fifthPage.classList.add('fifth-image-9');
        }

        // Calculate the remaining space and add as padding to fifthPageTable
        const remainingSpace = fifthPageHeight - totalTableHeight;
        const paddingToAdd = remainingSpace > 0 ? remainingSpace : 0;

        // Apply the calculated padding to each custom-table
        fifthPageTables.forEach(table => {
            table.style.paddingBottom = `${paddingToAdd}px`;
        });

        console.log("Remaining space (padding added):", paddingToAdd);
    }

    // Delay execution slightly to ensure the element is fully loaded
    setTimeout(applyFifthPageImgHeightClass, 100);

    // Reapply classes on resize
    window.addEventListener('resize', applyFifthPageImgHeightClass);
});



// document.addEventListener("DOMContentLoaded", function() {
//     const fifthPage = document.querySelector('.fifth-page');
//     const fifthPageTables = document.querySelectorAll('#custom-table');
//     const A4PageHeight = 1000;

//     function applyFifthPageImgHeightClass() {
//         if (!fifthPageTables.length) return;

//         // Calculate total height of all custom-tables
//         let totalTableHeight = 0;
//         fifthPageTables.forEach(table => {
//             totalTableHeight += table.clientHeight;
//         });

//         const fifthPageHeight = fifthPage.clientHeight;

//         console.log("Total Table Height:", totalTableHeight);
//         console.log("Fifth Page Container Height:", fifthPageHeight);

//         // Remove previous classes
//         fifthPage.classList.remove(
//             'fifth-image-1', 'fifth-image-2', 'fifth-image-3',
//             'fifth-image-4', 'fifth-image-5', 'fifth-image-6',
//             'fifth-image-7', 'fifth-image-8', 'fifth-image-9'
//         );

//         // Apply class based on total table height
//         if (totalTableHeight <= A4PageHeight) {
//             fifthPage.classList.add('fifth-image-1');
//         } else if (totalTableHeight <= A4PageHeight * 2) {
//             fifthPage.classList.add('fifth-image-2');
//         } else if (totalTableHeight <= A4PageHeight * 3) {
//             fifthPage.classList.add('fifth-image-3');
//         } else if (totalTableHeight <= A4PageHeight * 4) {
//             fifthPage.classList.add('fifth-image-4');
//         } else if (totalTableHeight <= A4PageHeight * 5) {
//             fifthPage.classList.add('fifth-image-5');
//         } else if (totalTableHeight <= A4PageHeight * 6) {
//             fifthPage.classList.add('fifth-image-6');
//         } else if (totalTableHeight <= A4PageHeight * 7) {
//             fifthPage.classList.add('fifth-image-7');
//         } else if (totalTableHeight <= A4PageHeight * 8) {
//             fifthPage.classList.add('fifth-image-8');
//         } else {
//             fifthPage.classList.add('fifth-image-9');
//         }

//         // Calculate the remaining space and add as padding to fifthPageTable
//         const remainingSpace = fifthPageHeight - totalTableHeight;
//         const paddingToAdd = remainingSpace > 0 ? remainingSpace : 0;

//         // Apply the calculated padding to each custom-table
//         fifthPageTables.forEach(table => {
//             table.style.paddingBottom = `${paddingToAdd}px`;
//         });

//         console.log("Remaining space (padding added):", paddingToAdd);
//     }

//     // Delay execution slightly to ensure the element is fully loaded
//     setTimeout(applyFifthPageImgHeightClass, 100);

//     // Reapply classes on resize
//     window.addEventListener('resize', applyFifthPageImgHeightClass);
// });









</script>












</html><?php /**PATH /home/nexprism/fourcell.nexprism.com/resources/views/dashboard/index.blade.php ENDPATH**/ ?>