 <style>
     @import url('https://fonts.googleapis.com/css2?family=josefin+Sans:wght@400;500;600;700&display=swap');

     * {
         margin: 0;
         padding: 0;
         box-sizing: border-box;
         font-family: 'Josefin Sans', sans-serif;
     }

     .container {
         min-height: 100vh;
         width: 100%;
         background: #000;
         display: flex;
         align-items: center;
         justify-content: center;
     }

     .card-details .card {
         width: 500px;
         height: 300px;
         color: #fff;
         cursor: pointer;
         perspective: 1000px;
     }

     .card-details .card-inner {
         width: 100%;
         height: 100%;
         position: relative;
         transition: transform 1s;
         transform-style: preserve-3d;
     }

     .front,
     .back {
         width: 100%;
         height: 100%;
         background-image: linear-gradient(45deg, #0045c7, #ff2c7d);
         position: absolute;
         top: 0;
         left: 0;
         padding: 20px 30px;
         border-radius: 15px;
         overflow: hidden;
         z-index: 1;
         backface-visibility: hidden;
     }

     .row {
         display: flex;
         align-items: center;
         justify-content: space-between;
     }

     .map-img {
         width: 100%;
         position: absolute;
         top: 0;
         left: 0;
         opacity: 0.3;
         z-index: -1;
     }

     .card-no {
         font-size: 35px;
         margin-top: 30px;
     }

     .card-holder {
         font-size: 12px;
         margin-top: 40px;
     }

     .name {
         font-size: 22px;
         margin-top: 20px;
     }

     .bar {
         background: #222;
         margin-left: -30px;
         margin-right: -30px;
         height: 60px;
         margin-top: 10px;
     }

     .card-cvv {
         margin-top: 20px;
     }

     .card-cvv div {
         flex: 1;
     }

     .card-cvv img {
         width: 100%;
         display: block;
         line-height: 0;
     }

     .card-cvv p {
         background: #fff;
         color: #000;
         font-size: 22px;
         padding: 11px 20px;
         margin-top: 15px;
     }

     .card-text {
         margin-top: 30px;
         font-size: 14px;
     }

     .signature {
         margin-top: 30px;
     }

     .back {
         transform: rotateY(180deg);
     }

     .card:hover .card-inner {
         transform: rotateY(-180deg);
     }
 </style>

 <div class="modal-header">
     <h5 class="modal-title">Card Details</h5>
     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
         <span aria-hidden="true">×</span>
     </button>
 </div>
 <div class="modal-body">
     <div class="row card-details ">
         <div class="card">
             <div class="card-inner">
                 <div class="front">
                     <img src="https://i.ibb.co/PYss3yv/map.png" class="map-img">
                     <div class="row">
                         <img src="https://i.ibb.co/G9pDnYJ/chip.png" width="60px">
                         <h3><?php echo e($card->brand); ?></h3>
                     </div>
                     <?php
                     $cleanedNumber = preg_replace('/[^\d]/', '', $card->card_number);

                     // Add a space every four digits
                     $formattedNumber = chunk_split($cleanedNumber, 4, ' ');

                     // Remove trailing space
                     $formattedNumber = rtrim($formattedNumber);
                     ?>
                     <div class="row card-no">
                         <p><?php echo e($formattedNumber); ?></p>

                     </div>
                     <div class="row card-holder">
                         <p>CARD HPLDER</p>
                         <p>VALID TILL</p>
                     </div>
                     <div class="row name">
                         <p><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></p>
                         <p><?php echo e($card->exp_month); ?> / <?php echo e(substr($card->exp_year,2)); ?></p>
                     </div>
                 </div>
                 <div class="back">
                     <img src="https://i.ibb.co/PYss3yv/map.png" class="map-img">
                     <div class="bar"></div>
                     <div class="row card-cvv">
                         <div>
                             <img src="https://i.ibb.co/S6JG8px/pattern.png">
                         </div>
                         <p><?php echo e($card->cvc); ?></p>
                     </div>
                     <div class="row card-text">
                         <p>this is a virtual card design by Paysen. You can use for online payment.</p>
                     </div>
                     <div class="row signature">
                         <p>CUSTOMER SIGNATURE</p>
                         <img src="https://i.ibb.co/WHZ3nRJ/visa.png" width="80px">
                     </div>
                 </div>
             </div>
         </div>
         <div class="col-lg-12 product-left mb-5 mb-lg-0">
             <table class="table table-sm">
                 <tbody>
                     <tr>
                         <td class="text-left">Card id</td>
                         <td class="text-right"><?php echo e($card->card_id); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Card type</td>
                         <td class="text-right">virtual</td>
                     </tr>
                     <tr>
                         <td class="text-left">Card currency</td>
                         <td class="text-right"><?php echo e($card->currency); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Card balance</td>
                         <td class="text-right"><?php echo e($card->balance); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Date created</td>
                         <td class="text-right"><?php echo e(Utility::date_time_format($card->created_at)); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Status</td>
                         <td class="text-right">
                             <?php if($card->status == 1): ?>
                             <label class="badge badge-primary">Active</label>
                             <?php else: ?>
                             <label class="badge badge-danger">In active</label>
                             <?php endif; ?>
                         </td>
                     </tr>
                 </tbody>
             </table>
         </div>
     </div>
 </div>
 <div class="modal-footer bg-whitesmoke br">
     <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

 </div><?php /**PATH C:\laragon\www\virtual_card\resources\views/card/show.blade.php ENDPATH**/ ?>