<?php $__env->startSection('title', $t); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?php echo e($t); ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>"><?php echo e(__('Dashboard')); ?></a></div>
                <div class="breadcrumb-item"><a href="<?php echo e(route('settings')); ?>"><?php echo e(__('Settings')); ?></a></div>
                <div class="breadcrumb-item"><?php echo e($t); ?></div>
            </div>
        </div>
        <div class="section-body">
            <h2 class="section-title"><?php echo e(__('All About')); ?> <?php echo e($t); ?></h2>
            <p class="section-lead">
                <?php echo e(__('You can adjust all ')); ?><?php echo e($t); ?> <?php echo e(__('here')); ?>

            </p>
            <div id="output-status"></div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4><?php echo e(__('Jump To')); ?></h4>
                        </div>
                        <div class="card-body">
                            <ul class="nav nav-tabs">
                                <li class="nav-item">
                                    <a class="nav-link " href="<?php echo e(route('content','home-page')); ?>">Home Page</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " href="<?php echo e(route('content','pricing-page')); ?>">Product Page</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="<?php echo e(route('content','pricing-page')); ?>">Pricing page</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " href="<?php echo e(route('content','support-page')); ?>">Support page</a>
                                </li>
                            </ul>



                            <form id="setting-form" action="<?php echo e(route('update.content','pricing-page')); ?>" enctype="multipart/form-data" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="card" id="settings-card">
                                    <div class="card-header">
                                        <h4> <?php echo e($t); ?></h4>
                                    </div>
                                    <div class="card-body">
                                        <h5 class="text-muted"> <?php echo e(__('Banner Section')); ?> </h5>

                                        <div class=" row mb-5">



                                            <div class="col-lg-8">
                                                <div class="form-group">
                                                    <label for="name"><?php echo e(__('Title')); ?> </label>
                                                    <input type="text" name="banner_title" class="form-control" value="<?php echo e(Utility::getcontents('banner_title','pricing-page')); ?>" placeholder="<?php echo e(__('Title')); ?>" required>
                                                </div>


                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group bg-light text-center">
                                                    <img id="banner_image" class="img img-responsive my-3 w-50 justify-content-center text-center" src="<?php echo e(Storage::url('content/'.Utility::getcontents('banner_image','pricing-page'))); ?>" class="app-logo w-50" alt="Banner Image">

                                                </div>
                                                <div class="form-group">
                                                    <label for="name"><?php echo e(__('Select Image')); ?></label>
                                                    <input type="file" name="banner_image" class="form-control" value="Select Image">
                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group col-md-12 text-center">
                                            <a class="btn btn-success" href="<?php echo e(route('plans.index')); ?>"><?php echo e(__('Manage Pricing Plans')); ?></a>

                                        </div>


                                    </div>

                                    <div class="card-footer  text-md-right">
                                        <button class="btn btn-primary" type="submit" id="save-btn"><?php echo e(__('Save Changes')); ?></button>
                                        <a href="<?php echo e(route('content','pricing-page')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/content/pricing-page.blade.php ENDPATH**/ ?>