<?php $__env->startSection('title', 'Product'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Edit Product</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('modules.index')); ?>">Products</a></div>
                <div class="breadcrumb-item">Edit Product</div>
            </div>
        </div>
        <?php echo Form::model($product, ['method' => 'PATCH', 'route' => ['products.update', $product->id],'enctype' => 'multipart/form-data']); ?>

        <div class="col-md-12 m-auto">
            <div class="card p-4">
                <div class="card-header"><?php echo e(__('Edit Product')); ?> </div>
                <div class="card-body row">

                    <div class="form-group col-md-6">
                        <?php echo e(Form::label('name', __('Name'))); ?>

                        <?php echo e(Form::text('name', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Product name'])); ?>

                    </div>
                    <div class="form-group col-md-6">
                        <?php echo e(Form::label('equipment', __('Equipment'))); ?>

                        <img src="<?php echo e(Storage::url($product->equipment)); ?>" alt="Equipment" class="img-thumbnail"
                            style="width: 100px;">
                        <br>

                        <?php echo Form::file('equipment', ['class' => 'form-control']); ?>

                    </div>

                    <div class="form-group col-md-12">


                        <div class="col-md-12 mt-auto p-3">
                            <?php
                            $companies = json_decode($product->company);
                            ?>
                            <table border="2" class="text-center w-100" id="repeater-table">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Company</th>
                                        <th>Specification</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php if($companies): ?>
                                    <input type="hidden" name="product_company_count" id="product_company_count" value="<?php echo e(count($companies)); ?>">

                                    <?php
                                    $k = 1;
                                    ?>
                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($k + 1); ?></td>
                                        <td><input type="text" class="text-center form-control" name="company[]" value="<?php echo e($company->company); ?>" required></td>
                                        <td><textarea class="text-center form-control specification" name="specification[]"><?php echo $company->specification; ?></textarea></td>
                                        <?php if($k == 0): ?>
                                        <td><button type="button" class=" btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td>
                                        <?php else: ?>
                                        <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
                                        <?php endif; ?>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <input type="hidden" name="product_company_count" id="product_company_count" value="1">
                                    <tr>
                                        <td>1</td> <!-- First Installment No. -->
                                        <td style="width: 200px;"><input type="text" class="text-center form-control" name="company[]" required></td>
                                        <td><textarea class="text-center form-control specification" name="specification[]"></textarea></td>
                                        <td><button type="button" class="btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td> <!-- First row has no remove button -->
                                    </tr>
                                    <?php endif; ?>

                                </tbody>
                            </table>

                        </div>
                    </div>


                    <?php echo e(Form::submit(__('Submit'), ['class' => 'btn btn-primary'])); ?>


                    <a class="btn btn-secondary" href="<?php echo e(route('products.index')); ?>"> <?php echo e(__('Back')); ?></a>

                </div>
                <?php echo Form::close(); ?>

            </div>
        </div>
    </section>
</div>
<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('javascript'); ?>
<script>
    $(document).ready(function() {
        var rowCount = $('#product_company_count').val(); // Initialize row count for Installment No.
        // Initialize row count for Installment No.

        // Function to add a new row
        $('#add-row').click(function() {

            rowCount++;
            var newRow = `<tr>
            <td>${rowCount}</td> <!-- Auto increment Installment No -->
            <td><input type="text" class="text-center form-control" name="company[]" ></td>
            <td><textarea class="text-center form-control specification" name="specification[]" ></textarea></td>

                                        <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
                                    </tr>`;
            $('#repeater-table tbody').append(newRow);

            $('.specification').last().summernote({
                height: 200, // set editor height
                toolbar: [
                    ['font', ['bold', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']],
                ]
            });
        });

        // Function to remove a row and update Installment Nos
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            updateInstallmentNumbers();
        });

        // Function to update Installment Nos after a row is removed
        function updateInstallmentNumbers() {
            rowCount = 0; // Reset row count
            $('#repeater-table tbody tr').each(function() {
                rowCount++;
                $(this).find('td:first').text(rowCount); // Update Installment No text
            });
        }
        $('.specification').summernote({
            height: 200, // set editor height
            toolbar: [
                ['font', ['bold', 'underline', 'clear']],
                ['para', ['ul', 'ol', 'paragraph']],
            ]
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\fourcell\resources\views/products/edit.blade.php ENDPATH**/ ?>