<?php
$users = \Auth::user();
$currantLang = $users->currentLanguage();
$languages = Utility::languages();


// $profile = asset(Storage::url('uploads/avatar/'));
?>
<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            
            <img src="<?php echo e(Storage::url(Utility::getsettings('app_logo'))); ?>" class="app-logo w-50">

        </div>
        <div class="sidebar-brand sidebar-brand-sm">
            <img src="<?php echo e(Storage::url(Utility::getsettings('app_small_logo'))); ?>" class="app-logo w-50">

            

            <img src="" class="app-logo w-50">

        </div>
        <ul class="sidebar-menu pt-3">

            <li>
                <a class="nav-link" href="<?php echo e(route('home')); ?>"><i class="fas fa-fire text-primary"></i>
                    <span><?php echo e(__('Dashboard')); ?></span></a>
            </li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-user')): ?>
            <li>
                <a class="nav-link" href="<?php echo e(route('users.index')); ?>"><i class="fas fa-users text-primary"></i>
                    <span><?php echo e(__('Users')); ?></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(route('card-list')); ?>"><i class="fas fa-credit-card text-warning"></i>
                    <span><?php echo e(__('Issued Cards')); ?></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(route('withdraw-request-list')); ?>"><i class="fas fa-money-bill-wave text-success"></i>
                    <span><?php echo e(__('Withdraw Request')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-setting')): ?>
            <li>
                <a class="nav-link" href="<?php echo e(route('settings')); ?>"><i class="fas fa-pencil-ruler text-primary  "></i>
                    <span><?php echo e(__('Settings')); ?></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(route('content','home-page')); ?>"><i class="fa fa-pen-square text-info  "></i>
                    <span><?php echo e(__('Contents')); ?></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(route('plans.index')); ?>"><i class="fas fa-rocket text-warning  "></i>
                    <span><?php echo e(__('Pricing Plans')); ?></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(route('faqs.index')); ?>"><i class="fas fa-question-circle text-warning  "></i>
                    <span><?php echo e(__('Faqs')); ?></span></a>
            </li>
            <?php endif; ?>
            
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('manage.language', [$currantLang])); ?>">
                    <i class="fas fa-globe text-primary"></i>
                    <span class="nav-link-text"><?php echo e(__('Manage Language')); ?></span>
                </a>
            </li>
            


        </ul>


    </aside>
</div><?php /**PATH C:\laragon\www\virtual_card\resources\views/admin/menu.blade.php ENDPATH**/ ?>