 <div class="modal-header">
     <h5 class="modal-title">User Details</h5>
     <button type="button" class="close" data-dismiss="modal" aria-label="Close">
         <span aria-hidden="true">×</span>
     </button>
 </div>
 <div class="modal-body">
     <div class="row ">
         <div class="col-lg-12 product-left mb-5 mb-lg-0">
             <table class="table table-sm">
                 <tbody>
                     <tr>
                         <td class="text-left">Name</td>
                         <td class="text-right"><?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Email</td>
                         <td class="text-right"><?php echo e($user->email); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Mobile</td>
                         <td class="text-right"><?php echo e($user->phone); ?></td>
                     </tr>
                     <?php if($user->CardDetails): ?>
                     <tr>
                         <td class="text-left">Card holder id</td>
                         <td class="text-right"><?php echo e($user->CardDetails->card_holder_id); ?></td>
                     </tr>
                     <?php endif; ?>
                     <tr>
                         <td class="text-left">Status</td>
                         <td class="text-right">
                             <?php if($user->is_active == 1): ?>
                             <label class="badge badge-primary">Active</label>
                             <?php else: ?>
                             <label class="badge badge-danger">In active</label>
                             <?php endif; ?>
                         </td>
                     </tr>
                     <tr class="mt-3">
                         <th><strong>Address</strong></th>
                     </tr>
                     <tr>
                         <td class="text-left">Country</td>
                         <td class="text-right"><?php echo e($user->country); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">State</td>
                         <td class="text-right" <?php echo e($user->Citydetails->name); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">City</td>
                         <td class="text-right"><?php echo e($user->Citydetails->name); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Address</td>
                         <td class="text-right"><?php echo e($user->address); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">Postal code</td>
                         <td class="text-right"><?php echo e($user->postal_code); ?></td>
                     </tr>
                     <?php if($user->Documents): ?>
                     <tr class="mt-3">
                         <th><strong>Documents</strong></th>
                     </tr>
                     <tr>
                         <td class="text-left">ID Type</td>
                         <td class="text-right"><?php echo e($user->Documents->id_type); ?></td>
                     </tr>
                     <tr>
                         <td class="text-left">ID Number</td>
                         <td class="text-right"> <?php echo e($user->Documents->id_no); ?></td>
                     </tr>
                     <?php if($user->Documents->status != 0): ?>
                     <tr>
                         <td class="text-left">Status</td>
                         <td class="text-right">
                             <?php if($user->status == 1): ?>
                             <label class="badge badge-primary">Active</label>
                             <?php else: ?>
                             <label class="badge badge-danger">In active</label>
                             <?php endif; ?>
                         </td>
                     </tr>
                     <?php endif; ?>
                     <?php endif; ?>

                 </tbody>
             </table>
             <?php if($user->Documents): ?>
             <div class="card">
                 <div class="card-header">
                     <h4><?php echo e(__('Document Images')); ?></h4>
                 </div>
                 <div class="card-body  m-auto">
                     <div class="gallery gallery-md">
                         <div class="gallery-item gallery-more" data-image="<?php echo e($user->avatar ? Storage::url($user->id.$user->avatar) : asset('assets/img/avatar/avatar-1.png')); ?>" data-title="Avatar" href="<?php echo e($user->avatar ? Storage::url($user->id.$user->avatar) : asset('assets/img/avatar/avatar-1.png')); ?>" title="Avtar" style="background-image: url(&quot;<?php echo e($user->avatar ? Storage::url($user->id.$user->avatar) : asset('assets/img/avatar/avatar-1.png')); ?>&quot;);">
                             <div>Selfie</div>
                         </div>
                         <div class="gallery-item gallery-more" data-image="<?php echo e($user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/news/img01.jpg')); ?>" data-title="Avatar" href="<?php echo e($user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/news/img01.jpg')); ?>" title="Avtar" style="background-image: url(&quot;<?php echo e($user->id.$user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/news/img01.jpg')); ?>&quot;);">
                             <div>Id Front</div>
                         </div>
                         <div class="gallery-item gallery-more" data-image="<?php echo e($user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/avatar/avatar-1.png')); ?>" data-title="Avatar" href="<?php echo e($user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/avatar/avatar-1.png')); ?>" title="Avtar" style="background-image: url(&quot;<?php echo e($user->id.$user->Documents->id_image ? Storage::url($user->id.$user->Documents->id_image) : asset('assets/img/avatar/avatar-1.png')); ?>&quot;);">
                             <div>Id Back</div>
                         </div>

                     </div>
                 </div>
                 <div class="card-footer text-right bg-whitesmoke br">
                     <?php if($user->Documents->status == 0): ?>
                     <button type="button" class="btn btn-danger view-details" data-url="<?php echo e(route('open_disapprove_modal',$user->id)); ?>">Disapprove</button>
                     <button type="button" class="btn btn-success approve_user" data-url="<?php echo e(route('approve-user')); ?>" data-id="<?php echo e($user->id); ?>">Approve</button>
                     <?php elseif($user->Documents->status == 1): ?>
                     <h5 class="text-center text-success"><?php echo e(__('User Approved')); ?> <i class="fa fa-check"></i></h5>
                     <?php else: ?>
                     <h5 class="text-center text-danger"><?php echo e(__('User Disapproved')); ?> <i class="fa fa-times"></i></h5>
                     <p class="text-center"><?php echo e(__('Reason')); ?><br><?php echo e($user->disapprove_reason); ?></p>
                     <?php endif; ?>
                 </div>
             </div>
             <?php endif; ?>


         </div>
     </div>
 </div>
 <div class="modal-footer bg-whitesmoke br">
     <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

 </div><?php /**PATH C:\laragon\www\virtual_card\resources\views/users/show.blade.php ENDPATH**/ ?>