<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>FOURCELL</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/pdf.css')); ?>" />
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap");

        .roboto-regular {
            font-family: "Roboto", sans-serif;
            font-weight: 400;
            font-style: normal;
        }

        .roboto-medium {
            font-family: "Roboto", sans-serif;
            font-weight: 500;
            font-style: normal;
        }

        .roboto-bold {
            font-family: "Roboto", sans-serif;
            font-weight: 700;
            font-style: normal;
        }

        .second-page .text-cont p {
            font-family: "Roboto", sans-serif;
            font-weight: 400;
        }
    </style>

</head>

<body>
    <div class="main-structure" style="max-width: 1550px; margin: 0 auto">
        <div class="main-landing-page">
            <div class="upper">
                <div class="logo">
                    <img src="<?php echo e(asset('assets/img/mainLogo.png')); ?>" alt="" />
                </div>
                <div class="text">
                    <h1 class="roboto-bold">
                        <?php echo e($user->kw); ?> KW <br />
                        Solar <br />
                        Proposal
                    </h1>
                </div>
                <div class="cover-image">
                    <img src="<?php echo e(asset('assets/img/bottom.png')); ?>" alt="" />
                </div>
            </div>
            <div class="bottom-landing-page">
                <img src="<?php echo e(asset('assets/img/bottom-bg.png')); ?>" alt="" />
                <div class="label">
                    <span class="roboto-regular">To : <?php echo e($user->name); ?>

                        <br>
                        <br>
                        <?php echo e($user->address); ?>

                    </span><span>Date:<?php echo e($user->date); ?></span>
                </div>
                <div class="label">
                    <span class="roboto-regular">To:</span><span>Ref No:<?php echo e($user->refrence); ?></span>
                </div>
            </div>
        </div>

        <div class="second-page">
            <div>
                <h2 class="roboto-bold">Welcome</h2>

                <div class="text-cont roboto-regular">
                    <?php echo $user->welcome_message; ?>

                </div>
            </div>
        </div>

        <div class="third-page">
            <div class="text">
                <h2 class="roboto-medium"><?php echo e($user->mw); ?></h2>
                <h2 class="roboto-medium"><?php echo e($user->customers); ?></h2>
                <h2 class="roboto-medium"><?php echo e($user->category); ?></h2>
            </div>
            <img src="<?php echo e(asset('assets/img/PAGE3-three.png')); ?>" alt="" />

        </div>

        <div class="fourth-page">
            <div class="image"></div>
            <div class="content">
                <img src="<?php echo e(asset('assets/img/detail.png')); ?>" alt="" />
                <div class="table">
                    <h2 class="heading roboto-bold">INDUSTRIAL OFFER</h2>
                    <table>
                        <tr class="header">
                            <th>System Description</th>
                            <th colspan="2">Capacity</th>
                            <th>Roof Type</th>
                            <th>Evacuation</th>
                        </tr>
                        <tr>
                            <td rowspan="2">Grid connected (Without Battery)</td>
                            <td>DC</td>
                            <td id="dc"><?php echo e($offerDetails->dc_capacity ?? 0); ?></td>
                            <td rowspan="2" id="rooftype"><?php echo e($offerDetails->roof_type ?? ''); ?></td>
                            <td rowspan="2" id="evacuation_val"><?php echo e($offerDetails->evacuation ?? ''); ?></td>
                        </tr>
                        <tr>
                            <td>AC</td>
                            <td id="ac"><?php echo e($offerDetails->ac_capacity ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Price per kw</td>
                            <td></td>
                            <td id="perkw"><?php echo e($offerDetails->per_kw ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Gross total</td>
                            <td></td>
                            <td id="gross_total"><?php echo e($offerDetails->gross_total ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">GEDA charge</td>
                            <td></td>
                            <td id="geda"><?php echo e($offerDetails->geda_charge ?? 0); ?></td>
                        </tr>

                        <tr>
                            <td colspan="3">Meter Charge</td>
                            <td></td>
                            <td id="meter"><?php echo e($offerDetails->meter_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Structure Charge</td>
                            <td></td>
                            <td id="structure"><?php echo e($offerDetails->structure_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Safety railing</td>
                            <td></td>
                            <td id="safety"><?php echo e($offerDetails->safety_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Manual cleaning system</td>
                            <td></td>
                            <td id="manualcharge"><?php echo e($offerDetails->manual_cleaning_charge ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Gross total</td>
                            <td></td>
                            <td id="grand_total"><?php echo e($offerDetails->gross_total ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">GST</td>
                            <td></td>
                            <td id="gst_amt"><?php echo e($offerDetails->gst ?? 0); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3">Net total</td>
                            <td></td>
                            <td id="net_total"><?php echo e($offerDetails->total_amount ?? 0); ?></td>
                        </tr>
                    </table>
                </div>

                <p class="para roboto-regular" style="width: 58%">
                    Total project cost of the plant =
                    <span style="font-weight: 700"><?php echo e($offerDetails->total_amount ?? 0); ?></span>
                </p>

                <div class="points" style="max-width: 60%; padding: 20px">
                    <?php echo $offerDetails->note; ?>

                </div>

                <div class="table">
                    <table>
                        <tr>
                            <th>Installment No.</th>
                            <th>Percentage of PO</th>
                            <th>Clause</th>
                        </tr>
                        <?php
                        $payment_terms = json_decode($offerDetails->payment_terms);
                        ?>
                        <?php if($payment_terms): ?>
                        <?php
                        $k = 1;
                        ?>
                        <?php $__currentLoopData = $payment_terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($k + 1); ?></td>
                            <td><?php echo e($terms->percentage); ?></td>
                            <td><?php echo e($terms->clause); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>

        <div class="fifth-page">
            <div>
                <table id="custom-table" style="margin: 0 auto">
                    <tr>
                        <th>No.</th>
                        <th>Name</th>
                        <th>KW</th>
                        <th>Location</th>
                        <th>Link</th>
                    </tr>
                    <!-- Add your rows here -->
                    <?php
                    $social_links = json_decode($offerDetails->social_links);
                    ?>
                    <?php if($social_links): ?>
                    <?php
                    $j = 1;
                    ?>
                    <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($j + 1); ?></td>
                        <td><?php echo e($terms->name); ?></td>
                        <td><?php echo e($terms->kw); ?></td>
                        <td><?php echo e($terms->location); ?></td>
                        <td><a href="<?php echo e($terms->link); ?>">Link</a></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>


                    <!-- Repeat the row structure for additional rows -->
                </table>
            </div>
        </div>

        <div class="sixth-page">
            <img
                src="<?php echo e(asset('assets/img/14.png')); ?>"
                alt=""
                style="width: 100%; margin-bottom: 30px" />
            <!-- <img src="<?php echo e(asset('assets/img/2.png')); ?>" alt="" class="bottom"> -->

            <div class="des">
                <table id="sixthpagetable" style="max-width: 60%; margin: 0 auto; font-weight: 600; position: relative; z-index: 99;">
                    <thead style="margin-top: 40px!important;">
                        <tr style="margin-top: 40px!important;">
                            <th>No.</th>
                            <th>Equipment</th>
                            <th>Company / Particulars</th>
                            <th>Technical Specification</th>
                        </tr>
                    </thead>
                    <tbody id="maint-body">
                        <?php if($products): ?>
                        <?php
                        $i = 1;
                        ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $compnies = json_decode($product->company);
                        ?>
                        <?php $__currentLoopData = $compnies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $q => $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <?php if($q < 1): ?>
                                <td rowspan="<?php echo e(count($compnies)); ?>"><?php echo e($i + 1); ?></td>
                                <td rowspan="<?php echo e(count($compnies)); ?>"><img src="<?php echo e(Storage::url( $product->equipment )); ?>" alt="" /></td>
                                <?php endif; ?>
                                <td><?php echo e($company->company); ?></td>
                                <td style="max-width: 400px">
                                    <?php echo $company->specification; ?>

                                </td>

                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </tbody>
                </table>
                <img id="bottom-img" src="<?php echo e(asset('assets/img/4.png')); ?>" alt="">
            </div>
        </div>

        <div class="seventh-page">
            <div class="visual">
                <h1 class="roboto-medium" style="margin-bottom: 20px; margin-left: 70px;">Yearly Saving</h1>
                <?php if(count($chartDetails) > 0): ?>
                <div style="width: 75%; margin: auto;" class="p-3">
                    <canvas id="netReturnChart"></canvas>
                </div>
                <?php endif; ?>
            </div>
            <img src="<?php echo e(asset('assets/img/save-img.png')); ?>" class="save-img" alt="">
        </div>

        <div class="eight-page">
            <img class="detailed-work" src="<?php echo e(asset('assets/img/detailed-work.png')); ?>" alt="">
            <table id="eightpagetable" style="width: 80%; margin: 20px auto; border-collapse: collapse; font-family: Arial, sans-serif; font-size: 14px;">
                <thead>
                    <tr style="background: linear-gradient(to right, #f76b1c, #fcdc4a); border: 1px solid #000;">
                        <th style="border: 1px solid #000; padding: 8px;">No.</th>
                        <th style="border: 1px solid #000; padding: 8px;">Scope of Work</th>
                        <th style="border: 1px solid #000; padding: 8px;">Foucell</th>
                        <th style="border: 1px solid #000; padding: 8px;">Customer</th>
                    </tr>
                </thead>
                <?php
                $work_scopes = json_decode($offerDetails->work_scopes);
                ?>
                <tbody class="eightPageContent">
                    <?php if($work_scopes): ?>
                    <?php
                    $k = 1;
                    ?>
                    <?php $__currentLoopData = $work_scopes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $work_scope): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;"><?php echo e($k + 1); ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?php echo e($work_scope->work); ?></td>
                        <td style="border: 1px solid #000; padding: 8px; text-align: center;"><?php echo e($work_scope->fourcell); ?></td>
                        <td style="border: 1px solid #000; padding: 8px;"><?php echo e($work_scope->customer); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>



                </tbody>
            </table>

        </div>

        <div class="ninth-page">
            <div class="left">
                <img class="execution" src="<?php echo e(asset('assets/img/execution.png')); ?>" alt="">
                <table class="execution-table">
                    <thead>
                        <tr>
                            <th>Job</th>
                            <th>Task</th>
                            <th>Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>Issuance of PO</td>
                            <td><?php echo e($offerDetails->po_issuance); ?></td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td><?php echo e($offerDetails->geda_registration); ?></td>
                            <td>15-20 Days</td>
                        </tr>
                        <tr>
                            <td colspan="3"><strong>Detailed Engineering</strong></td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Site Survey & Measurements</td>
                            <td rowspan="2"><?php echo e($offerDetails->detailed_engineering); ?></td>
                        </tr>
                        <tr>
                            <td>4</td>
                            <td>System Design & Engineering drawings</td>
                        </tr>
                        <tr>
                            <td colspan="3"><strong>Procurement, Inspection & Delivery</strong></td>
                        </tr>
                        <tr>
                            <td>5</td>
                            <td>Module mounting structures</td>
                            <td rowspan="8"><?php echo e($offerDetails->procurement); ?></td>
                        </tr>
                        <tr>
                            <td>6</td>
                            <td>Solar modules</td>
                        </tr>
                        <tr>
                            <td>7</td>
                            <td>Cables</td>
                        </tr>
                        <tr>
                            <td>8</td>
                            <td>Junction Boxes</td>
                        </tr>
                        <tr>
                            <td>9</td>
                            <td>Inverter</td>
                        </tr>
                        <tr>
                            <td>10</td>
                            <td>DCDB/ACDB</td>
                        </tr>
                        <tr>
                            <td>11</td>
                            <td>Earthing</td>
                        </tr>
                        <tr>
                            <td>12</td>
                            <td>Lightning Arrester & other items</td>
                        </tr>
                        <tr>
                            <!-- <!DOCTYPE html> -->
                            <!-- I/flutter (27199): ^ -->

                            <td colspan="3"><strong>Installation, Testing & Commissioning</strong></td>
                        </tr>
                        <tr>
                            <td>13</td>
                            <td>Site taking over</td>
                            <td rowspan="8"><?php echo e($offerDetails->installation_testing); ?></td>
                        </tr>
                        <tr>
                            <td>14</td>
                            <td>Marking & Construction of pedestals/foundation</td>
                        </tr>
                        <tr>
                            <td>15</td>
                            <td>Assembly & fixing of structures</td>
                        </tr>
                        <tr>
                            <td>16</td>
                            <td>Module Mounting over structures</td>
                        </tr>
                        <tr>
                            <td>17</td>
                            <td>Cabling & Termination</td>
                        </tr>
                        <tr>
                            <td>18</td>
                            <td>Inverter installations</td>
                        </tr>
                        <tr>
                            <td>19</td>
                            <td>DCDB/ACDB installation</td>
                        </tr>
                        <tr>
                            <td>20</td>
                            <td>Earthing & Lightning Arrester Installation</td>
                        </tr>
                        <tr>
                            <td>21</td>
                            <td>Pre-commissioning test</td>
                            <td rowspan="2"><?php echo e($offerDetails->pre_commissioning); ?></td>
                        </tr>
                        <tr>
                            <td>22</td>
                            <td>Commissioning & handing over of Plant</td>
                        </tr>
                    </tbody>
                </table>

                <div class="ninth-bottom">
                    <P id="ninth-bottom-heading" class="roboto-medium" style="margin-bottom: 30px;">General terms and Conditions for the Proposal</P>
                    <div class="ninth-bottom-content">
                        <p class="roboto-regular">
                            <?php echo $offerDetails->general_terms; ?>

                        </p>
                    </div>
                </div>

            </div>
            <div class="right" style="width: 100%;">
                <img class="windmil" src="<?php echo e(asset('assets/img/windmil.png')); ?>" alt="">
            </div>
        </div>

        <div class="tenth-page">
            <img src="<?php echo e(asset('assets/img/lastPage.jpg')); ?>" alt="">
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/0.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.3.1/jspdf.umd.min.js"></script>
<?php if($chartDetails): ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Convert PHP data to JavaScript
    const dataFromServer = <?php echo json_encode($chartDetails, 15, 512) ?>;

    // Extract labels (years) and data points (net_return)
    const labels = dataFromServer.map(item => item.year);
    const data = dataFromServer.map(item => item.net_return);

    const ctx = document.getElementById('netReturnChart').getContext('2d');
    const netReturnChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Net Return',
                data: data,
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'blue',
                borderWidth: 1,
                barThickness: 10
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
<?php endif; ?>
<script>
    $(document).ready(function() {
        // Capture the full page screenshot on page load
        //set timeout to wait for the page to load
        setTimeout(function() {
            html2canvas(document.body, {
                onrendered: function(canvas) {
                    var imageData = canvas.toDataURL('image/png');

                    // Send the captured image data to the backend via AJAX
                    $.ajax({
                        url: '<?php echo e(url("save-screenshot")); ?>',
                        method: 'POST',
                        data: {
                            id: '<?php echo e($user->id); ?>',
                            image: imageData,
                            _token: $('meta[name="csrf-token"]').attr('content') // Laravel CSRF token
                        },
                        success: function(response) {
                            console.log('Screenshot saved and PDF generated.');
                        },
                        error: function() {
                            console.error('Failed to save the screenshot.');
                        }
                    });
                }
            });
        }, 5000);


    });
</script>


</html><?php /**PATH C:\laragon\www\fourcell\resources\views/dashboard/index.blade.php ENDPATH**/ ?>