<?php $__env->startSection('title', 'Social Links'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Social Links</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('users.index')); ?>">Clients</a></div>
                <div class="breadcrumb-item">Social Links</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <?php if($id != ''): ?>
                <div class="col-md-12 m-auto">
                    <div class="card p-4">
                        <div card="card-header ">
                            <h6 class="text-center p-3">Social Links</h6>
                        </div>
                        <?php echo Form::model($offerDetails, ['route' => ['update-social-links', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']); ?>


                        <div class="row">


                            <div class="form-group col-md-12">

                                <?php
                                $social_links = json_decode($offerDetails->social_links);
                                ?>
                                <div class="col-md-12 mt-auto p-3">

                                    <table border="2" class="text-center w-100" id="repeater-table">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Name</th>
                                                <th>KW</th>
                                                <th>Location</th>
                                                <th>Link</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if($social_links): ?>
                                            <input type="hidden" name="payment_terms_count" id="payment_terms_count" value="<?php echo e(count($social_links)); ?>">
                                            <?php
                                            $k = 1;
                                            ?>
                                            <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $terms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($k + 1); ?>


                                                </td>
                                                <td><input type="text" class="text-center form-control" name="name[]" value="<?php echo e($terms->name); ?>" required></td>
                                                <td><input type="text" class="text-center form-control" name="kw[]" value="<?php echo e($terms->kw); ?>" required></td>
                                                <td><input type="text" class="text-center form-control" name="location[]" value="<?php echo e($terms->location); ?>" required></td>
                                                <td><input type="text" class="text-center form-control" name="link[]" value="<?php echo e($terms->link); ?>" required></td>
                                                <?php if($k == 0): ?>
                                                <td><button type="button" class=" btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td>
                                                <?php else: ?>
                                                <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
                                                <?php endif; ?>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                            <input type="hidden" name="payment_terms_count" id="payment_terms_count" value="1">

                                            <tr>
                                                <td>1</td> <!-- First Installment No. -->
                                                <td><input type="text" class="text-center form-control" name="name[]" required></td>
                                                <td><input type="text" class="text-center form-control" name="kw[]" required></td>
                                                <td><input type="text" class="text-center form-control" name="location[]" required></td>
                                                <td><input type="url" class="text-center form-control" name="link[]" required></td>
                                                <td><button type="button" class="btn btn-sm btn-info" id="add-row"><i class="fa fa-plus"></i></button></td> <!-- First row has no remove button -->
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>

                                </div>
                            </div>


                        </div>


                        <div class="btn-flt">
                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                        <?php echo Form::close(); ?>


                    </div>
                </div>
                <?php else: ?>

                <div class="col-md-6 m-auto">
                    <div class="form-group col-md-6">
                        <?php echo e(Form::label('user_select', __('Select Client'))); ?>

                        <div class="input-group">
                            <?php echo Form::select('user_select', $users, null, ['class' => 'form-control select2', 'required', 'placeholder' => 'Select Client']); ?>

                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <button type="button " id="submit-client" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                <?php endif; ?>
            </div>
        </div>
    </section>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script>
    $(document).ready(function() {

        var rowCount = $('#payment_terms_count').val(); // Initialize row count for Installment No.
        var maxRows = 6; // Initialize row count for Installment No.

        // Function to add a new row
        $('#add-row').click(function() {

            rowCount++;
            var newRow = `<tr>
            <td>${rowCount}</td> <!-- Auto increment Installment No -->
            <td><input type="text" class="text-center form-control" name="name[]" required></td>
            <td><input type="text" class="text-center form-control" name="kw[]" required></td>
            <td><input type="text" class="text-center form-control" name="location[]" required></td>
            <td><input type="url"  class="text-center form-control" name="link[]" required></td>
            <td><button type="button" class="remove-row btn btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>
        </tr>`;
            $('#repeater-table tbody').append(newRow);

        });

        // Function to remove a row and update Installment Nos
        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            updateInstallmentNumbers();
        });

        // Function to update Installment Nos after a row is removed
        function updateInstallmentNumbers() {
            rowCount = 0; // Reset row count
            $('#repeater-table tbody tr').each(function() {
                rowCount++;
                $(this).find('td:first').text(rowCount); // Update Installment No text
            });
        }

        // Form submission
        $('#repeater-form').submit(function(e) {
            e.preventDefault();
            alert("Form submitted!");
            // Here you can handle the form data using AJAX or any other method
        });

        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "<?php echo e(url('social-links')); ?>/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });




    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/fourcell.nexprism.com/resources/views/users/social_links.blade.php ENDPATH**/ ?>