<?php $__env->startSection('title', 'Issued Cards'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Issued Cards</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Issued Cards</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row ">
                <div class="col-12">
                    <div class="card p-3">
                        <div class="table table-striped dataTable no-footer">
                            <?php echo e($dataTable->table(['width' => '100%'])); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php echo $__env->make('layouts.includes.datatable_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .error_red {
        width: 100%;
        margin-top: 0.25rem;
        font-size: 80%;
        color: #dc3545;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('javascript'); ?>
<?php echo $__env->make('layouts.includes.datatable_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo e($dataTable->scripts()); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.14.0/jquery.validate.min.js"></script>
<script>
    $(document).on('click', '#submitButton', function() {

        // validation();
        $("#myForm").validate({
            rules: {
                amount: {
                    required: true,
                    number: true,
                    min: 1
                },

            },
            submitHandler: function(form) {
                // alert("Form submitted successfully!");
                submitFunction();
                // You can perform additional actions here, like AJAX submission
                // Close the modal after submission

            },
            errorPlacement: function(error, element) {
                error.appendTo(element.next(".error_red"));

            }

            // Specify the function to be called when the form is submitted

        });
    })

    // Initialize form validation


    // Attach the validation logic to the click event of the button


    function submitFunction() {
        // alert('here')
        $("#spinner-div").show();
        var x_url = $('#submitButton').data('url');
        // alert(x_url);
        var data = {
            'id': $('#submitButton').attr('data-id'),
            'amount': $('#amount').val(),
            'type': $('#submitButton').attr('data-type')

        };
        $.ajaxSetup({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token" ]').attr("content")
            }
        });
        $.ajax({
            url: x_url,
            type: "POST",
            data: data,
            success: function(res) {
                console.log(res);
                if (res.is_success) {
                    iziToast.success({
                        title: '<?php echo e(__('Success')); ?>',
                        message: res.message,
                        position: 'topRight'
                    });
                    $('#commonModal').modal('hide');
                } else {
                    $('#err_msg').html(res.message)
                }
            },
            complete: function() {
                $("#spinner-div").hide(); //Request is complete so hide spinner
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/cards/index.blade.php ENDPATH**/ ?>