<?php $__env->startSection('title', 'Execution Plans'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Execution Plans</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('users.index')); ?>">Clients</a></div>
                <div class="breadcrumb-item">Execution Plans</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <?php if($id != ''): ?>
                <div class="col-md-12 m-auto">
                    <div class="card p-4">
                        <div card="card-header ">
                            <h6 class="text-center p-3">Execution Plans</h6>
                        </div>
                        <?php echo Form::model($offerDetails, ['route' => ['update-execution-plans', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']); ?>


                        <div class="row">


                            <div class="form-group col-md-12">

                                <?php
                                $work_scopes = json_decode($offerDetails->work_scopes);
                                ?>
                                <div class="col-md-12 mt-auto p-3">

                                    <table border="2" class="text-center w-100" id="repeater-table">
                                        <thead class="bg-primary text-white">
                                            <tr>
                                                <th>Job</th>
                                                <th>Task</th>
                                                <th>Time</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>1</td>
                                                <td>Issuance of PO</td>
                                                <td>
                                                    <input type="text" class="text-center form-control" name="po_issuance" value="<?php echo e($offerDetails->po_issuance); ?>" required>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>2</td>
                                                <td>GEDA Registration and CEI Approval</td>
                                                <td>
                                                    <input type="text" class="text-center form-control" name="geda_registration" value="<?php echo e($offerDetails->geda_registration); ?>" required>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="3"><strong>Detailed Engineering</strong></td>
                                            </tr>
                                            <tr>
                                                <td>3</td>
                                                <td>Site Survey & Measurements</td>
                                                <td rowspan="2">
                                                    <input type="text" class="text-center form-control" name="detailed_engineering" value="<?php echo e($offerDetails->detailed_engineering); ?>" required>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>4</td>
                                                <td>System Design & Engineering drawings</td>
                                            </tr>
                                            <tr>
                                                <td colspan="3"><strong>Procurement, Inspection & Delivery</strong></td>
                                            </tr>
                                            <tr>
                                                <td>5</td>
                                                <td>Module mounting structures</td>
                                                <td rowspan="8">
                                                    <input type="text" class="text-center form-control" name="procurement" value="<?php echo e($offerDetails->procurement); ?>" required>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>6</td>
                                                <td>Solar modules</td>
                                            </tr>
                                            <tr>
                                                <td>7</td>
                                                <td>Cables</td>
                                            </tr>
                                            <tr>
                                                <td>8</td>
                                                <td>Junction Boxes</td>
                                            </tr>
                                            <tr>
                                                <td>9</td>
                                                <td>Inverter</td>
                                            </tr>
                                            <tr>
                                                <td>10</td>
                                                <td>DCDB/ACDB</td>
                                            </tr>
                                            <tr>
                                                <td>11</td>
                                                <td>Earthing</td>
                                            </tr>
                                            <tr>
                                                <td>12</td>
                                                <td>Lightning Arrester & other items</td>
                                            </tr>
                                            <tr>
                                                <td colspan="3"><strong>Installation, Testing & Commissioning</strong></td>
                                            </tr>
                                            <tr>
                                                <td>13</td>
                                                <td>Site taking over</td>
                                                <td rowspan="8">
                                                    <input type="text" class="text-center form-control" name="installation_testing" value="<?php echo e($offerDetails->installation_testing); ?>" required>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>14</td>
                                                <td>Marking & Construction of pedestals/foundation</td>
                                            </tr>
                                            <tr>
                                                <td>15</td>
                                                <td>Assembly & fixing of structures</td>
                                            </tr>
                                            <tr>
                                                <td>16</td>
                                                <td>Module Mounting over structures</td>
                                            </tr>
                                            <tr>
                                                <td>17</td>
                                                <td>Cabling & Termination</td>
                                            </tr>
                                            <tr>
                                                <td>18</td>
                                                <td>Inverter installations</td>
                                            </tr>
                                            <tr>
                                                <td>19</td>
                                                <td>DCDB/ACDB installation</td>
                                            </tr>
                                            <tr>
                                                <td>20</td>
                                                <td>Earthing & Lightning Arrester Installation</td>
                                            </tr>
                                            <tr>
                                                <td>21</td>
                                                <td>Pre-commissioning test</td>
                                                <td rowspan="2">
                                                    <input type="text" class="text-center form-control" name="pre_commissioning" value="<?php echo e($offerDetails->pre_commissioning); ?>" required>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>22</td>
                                                <td>Commissioning & handing over of Plant</td>
                                            </tr>
                                        </tbody>

                                    </table>








                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <?php echo e(Form::label('general_terms', __('General Terms'))); ?>

                                
                                    <?php echo Form::textarea('general_terms', null, ['class' => 'form-control', 'required','id' => 'general_terms']); ?>

                                
                            </div>


                        </div>


                        <div class="btn-flt">
                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                        <?php echo Form::close(); ?>


                    </div>
                </div>
                <?php else: ?>

                <div class="col-md-6 m-auto">
                    <div class="form-group col-md-6">
                        <?php echo e(Form::label('user_select', __('Select Client'))); ?>

                        <div class="input-group">
                            <?php echo Form::select('user_select', $users, null, ['class' => 'form-control select2', 'required', 'placeholder' => 'Select Client']); ?>

                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <button type="button " id="submit-client" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                <?php endif; ?>
            </div>
        </div>
    </section>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script>
    $(document).ready(function() {


        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "<?php echo e(url('execution-plans')); ?>/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });

        $('#general_terms').summernote({
            height: 200, // set editor height
            toolbar: [
                ['font', ['bold', 'underline', 'clear']],
                ['para', ['ul', 'ol', 'paragraph']],
            ]
        });




    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/fourcell.nexprism.com/resources/views/users/execution_plans.blade.php ENDPATH**/ ?>