<?php $__env->startSection('title', 'Regenerate Chart Details'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Regenerate Chart Details </h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('users.index')); ?>">Clients</a></div>
                <div class="breadcrumb-item">Regenerate Chart Details</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <?php if($id != ''): ?>
                <div class="col-md-12 m-auto">
                    <div class="card p-4">
                        <div card="card-header ">
                            <h6 class="text-center p-3">Regenerate Chart </h6>


                        </div>
                        <?php echo Form::model($chartDetails, ['route' => ['update-chart-details', $user->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']); ?>


                        <div class="row">
                            <div class="form-group col-md-12">
                                <div class="col-md-12 mt-auto p-3">

                                    <table border="2" class="text-center w-100" id="repeater-table">
                                        <thead>
                                            <tr>
                                                <th>KW</th>
                                                <th colspan="9" class="text-center">
                                                    <?php echo Form::number('kw', $user->kw , ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW','id' => 'kw']); ?>

                                                </th>
                                            </tr>
                                            <tr>
                                                <td colspan="10"></td>
                                            </tr>
                                            <tr>
                                                <th>No</th>
                                                <th>PER DAY*365 DAY</th>
                                                <th>%</th>
                                                <th>Unit</th>
                                                <th>Net Unit</th>
                                                <th>Unit Cost</th>
                                                <th>Gross Return</th>
                                                <th>
                                                    Bank Charge
                                                    <?php echo Form::number('bank_ch', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => '1.5 / 1.1','id' => 'bank_ch']); ?>

                                                </th>
                                                <th>Maintenance Cost</th>
                                                <th>Net Return</th>
                                            </tr>
                                        </thead>
                                        <tbody>


                                            <tr>
                                                <td>1</td>
                                                <td>
                                                    <?php echo Form::number('yearly_kw', ($user->kw * 4) * 365 , ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Price Per KW','id' => 'yearly_kw']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('percentage', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Enter Percentage','id' => 'percentage']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('unit', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit','id'=> 'unit']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('net_unit', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Unit','id' => 'net_unit']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('unit_cost', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Unit Cost','id' => 'unit_cost']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('gross_return', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Gross Return','id' => 'gross_return']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('bank_charge', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Bank Charge','id' => 'bank_charge']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('maintenance_cost', null, ['class' => 'form-control','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Maintenance Cost','id' => 'maintenance_cost']); ?>

                                                </td>
                                                <td>
                                                    <?php echo Form::number('net_return', null, ['class' => 'form-control','readonly'=>'readonly','min' => '0', 'step' => '0.01', ' required', 'placeholder' => 'Net Return','id' => 'net_return']); ?>

                                                </td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>




                        </div>

                        <?php if(count($chartDetails) > 0 && $chartDetails[0]->kw != $user->kw): ?>
                        <div class="btn-flt">
                            <div class="alert alert-success">
                                This Client KW changed to <?php echo e(($chartDetails[0]->kw)? $chartDetails[0]->kw : 0); ?>kw to <?php echo e($user->kw); ?>kw. Please update 27 Year data.
                            </div>
                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary">Update 27 Year data</button>
                        </div>
                        <?php endif; ?>
                        
                        <div class="btn-flt">
                            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary">Regenerate 27 Year data</button>
                        </div>
                        
                        <?php echo Form::close(); ?>


                    </div>
                </div>

                <?php endif; ?>
            </div>
        </div>
    </section>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


<?php if($id != '' && count($chartDetails) > 0 && $chartDetails[0]->kw == $user->kw): ?>
<script>
    // Convert PHP data to JavaScript
    const dataFromServer = <?php echo json_encode($chartDetails, 15, 512) ?>;

    // Extract labels (years) and data points (net_return)
    const labels = dataFromServer.map(item => item.year);
    const data = dataFromServer.map(item => item.net_return);

    const ctx = document.getElementById('netReturnChart').getContext('2d');
    const netReturnChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Net Return',
                data: data,
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'blue',
                borderWidth: 1,
                barThickness: 10
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
<?php endif; ?>
<script>
    $(document).ready(function() {
        recalculateValues();
        $('#submit-client').click(function() {
            var selectedClient = $('select[name="user_select"]').val();
            if (selectedClient) {
                window.location.href = "<?php echo e(url('chart-details')); ?>/" + selectedClient;
            } else {
                alert('Please select a client.');
            }
        });

        function recalculateValues() {
            var kw = $('#kw').val();
            var percentage = $('#percentage').val();
            var cost_unit = $('#unit_cost').val();
            var bank_ch = $('#bank_ch').val();
            var maintenance_cost = $('#maintenance_cost').val();
            var yearly_kw = (kw * 4) * 365;
            var unit = yearly_kw * (percentage / 100);
            var net_unit = yearly_kw - unit;
            var gross_return = net_unit * cost_unit;
            var bank_charge = Math.round(net_unit * bank_ch);
            var net_return = Math.round(gross_return - bank_charge - maintenance_cost);
            // alert(yearly_kw);
            // alert(percentage);

            $('#unit').val(unit);
            $('#net_unit').val(net_unit);
            $('#gross_return').val(gross_return);
            $('#bank_charge').val(bank_charge);
            $('#net_return').val(net_return);
        }


        $('#percentage, #unit_cost, #bank_ch, #maintenance_cost').on('input', recalculateValues);






    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/fourcell.nexprism.com/resources/views/users/regenerate_chart_details.blade.php ENDPATH**/ ?>