<?php $__env->startSection('content'); ?>

<section class="section">
    <div class="container mt-5">
      <div class="row">
        <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-4 offset-xl-4">
          <div class="login-brand">
            <img src="<?php echo e(asset('assets/img/logo.png')); ?>" alt="logo" width="200" class="">
          </div>

          <div class="card card-primary">
            <div class="card-header"><h4>Login</h4></div>

            <div class="card-body">
                <form method="POST" action="<?php echo e(route('login')); ?>">
                    <?php echo csrf_field(); ?>
                <div class="form-group">
                  <label for="email">Email</label>
                  <input id="email" type="text" class="form-control " name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>

                  <div class="invalid-feedback">
                    Please fill in your email
                  </div>
                </div>

                <div class="form-group">
                  <div class="d-block">
                      <label for="password" class="control-label">Password</label>
                    <div class="float-right">
                        <?php if(Route::has('password.request')): ?>
                        <!-- <a class="btn btn-link" href="<?php echo e(route('password.request')); ?>">
                            <?php echo e(__('Forgot Password?')); ?>

                        </a> -->
                    <?php endif; ?>
                    </div>
                  </div>
                  <input id="password" type="password" class="form-control " name="password" required autocomplete="current-password">
                  <div class="invalid-feedback">
                    please fill in your password
                  </div>
                </div>

               

                <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-lg btn-block" tabindex="4">
                    Login
                  </button>
                
                </div>
              </form>
              
           

            </div>
          </div>
          <div class="mt-5 text-muted text-center">
            <!-- Don't have an account? <a href="<?php echo e(route('register')); ?>">Create One</a> -->
          </div>
          <div class="simple-footer">
            Copyright &copy; Nexprism 2024
          </div>
        </div>
      </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('javascript'); ?>
  <script>
    <?php if( session('errors')): ?>
    iziToast.error({
        title: '<?php echo e(__('Error!')); ?>',
        message: "<?php echo e(session('errors')->first()); ?>",
        position: 'topRight'
    });
<?php endif; ?>
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/fourcell.nexprism.com/resources/views/auth/login.blade.php ENDPATH**/ ?>