
<?php $__env->startSection('title', 'Support & contact'); ?>
<?php $__env->startSection('content'); ?>

<section class="banner-inner">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-sm-7 text-center text-sm-start">
                <div class="title">
                    <h2><?php echo e(Utility::getcontents('banner_title','support-page')); ?></h2>
                </div>
            </div>
            <div class="col-sm-5 d-none d-sm-block text-end">
                <div class="image-wrapper lh-0">
                    <img src="<?php echo e(Storage::url('content/'.Utility::getcontents('banner_image','support-page'))); ?>" alt="Image" />
                </div>
            </div>
        </div>
    </div>
</section>
<section class="questions-section">
    <div class="container">
        <div class="questions">
            <div class="row">
                <div class="col-xl-5">
                    <div class="main-title mb-xl-0">
                        <h2>Still have questions ?</h2>
                        <p class="mb-0">We are here to help you</p>
                    </div>
                </div>
                <div class="col-xl-7">
                    <ul class="contact">
                        <li>
                            <div class="icon"><img src="<?php echo e(asset('assets/front/images/icons/location.svg')); ?>" alt="Map"></div>
                            <div class="content">
                                <p><?php echo e(Utility::getsettings('address')); ?></p>
                                <h6>Headquarters</h6>
                            </div>
                        </li>
                        <li>
                            <div class="icon"><img src="<?php echo e(asset('assets/front/images/icons/email.svg')); ?>" alt="Map"></div>
                            <div class="content">
                                <p> <a href="mailto: <?php echo e(Utility::getsettings('support_email')); ?>"><?php echo e(Utility::getsettings('support_email')); ?></a> </p>
                                <h6>Support Email</h6>
                            </div>
                        </li>
                    </ul>
                    <div class="social-media">
                        <ul>
                            <li> <a href="<?php echo e(Utility::getsettings('facebbok_link')); ?>"> <img src="<?php echo e(asset('assets/front/images/icons/fb.svg')); ?>" alt="Icon"> Facebook</a></li>
                            <li> <a href="<?php echo e(Utility::getsettings('twitter_link')); ?>"> <img src="<?php echo e(asset('assets/front/images/icons/tw.svg')); ?>" alt="Icon"> Twitter</a></li>
                            <li> <a href="<?php echo e(Utility::getsettings('lindedln_link')); ?>"> <img src="<?php echo e(asset('assets/front/images/icons/lnk.svg')); ?>" alt="Icon"> LinkedIn</a></li>
                            <li> <a href="<?php echo e(Utility::getsettings('instagram_link')); ?>"> <img src="<?php echo e(asset('assets/front/images/icons/insta.svg')); ?>" alt="Icon"> Instagram</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="categories">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <div class="tab-main">
                    <div class="title">
                        <h2>Categories</h2>
                    </div>
                    <div class="nav flex-column nav-pills me-3" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        <?php if($faq_categories): ?>
                        <?php $__currentLoopData = $faq_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button class="nav-link <?php echo e($key == 0?'active':''); ?> " id="v-pills-<?php echo e($category->id); ?>-tab" data-bs-toggle="pill" data-bs-target="#v-pills-<?php echo e($category->id); ?>" type="button" role="tab" aria-controls="v-pills-<?php echo e($category->id); ?>" aria-selected="true"><?php echo e($category->name); ?></button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <?php if($faq_categories && $faqs): ?>
                <div class="tab-content" id="v-pills-tabContent">
                    <?php $__currentLoopData = $faq_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="tab-pane fade <?php echo e($key == 0?'show active':''); ?> " id="v-pills-<?php echo e($cat->id); ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo e($cat->id); ?>-tab" tabindex="0">
                        <div class="main-title">
                            <h2><?php echo e($cat->name); ?></h2>
                        </div>
                        <div id="accordion<?php echo e($cat->id); ?>" class="myaccordion">
                            <?php $__currentLoopData = $cat->Faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card">
                                <div class="card-header" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($faq->id); ?>" aria-expanded="false" aria-controls="collapse<?php echo e($faq->id); ?>" id="heading1">
                                    <h2 class="mb-0">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div><?php echo e($faq->question); ?></div>
                                            <i class="icon"></i>
                                        </div>
                                    </h2>
                                </div>
                                <div id="collapse<?php echo e($faq->id); ?>" class="collapse" aria-labelledby="heading1" data-bs-parent="#accordion<?php echo e($cat->id); ?>">
                                    <div class="card-body">
                                        <?php echo e($faq->answer); ?>

                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<section class="cta section-gap">
    <div class="container">
        <div class="cta-wrapper">
            <div class="row align-items-center">
                <div class="col-xl-5 col-lg-6 offset-lg-1 order-2 order-lg-1">
                    <div class="main-title">
                        <h2>It's your turn to play</h2>
                        <p>
                            Pay anything you want online and send money to your loved
                            ones without limits or restrictions.
                        </p>
                    </div>
                    <div class="row g-4 mb-4 mb-sm-5">
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="<?php echo e(asset('assets/front/images/icons/tick.svg')); ?>" alt="Tick" /></span>Fast transactions
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="<?php echo e(asset('assets/front/images/icons/tick.svg')); ?>" alt="Tick" /></span>Secure data
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="<?php echo e(asset('assets/front/images/icons/tick.svg')); ?>" alt="Tick" /></span>Virtual wallet
                                </h6>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="cta-card">
                                <h6>
                                    <span><img src="<?php echo e(asset('assets/front/images/icons/tick.svg')); ?>" alt="Tick" /></span>Permanent assistance
                                </h6>
                            </div>
                        </div>
                    </div>
                    <div class="btn-wrapper">
                        <a href="#"><img src="<?php echo e(asset('assets/front/images/icons/play-store.svg')); ?>" alt="Play Store" /></a>
                        <a href="#"><img src="<?php echo e(asset('assets/front/images/icons/app-store.svg')); ?>" alt="App Store" /></a>
                        <a href="#"><img src="<?php echo e(asset('assets/front/images/icons/app-gallery.svg')); ?>" alt="App Gallery" /></a>
                    </div>
                </div>
                <div class="col-lg-4 offset-xl-1 order-1 order-lg-2">
                    <div class="img-wrapper lh-0">
                        <img src="<?php echo e(asset('assets/front/images/cta.png')); ?>" alt="Images" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/front/support.blade.php ENDPATH**/ ?>