<?php $__env->startSection('title', 'Faqs'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Edit Faq</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item active"><a href="<?php echo e(route('faqs.index')); ?>">Faqs</a></div>
                <div class="breadcrumb-item">Edit Faq</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-md-8 m-auto">
                    <div class="card p-4">
                        <?php echo Form::model($faq, ['route' => ['faqs.update', $faq->id], 'method' => 'Put', 'enctype' => 'multipart/form-data']); ?>


                        <div class="row">
                            <div class="form-group col-md-6">
                                <?php echo e(Form::label('category', __('Select Category'))); ?>

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-list"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::select('category_id', $faq_categories, $faq->category_id, ['class' => 'form-control']); ?>

                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <?php echo e(Form::label('question', __('Question'))); ?>

                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fas fa-question-circle"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::text('question', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Question']); ?>

                                </div>
                            </div>


                            <div class="form-group col-md-12">
                                <?php echo e(Form::label('answer', __('Answer'))); ?>

                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fa fa-reply"></i>
                                        </div>
                                    </div>
                                    <?php echo Form::textarea('answer', null, ['class' => 'form-control', ' required', 'placeholder' => 'Enter Answer']); ?>

                                </div>
                            </div>
                        </div>


                        <div class="btn-flt">
                            <a href="<?php echo e(route('faqs.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php echo $__env->make('layouts.includes.datatable_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.repeater/1.2.1/jquery.repeater.min.js"></script>
<script>
    $(".repeater").repeater();
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/faq/edit.blade.php ENDPATH**/ ?>