<?php $__env->startSection('title', 'Users'); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Users List</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?php echo e(route('home')); ?>">Dashboard</a></div>
                <div class="breadcrumb-item">Users</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row ">
                <div class="col-12">
                    <div class="card p-3">
                        <div class="table table-striped dataTable no-footer">
                            <?php echo e($dataTable->table(['width' => '100%'])); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php echo $__env->make('layouts.includes.datatable_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .error_red {
        width: 100%;
        margin-top: 0.25rem;
        font-size: 80%;
        color: #dc3545;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('javascript'); ?>
<script src="<?php echo e(asset('assets/modules/chocolat/jquery.chocolat.min.js')); ?>"></script>
<?php echo $__env->make('layouts.includes.datatable_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.14.0/jquery.validate.min.js"></script>
<?php echo e($dataTable->scripts()); ?>

<script>
    $(document).on('click', '.approve_user', function() {
        // alert('here')
        $("#spinner-div").show();
        var x_url = $(this).data('url');
        // alert(x_url);
        var data = {
            'user_id': $(this).attr('data-id'),
        };
        $.ajaxSetup({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token" ]').attr("content")
            }
        });
        $.ajax({
            url: x_url,
            type: "POST",
            data: data,
            success: function(res) {
                console.log(res);
                if (res.is_success) {
                    iziToast.success({
                        title: '<?php echo e(__('Success ')); ?>',
                        message: res.message,
                        position: 'topRight'
                    });
                    $('#commonModal').modal('hide');
                } else {
                    // $('#err_msg').html(res.message)
                    iziToast.error({
                        title: '<?php echo e(__('Error ')); ?>',
                        message: res.message,
                        position: 'topRight'
                    });
                }
            },
            complete: function() {
                $("#spinner-div").hide(); //Request is complete so hide spinner
            }
        });
    });

    $(document).on('click', '#submitButton', function() {

        // validation();
        $("#myForm").validate({
            rules: {
                disapprove_reason: {
                    required: true,
                },

            },
            submitHandler: function(form) {
                submitFunction();
            },
            errorPlacement: function(error, element) {
                error.appendTo(element.next(".error_red"));
            }
        });
    })

    // Initialize form validation


    // Attach the validation logic to the click event of the button


    function submitFunction() {
        // alert('here')
        $("#spinner-div").show();
        var x_url = $('#submitButton').data('url');
        // alert(x_url);
        var data = {
            'user_id': $('#submitButton').attr('data-id'),
            'disapprove_reason': $('#disapprove_reason').val(),
        };
        $.ajaxSetup({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token" ]').attr("content")
            }
        });
        $.ajax({
            url: x_url,
            type: "POST",
            data: data,
            success: function(res) {
                console.log(res);
                if (res.is_success) {
                    iziToast.success({
                        title: '<?php echo e(__('Success ')); ?>',
                        message: res.message,
                        position: 'topRight'
                    });
                    $('#commonModal').modal('hide');
                } else {
                    $('#err_msg').html(res.message)
                }
            },
            complete: function() {
                $("#spinner-div").hide(); //Request is complete so hide spinner
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\virtual_card\resources\views/users/index.blade.php ENDPATH**/ ?>